/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkDelegate;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.ScopedAnalyzer;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AddWorkDelegate
implements LuceneWorkDelegate {
    private static final Logger log = LoggerFactory.make();
    private final Workspace workspace;

    AddWorkDelegate(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public void performWork(LuceneWork work, IndexWriter writer) {
        Class entityType = work.getEntityClass();
        DocumentBuilderIndexedEntity documentBuilder = this.workspace.getDocumentBuilder(entityType);
        Map<String, String> fieldToAnalyzerMap = ((AddLuceneWork)work).getFieldToAnalyzerMap();
        ScopedAnalyzer analyzer = (ScopedAnalyzer)documentBuilder.getAnalyzer();
        analyzer = this.updateAnalyzerMappings(analyzer, fieldToAnalyzerMap);
        if (log.isTraceEnabled()) {
            log.trace("add to Lucene index: {}#{}:{}", new Object[]{entityType, work.getId(), work.getDocument()});
        }
        try {
            writer.addDocument(work.getDocument(), analyzer);
            this.workspace.incrementModificationCounter(1);
        }
        catch (IOException e) {
            throw new SearchException("Unable to add to Lucene index: " + entityType + "#" + work.getId(), e);
        }
    }

    private ScopedAnalyzer updateAnalyzerMappings(ScopedAnalyzer scopedAnalyzer, Map<String, String> fieldToAnalyzerMap) {
        if (fieldToAnalyzerMap == null || fieldToAnalyzerMap.isEmpty()) {
            return scopedAnalyzer;
        }
        ScopedAnalyzer analyzerClone = scopedAnalyzer.clone();
        for (Map.Entry<String, String> entry : fieldToAnalyzerMap.entrySet()) {
            Analyzer analyzer = this.workspace.getAnalyzer(entry.getValue());
            if (analyzer == null) {
                log.warn("Unable to retrieve named analyzer: " + entry.getValue());
                continue;
            }
            analyzerClone.addScopedAnalyzer(entry.getKey(), analyzer);
        }
        return analyzerClone;
    }

    @Override
    public void logWorkDone(LuceneWork work, MassIndexerProgressMonitor monitor) {
        monitor.documentsAdded(1L);
    }
}

