/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import org.apache.solr.analysis.TokenizerFactory;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FieldMapping;
import org.hibernate.search.cfg.PropertyDescriptor;
import org.hibernate.search.cfg.PropertyMapping;
import org.hibernate.search.cfg.SearchMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainedInMapping {
    private final SearchMapping mapping;
    private final PropertyDescriptor property;
    private final EntityDescriptor entity;

    public ContainedInMapping(SearchMapping mapping, PropertyDescriptor property, EntityDescriptor entity) {
        this.mapping = mapping;
        this.property = property;
        this.entity = entity;
        HashMap<String, Object> containedIn = new HashMap<String, Object>();
        property.setContainedIn(containedIn);
    }

    public FieldMapping field() {
        return new FieldMapping(this.property, this.entity, this.mapping);
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.mapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerFactory, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }
}

