/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.MapFieldSelector;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.query.QueryHits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentExtractor {
    private final SearchFactoryImplementor searchFactoryImplementor;
    private final String[] projection;
    private final QueryHits queryHits;
    private FieldSelector fieldSelector;
    private boolean allowFieldSelection;

    public DocumentExtractor(QueryHits queryHits, SearchFactoryImplementor searchFactoryImplementor, String[] projection, Set<String> idFieldNames, boolean allowFieldSelection) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.projection = projection;
        this.queryHits = queryHits;
        this.allowFieldSelection = allowFieldSelection;
        this.initFieldSelection(projection, idFieldNames);
    }

    private void initFieldSelection(String[] projection, Set<String> idFieldNames) {
        int projectionSize;
        int n = projectionSize = projection != null && projection.length != 0 ? projection.length : 0;
        if (projectionSize != 0) {
            for (String property : projection) {
                if (!"__HSearch_Document".equals(property)) continue;
                this.allowFieldSelection = false;
                return;
            }
        }
        HashMap<String, FieldSelectorResult> fields = new HashMap<String, FieldSelectorResult>(1 + idFieldNames.size() + projectionSize);
        fields.put("_hibernate_class", FieldSelectorResult.LOAD);
        for (String idFieldName : idFieldNames) {
            fields.put(idFieldName, FieldSelectorResult.LOAD);
        }
        if (projectionSize != 0) {
            for (String projectedField : projection) {
                fields.put(projectedField, FieldSelectorResult.LOAD);
            }
        }
        this.fieldSelector = new MapFieldSelector(fields);
    }

    private EntityInfo extract(Document document) {
        Class clazz = DocumentBuilderIndexedEntity.getDocumentClass(document);
        Serializable id = DocumentBuilderIndexedEntity.getDocumentId(this.searchFactoryImplementor, clazz, document);
        Object[] projected = null;
        if (this.projection != null && this.projection.length > 0) {
            projected = DocumentBuilderIndexedEntity.getDocumentFields(this.searchFactoryImplementor, clazz, document, this.projection);
        }
        return new EntityInfo(clazz, id, projected);
    }

    public EntityInfo extract(int index) throws IOException {
        Document doc = this.allowFieldSelection ? this.queryHits.doc(index, this.fieldSelector) : this.queryHits.doc(index);
        EntityInfo entityInfo = this.extract(doc);
        Object[] eip = entityInfo.projection;
        if (eip != null && eip.length > 0) {
            for (int x = 0; x < this.projection.length; ++x) {
                if ("__HSearch_Score".equals(this.projection[x])) {
                    eip[x] = Float.valueOf(this.queryHits.score(index));
                    continue;
                }
                if ("__HSearch_id".equals(this.projection[x])) {
                    eip[x] = entityInfo.id;
                    continue;
                }
                if ("__HSearch_Document".equals(this.projection[x])) {
                    eip[x] = doc;
                    continue;
                }
                if ("__HSearch_DocumentId".equals(this.projection[x])) {
                    eip[x] = this.queryHits.docId(index);
                    continue;
                }
                if ("__HSearch_Boost".equals(this.projection[x])) {
                    eip[x] = Float.valueOf(doc.getBoost());
                    continue;
                }
                if ("__HSearch_Explanation".equals(this.projection[x])) {
                    eip[x] = this.queryHits.explain(index);
                    continue;
                }
                if ("_hibernate_class".equals(this.projection[x])) {
                    eip[x] = entityInfo.clazz;
                    continue;
                }
                if (!"__HSearch_This".equals(this.projection[x])) continue;
                entityInfo.indexesOfThis.add(x);
            }
        }
        return entityInfo;
    }
}

