/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.UnknownProfileException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.NonFlushedChanges;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.event.EventListeners;
import org.hibernate.event.EventSource;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.jdbc.Batcher;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.backend.impl.EventSourceTransactionContext;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.impl.MassIndexerImpl;
import org.hibernate.search.query.FullTextQueryImpl;
import org.hibernate.search.util.ContextHelper;
import org.hibernate.stat.SessionStatistics;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullTextSessionImpl
implements FullTextSession,
SessionImplementor {
    private final org.hibernate.classic.Session session;
    private final SessionImplementor sessionImplementor;
    private transient SearchFactoryImplementor searchFactory;
    private final TransactionContext transactionContext;

    public FullTextSessionImpl(Session session) {
        this.session = (org.hibernate.classic.Session)session;
        this.transactionContext = new EventSourceTransactionContext((EventSource)session);
        this.sessionImplementor = (SessionImplementor)((Object)session);
    }

    public FullTextQuery createFullTextQuery(org.apache.lucene.search.Query luceneQuery, Class ... entities) {
        return new FullTextQueryImpl(luceneQuery, entities, this.sessionImplementor, new ParameterMetadata(null, null));
    }

    @Override
    public <T> void purgeAll(Class<T> entityType) {
        this.purge(entityType, null);
    }

    @Override
    public void flushToIndexes() {
        SearchFactoryImplementor searchFactoryImplementor = this.getSearchFactoryImplementor();
        searchFactoryImplementor.getWorker().flushWorks(this.transactionContext);
    }

    @Override
    public <T> void purge(Class<T> entityType, Serializable id) {
        if (entityType == null) {
            return;
        }
        Set<Class<?>> targetedClasses = this.getSearchFactoryImplementor().getIndexedTypesPolymorphic(new Class[]{entityType});
        if (targetedClasses.isEmpty()) {
            String msg = entityType.getName() + " is not an indexed entity or a subclass of an indexed entity";
            throw new IllegalArgumentException(msg);
        }
        for (Class<?> clazz : targetedClasses) {
            if (id == null) {
                this.createAndPerformWork(clazz, null, WorkType.PURGE_ALL);
                continue;
            }
            this.createAndPerformWork(clazz, id, WorkType.PURGE);
        }
    }

    private <T> void createAndPerformWork(Class<T> clazz, Serializable id, WorkType workType) {
        Work<T> work = new Work<T>(clazz, id, workType);
        this.getSearchFactoryImplementor().getWorker().performWork(work, this.transactionContext);
    }

    @Override
    public <T> void index(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity to index should not be null");
        }
        Class clazz = Hibernate.getClass(entity);
        SearchFactoryImplementor searchFactoryImplementor = this.getSearchFactoryImplementor();
        if (searchFactoryImplementor.getDocumentBuilderIndexedEntity(clazz) == null) {
            String msg = "Entity to index is not an @Indexed entity: " + entity.getClass().getName();
            throw new IllegalArgumentException(msg);
        }
        Serializable id = this.session.getIdentifier(entity);
        Work<T> work = new Work<T>(entity, id, WorkType.INDEX);
        searchFactoryImplementor.getWorker().performWork(work, this.transactionContext);
    }

    @Override
    public MassIndexer createIndexer(Class<?> ... types) {
        if (types.length == 0) {
            return new MassIndexerImpl(this.getSearchFactoryImplementor(), this.getSessionFactory(), Object.class);
        }
        return new MassIndexerImpl(this.getSearchFactoryImplementor(), this.getSessionFactory(), types);
    }

    @Override
    public SearchFactory getSearchFactory() {
        return this.getSearchFactoryImplementor();
    }

    private SearchFactoryImplementor getSearchFactoryImplementor() {
        if (this.searchFactory == null) {
            this.searchFactory = ContextHelper.getSearchFactory(this.session);
        }
        return this.searchFactory;
    }

    @Override
    public Query createSQLQuery(String sql, String returnAlias, Class returnClass) {
        return this.session.createSQLQuery(sql, returnAlias, returnClass);
    }

    @Override
    public Query createSQLQuery(String sql, String[] returnAliases, Class[] returnClasses) {
        return this.session.createSQLQuery(sql, returnAliases, returnClasses);
    }

    @Override
    public int delete(String query) throws HibernateException {
        return this.session.delete(query);
    }

    @Override
    public int delete(String query, Object value, Type type) throws HibernateException {
        return this.session.delete(query, value, type);
    }

    @Override
    public int delete(String query, Object[] values, Type[] types) throws HibernateException {
        return this.session.delete(query, values, types);
    }

    @Override
    public Collection filter(Object collection, String filter) throws HibernateException {
        return this.session.filter(collection, filter);
    }

    @Override
    public Collection filter(Object collection, String filter, Object value, Type type) throws HibernateException {
        return this.session.filter(collection, filter, value, type);
    }

    @Override
    public Collection filter(Object collection, String filter, Object[] values, Type[] types) throws HibernateException {
        return this.session.filter(collection, filter, values, types);
    }

    @Override
    public List find(String query) throws HibernateException {
        return this.session.find(query);
    }

    @Override
    public List find(String query, Object value, Type type) throws HibernateException {
        return this.session.find(query, value, type);
    }

    @Override
    public List find(String query, Object[] values, Type[] types) throws HibernateException {
        return this.session.find(query, values, types);
    }

    @Override
    public Iterator iterate(String query) throws HibernateException {
        return this.session.iterate(query);
    }

    @Override
    public Iterator iterate(String query, Object value, Type type) throws HibernateException {
        return this.session.iterate(query, value, type);
    }

    @Override
    public Iterator iterate(String query, Object[] values, Type[] types) throws HibernateException {
        return this.session.iterate(query, values, types);
    }

    @Override
    public void save(String entityName, Object object, Serializable id) throws HibernateException {
        this.session.save(entityName, object, id);
    }

    @Override
    public void save(Object object, Serializable id) throws HibernateException {
        this.session.save(object, id);
    }

    @Override
    public Object saveOrUpdateCopy(String entityName, Object object) throws HibernateException {
        return this.session.saveOrUpdateCopy(entityName, object);
    }

    @Override
    public Object saveOrUpdateCopy(String entityName, Object object, Serializable id) throws HibernateException {
        return this.session.saveOrUpdateCopy(entityName, object, id);
    }

    @Override
    public Object saveOrUpdateCopy(Object object) throws HibernateException {
        return this.session.saveOrUpdateCopy(object);
    }

    @Override
    public Object saveOrUpdateCopy(Object object, Serializable id) throws HibernateException {
        return this.session.saveOrUpdateCopy(object, id);
    }

    @Override
    public void update(String entityName, Object object, Serializable id) throws HibernateException {
        this.session.update(entityName, object, id);
    }

    @Override
    public void update(Object object, Serializable id) throws HibernateException {
        this.session.update(object, id);
    }

    @Override
    public Transaction beginTransaction() throws HibernateException {
        return this.session.beginTransaction();
    }

    @Override
    public void cancelQuery() throws HibernateException {
        this.session.cancelQuery();
    }

    @Override
    public void clear() {
        this.session.clear();
    }

    @Override
    public Connection close() throws HibernateException {
        return this.session.close();
    }

    @Override
    public Connection connection() throws HibernateException {
        return this.session.connection();
    }

    @Override
    public boolean contains(Object object) {
        return this.session.contains(object);
    }

    @Override
    public Criteria createCriteria(String entityName) {
        return this.session.createCriteria(entityName);
    }

    @Override
    public Criteria createCriteria(String entityName, String alias) {
        return this.session.createCriteria(entityName, alias);
    }

    @Override
    public Criteria createCriteria(Class persistentClass) {
        return this.session.createCriteria(persistentClass);
    }

    @Override
    public Criteria createCriteria(Class persistentClass, String alias) {
        return this.session.createCriteria(persistentClass, alias);
    }

    @Override
    public Query createFilter(Object collection, String queryString) throws HibernateException {
        return this.session.createFilter(collection, queryString);
    }

    @Override
    public Query createQuery(String queryString) throws HibernateException {
        return this.session.createQuery(queryString);
    }

    @Override
    public SQLQuery createSQLQuery(String queryString) throws HibernateException {
        return this.session.createSQLQuery(queryString);
    }

    @Override
    public void delete(String entityName, Object object) throws HibernateException {
        this.session.delete(entityName, object);
    }

    @Override
    public void delete(Object object) throws HibernateException {
        this.session.delete(object);
    }

    @Override
    public void disableFilter(String filterName) {
        this.session.disableFilter(filterName);
    }

    @Override
    public Connection disconnect() throws HibernateException {
        return this.session.disconnect();
    }

    @Override
    public Filter enableFilter(String filterName) {
        return this.session.enableFilter(filterName);
    }

    @Override
    public void evict(Object object) throws HibernateException {
        this.session.evict(object);
    }

    @Override
    public void flush() throws HibernateException {
        this.session.flush();
    }

    @Override
    public Object get(Class clazz, Serializable id) throws HibernateException {
        return this.session.get(clazz, id);
    }

    @Override
    public Object get(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.get(clazz, id, lockMode);
    }

    @Override
    public Object get(Class clazz, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.session.get(clazz, id, lockOptions);
    }

    @Override
    public Object get(String entityName, Serializable id) throws HibernateException {
        return this.session.get(entityName, id);
    }

    @Override
    public Object get(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.get(entityName, id, lockMode);
    }

    @Override
    public Object get(String entityName, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.session.get(entityName, id, lockOptions);
    }

    @Override
    public CacheMode getCacheMode() {
        return this.session.getCacheMode();
    }

    @Override
    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        return this.session.getCurrentLockMode(object);
    }

    @Override
    public Filter getEnabledFilter(String filterName) {
        return this.session.getEnabledFilter(filterName);
    }

    @Override
    public Interceptor getInterceptor() {
        return this.sessionImplementor.getInterceptor();
    }

    @Override
    public void setAutoClear(boolean enabled) {
        this.sessionImplementor.setAutoClear(enabled);
    }

    @Override
    public boolean isTransactionInProgress() {
        return this.sessionImplementor.isTransactionInProgress();
    }

    @Override
    public void initializeCollection(PersistentCollection collection, boolean writing) throws HibernateException {
        this.sessionImplementor.initializeCollection(collection, writing);
    }

    @Override
    public Object internalLoad(String entityName, Serializable id, boolean eager, boolean nullable) throws HibernateException {
        return this.sessionImplementor.internalLoad(entityName, id, eager, nullable);
    }

    @Override
    public Object immediateLoad(String entityName, Serializable id) throws HibernateException {
        return this.sessionImplementor.immediateLoad(entityName, id);
    }

    @Override
    public long getTimestamp() {
        return this.sessionImplementor.getTimestamp();
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.sessionImplementor.getFactory();
    }

    @Override
    public Batcher getBatcher() {
        return this.sessionImplementor.getBatcher();
    }

    @Override
    public List list(String query, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.list(query, queryParameters);
    }

    @Override
    public Iterator iterate(String query, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.iterate(query, queryParameters);
    }

    @Override
    public ScrollableResults scroll(String query, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.scroll(query, queryParameters);
    }

    @Override
    public ScrollableResults scroll(CriteriaImpl criteria, ScrollMode scrollMode) {
        return this.sessionImplementor.scroll(criteria, scrollMode);
    }

    @Override
    public List list(CriteriaImpl criteria) {
        return this.sessionImplementor.list(criteria);
    }

    @Override
    public List listFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.listFilter(collection, filter, queryParameters);
    }

    @Override
    public Iterator iterateFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.iterateFilter(collection, filter, queryParameters);
    }

    @Override
    public EntityPersister getEntityPersister(String entityName, Object object) throws HibernateException {
        return this.sessionImplementor.getEntityPersister(entityName, object);
    }

    @Override
    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        return this.sessionImplementor.getEntityUsingInterceptor(key);
    }

    @Override
    public void afterTransactionCompletion(boolean successful, Transaction tx) {
        this.sessionImplementor.afterTransactionCompletion(successful, tx);
    }

    @Override
    public void beforeTransactionCompletion(Transaction tx) {
        this.sessionImplementor.beforeTransactionCompletion(tx);
    }

    @Override
    public Serializable getContextEntityIdentifier(Object object) {
        return this.sessionImplementor.getContextEntityIdentifier(object);
    }

    @Override
    public String bestGuessEntityName(Object object) {
        return this.sessionImplementor.bestGuessEntityName(object);
    }

    @Override
    public String guessEntityName(Object entity) throws HibernateException {
        return this.sessionImplementor.guessEntityName(entity);
    }

    @Override
    public Object instantiate(String entityName, Serializable id) throws HibernateException {
        return this.sessionImplementor.instantiate(entityName, id);
    }

    @Override
    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.listCustomQuery(customQuery, queryParameters);
    }

    @Override
    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.scrollCustomQuery(customQuery, queryParameters);
    }

    @Override
    public List list(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.list(spec, queryParameters);
    }

    @Override
    public ScrollableResults scroll(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.scroll(spec, queryParameters);
    }

    @Override
    public Object getFilterParameterValue(String filterParameterName) {
        return this.sessionImplementor.getFilterParameterValue(filterParameterName);
    }

    @Override
    public Type getFilterParameterType(String filterParameterName) {
        return this.sessionImplementor.getFilterParameterType(filterParameterName);
    }

    @Override
    public Map getEnabledFilters() {
        return this.sessionImplementor.getEnabledFilters();
    }

    @Override
    public int getDontFlushFromFind() {
        return this.sessionImplementor.getDontFlushFromFind();
    }

    @Override
    public EventListeners getListeners() {
        return this.sessionImplementor.getListeners();
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.sessionImplementor.getPersistenceContext();
    }

    @Override
    public int executeUpdate(String query, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.executeUpdate(query, queryParameters);
    }

    @Override
    public int executeNativeUpdate(NativeSQLQuerySpecification specification, QueryParameters queryParameters) throws HibernateException {
        return this.sessionImplementor.executeNativeUpdate(specification, queryParameters);
    }

    @Override
    public NonFlushedChanges getNonFlushedChanges() throws HibernateException {
        return this.sessionImplementor.getNonFlushedChanges();
    }

    @Override
    public void applyNonFlushedChanges(NonFlushedChanges nonFlushedChanges) throws HibernateException {
        this.sessionImplementor.applyNonFlushedChanges(nonFlushedChanges);
    }

    @Override
    public EntityMode getEntityMode() {
        return this.session.getEntityMode();
    }

    @Override
    public String getEntityName(Object object) throws HibernateException {
        return this.session.getEntityName(object);
    }

    @Override
    public FlushMode getFlushMode() {
        return this.session.getFlushMode();
    }

    @Override
    public Serializable getIdentifier(Object object) throws HibernateException {
        return this.session.getIdentifier(object);
    }

    @Override
    public Query getNamedQuery(String queryName) throws HibernateException {
        return this.session.getNamedQuery(queryName);
    }

    @Override
    public Query getNamedSQLQuery(String name) {
        return this.sessionImplementor.getNamedSQLQuery(name);
    }

    @Override
    public boolean isEventSource() {
        return this.sessionImplementor.isEventSource();
    }

    @Override
    public void afterScrollOperation() {
        this.sessionImplementor.afterScrollOperation();
    }

    @Override
    public void setFetchProfile(String name) {
        this.sessionImplementor.setFetchProfile(name);
    }

    @Override
    public String getFetchProfile() {
        return this.sessionImplementor.getFetchProfile();
    }

    @Override
    public JDBCContext getJDBCContext() {
        return this.sessionImplementor.getJDBCContext();
    }

    @Override
    public boolean isClosed() {
        return this.sessionImplementor.isClosed();
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.sessionImplementor.getLoadQueryInfluencers();
    }

    @Override
    public Session getSession(EntityMode entityMode) {
        return this.session.getSession(entityMode);
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.session.getSessionFactory();
    }

    @Override
    public SessionStatistics getStatistics() {
        return this.session.getStatistics();
    }

    @Override
    public boolean isReadOnly(Object entityOrProxy) {
        return this.session.isReadOnly(entityOrProxy);
    }

    @Override
    public Transaction getTransaction() {
        return this.session.getTransaction();
    }

    @Override
    public boolean isConnected() {
        return this.session.isConnected();
    }

    @Override
    public boolean isDirty() throws HibernateException {
        return this.session.isDirty();
    }

    @Override
    public boolean isDefaultReadOnly() {
        return this.session.isDefaultReadOnly();
    }

    @Override
    public boolean isOpen() {
        return this.session.isOpen();
    }

    @Override
    public Object load(String entityName, Serializable id) throws HibernateException {
        return this.session.load(entityName, id);
    }

    @Override
    public Object load(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.load(entityName, id, lockMode);
    }

    @Override
    public Object load(String entityName, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.session.load(entityName, id, lockOptions);
    }

    @Override
    public void load(Object object, Serializable id) throws HibernateException {
        this.session.load(object, id);
    }

    @Override
    public Object load(Class theClass, Serializable id) throws HibernateException {
        return this.session.load(theClass, id);
    }

    @Override
    public Object load(Class theClass, Serializable id, LockMode lockMode) throws HibernateException {
        return this.session.load(theClass, id, lockMode);
    }

    @Override
    public Object load(Class theClass, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.session.load(theClass, id, lockOptions);
    }

    @Override
    public void lock(String entityName, Object object, LockMode lockMode) throws HibernateException {
        this.session.lock(entityName, object, lockMode);
    }

    @Override
    public Session.LockRequest buildLockRequest(LockOptions lockOptions) {
        return this.session.buildLockRequest(lockOptions);
    }

    @Override
    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.session.lock(object, lockMode);
    }

    @Override
    public Object merge(String entityName, Object object) throws HibernateException {
        return this.session.merge(entityName, object);
    }

    @Override
    public Object merge(Object object) throws HibernateException {
        return this.session.merge(object);
    }

    @Override
    public void persist(String entityName, Object object) throws HibernateException {
        this.session.persist(entityName, object);
    }

    @Override
    public void persist(Object object) throws HibernateException {
        this.session.persist(object);
    }

    @Override
    public void reconnect() throws HibernateException {
        this.session.reconnect();
    }

    @Override
    public void reconnect(Connection connection) throws HibernateException {
        this.session.reconnect(connection);
    }

    @Override
    public void refresh(Object object) throws HibernateException {
        this.session.refresh(object);
    }

    @Override
    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.session.refresh(object, lockMode);
    }

    @Override
    public void refresh(Object object, LockOptions lockOptions) throws HibernateException {
        this.session.refresh(object, lockOptions);
    }

    @Override
    public void replicate(String entityName, Object object, ReplicationMode replicationMode) throws HibernateException {
        this.session.replicate(entityName, object, replicationMode);
    }

    @Override
    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateException {
        this.session.replicate(object, replicationMode);
    }

    @Override
    public Serializable save(String entityName, Object object) throws HibernateException {
        return this.session.save(entityName, object);
    }

    @Override
    public Serializable save(Object object) throws HibernateException {
        return this.session.save(object);
    }

    @Override
    public void saveOrUpdate(String entityName, Object object) throws HibernateException {
        this.session.saveOrUpdate(entityName, object);
    }

    @Override
    public void saveOrUpdate(Object object) throws HibernateException {
        this.session.saveOrUpdate(object);
    }

    @Override
    public void setCacheMode(CacheMode cacheMode) {
        this.session.setCacheMode(cacheMode);
    }

    @Override
    public void setDefaultReadOnly(boolean readOnly) {
        this.session.setDefaultReadOnly(readOnly);
    }

    @Override
    public void setFlushMode(FlushMode flushMode) {
        this.session.setFlushMode(flushMode);
    }

    @Override
    public void setReadOnly(Object entity, boolean readOnly) {
        this.session.setReadOnly(entity, readOnly);
    }

    @Override
    public void doWork(org.hibernate.jdbc.Work work) throws HibernateException {
        this.session.doWork(work);
    }

    @Override
    public void update(String entityName, Object object) throws HibernateException {
        this.session.update(entityName, object);
    }

    @Override
    public void update(Object object) throws HibernateException {
        this.session.update(object);
    }

    @Override
    public boolean isFetchProfileEnabled(String name) throws UnknownProfileException {
        return this.session.isFetchProfileEnabled(name);
    }

    @Override
    public void enableFetchProfile(String name) throws UnknownProfileException {
        this.session.enableFetchProfile(name);
    }

    @Override
    public void disableFetchProfile(String name) throws UnknownProfileException {
        this.session.disableFetchProfile(name);
    }
}

