/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.solr.analysis.CharFilterFactory;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.analysis.TokenizerFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.util.HibernateSearchResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SolrAnalyzerBuilder {
    private SolrAnalyzerBuilder() {
    }

    public static Analyzer buildAnalyzer(AnalyzerDef analyzerDef) {
        int index;
        TokenizerDef token = analyzerDef.tokenizer();
        TokenizerFactory tokenFactory = (TokenizerFactory)SolrAnalyzerBuilder.instantiate(token.factory());
        tokenFactory.init(SolrAnalyzerBuilder.getMapOfParameters(token.params()));
        int length = analyzerDef.filters().length;
        int charLength = analyzerDef.charFilters().length;
        TokenFilterFactory[] filters = new TokenFilterFactory[length];
        CharFilterFactory[] charFilters = new CharFilterFactory[charLength];
        HibernateSearchResourceLoader resourceLoader = new HibernateSearchResourceLoader();
        for (index = 0; index < length; ++index) {
            TokenFilterDef filterDef = analyzerDef.filters()[index];
            filters[index] = (TokenFilterFactory)SolrAnalyzerBuilder.instantiate(filterDef.factory());
            filters[index].init(SolrAnalyzerBuilder.getMapOfParameters(filterDef.params()));
            if (!(filters[index] instanceof ResourceLoaderAware)) continue;
            ((ResourceLoaderAware)filters[index]).inform((ResourceLoader)resourceLoader);
        }
        for (index = 0; index < charFilters.length; ++index) {
            CharFilterDef charFilterDef = analyzerDef.charFilters()[index];
            charFilters[index] = (CharFilterFactory)SolrAnalyzerBuilder.instantiate(charFilterDef.factory());
            charFilters[index].init(SolrAnalyzerBuilder.getMapOfParameters(charFilterDef.params()));
            if (!(charFilters[index] instanceof ResourceLoaderAware)) continue;
            ((ResourceLoaderAware)charFilters[index]).inform((ResourceLoader)resourceLoader);
        }
        return new TokenizerChain(charFilters, tokenFactory, filters);
    }

    private static Object instantiate(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to instantiate class: " + clazz, e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to instantiate class: " + clazz, e);
        }
    }

    private static Map<String, String> getMapOfParameters(Parameter[] params) {
        HashMap<String, String> mapOfParams = new HashMap<String, String>(params.length);
        for (Parameter param : params) {
            mapOfParams.put(param.name(), param.value());
        }
        return Collections.unmodifiableMap(mapOfParams);
    }
}

