/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util;

import org.hibernate.search.SearchException;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader {
    public static <T> T instanceFromName(Class<T> targetSuperType, String classNameToLoad, Class<?> caller, String componentDescription) {
        Class clazzDef;
        try {
            clazzDef = ReflectHelper.classForName(classNameToLoad, caller);
        }
        catch (ClassNotFoundException e) {
            throw new SearchException("Unable to find " + componentDescription + " implementation class: " + classNameToLoad, e);
        }
        return PluginLoader.instanceFromClass(targetSuperType, clazzDef, componentDescription);
    }

    public static <T> T instanceFromClass(Class<T> targetSuperType, Class<?> classToLoad, String componentDescription) {
        Object instance;
        PluginLoader.checkClassType(classToLoad, componentDescription);
        PluginLoader.checkHasValidconstructor(classToLoad, componentDescription);
        try {
            instance = classToLoad.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to instantiate " + componentDescription + " class: " + classToLoad.getName() + ". Class or constructor is not accessible.", e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to instantiate " + componentDescription + " class: " + classToLoad.getName() + ". Verify it has a no-args public constructor and is not abstract.", e);
        }
        if (!targetSuperType.isInstance(instance)) {
            if (targetSuperType.isInterface()) {
                throw new SearchException("Wrong configuration of " + componentDescription + ": class " + classToLoad.getName() + " does not implement interface " + targetSuperType.getName());
            }
            throw new SearchException("Wrong configuration of " + componentDescription + ": class " + classToLoad.getName() + " is not a subtype of " + targetSuperType.getName());
        }
        return (T)instance;
    }

    private static void checkClassType(Class<?> classToLoad, String componentDescription) {
        if (classToLoad.isInterface()) {
            throw new SearchException(classToLoad.getName() + " defined for component " + componentDescription + " is an interface: implementation required.");
        }
    }

    public static void checkHasValidconstructor(Class<?> classToLoad, String componentDescription) {
        try {
            classToLoad.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw new SearchException(classToLoad.getName() + " defined for component " + componentDescription + " could not be instantiated because of a security manager error", e);
        }
        catch (NoSuchMethodException e) {
            throw new SearchException(classToLoad.getName() + " defined for component " + componentDescription + " is missing a no-arguments constructor");
        }
    }
}

