/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.jetty6;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.xml.ws.WebServiceRef;
import org.mortbay.jetty.servlet.ServletHandler;
import org.ow2.util.ee.metadata.common.api.enc.IENCBindingHolder;
import org.ow2.util.ee.metadata.common.api.enc.IInjectionTargetEnc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessorServletHandler
extends ServletHandler {
    private Context context = null;
    private boolean disabledAnnotation = false;
    private IENCBindingHolder encBindingHolder = null;

    public AnnotationProcessorServletHandler(Context context) {
        this.context = context;
    }

    public Filter customizeFilter(Filter filter) throws Exception {
        this.processAnnotations(filter);
        return super.customizeFilter(filter);
    }

    public Servlet customizeServlet(Servlet servlet) throws Exception {
        this.processAnnotations(servlet);
        return super.customizeServlet(servlet);
    }

    public void processAnnotations(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (this.context == null) {
            return;
        }
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Annotation[] annotations;
                Resource annotation;
                List fieldInjections;
                if (this.encBindingHolder != null && (fieldInjections = this.encBindingHolder.getFieldInjectionTargets(clazz.getName())) != null) {
                    for (IInjectionTargetEnc fieldInjection : fieldInjections) {
                        if (!fields[i].getName().equals(fieldInjection.getName())) continue;
                        AnnotationProcessorServletHandler.lookupFieldResource(this.context, instance, fields[i], fieldInjection.getEncName(), clazz);
                    }
                }
                if (this.disabledAnnotation) continue;
                if (fields[i].isAnnotationPresent(Resource.class)) {
                    annotation = fields[i].getAnnotation(Resource.class);
                    AnnotationProcessorServletHandler.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
                }
                if (fields[i].isAnnotationPresent(EJB.class)) {
                    annotation = fields[i].getAnnotation(EJB.class);
                    AnnotationProcessorServletHandler.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
                }
                if (fields[i].isAnnotationPresent(WebServiceRef.class)) {
                    annotation = fields[i].getAnnotation(WebServiceRef.class);
                    AnnotationProcessorServletHandler.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
                }
                if (fields[i].isAnnotationPresent(PersistenceContext.class)) {
                    annotation = fields[i].getAnnotation(PersistenceContext.class);
                    AnnotationProcessorServletHandler.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
                }
                if (fields[i].isAnnotationPresent(PersistenceUnit.class)) {
                    annotation = fields[i].getAnnotation(PersistenceUnit.class);
                    AnnotationProcessorServletHandler.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
                }
                if ((annotations = fields[i].getDeclaredAnnotations()) == null) continue;
                for (Annotation annotation2 : annotations) {
                    if (!"org.ow2.easybeans.osgi.annotation.OSGiResource".equals(annotation2.annotationType().getName())) continue;
                    AnnotationProcessorServletHandler.lookupFieldResource(this.context, instance, fields[i], "BundleContext", clazz);
                }
            }
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Annotation[] annotations;
                Resource annotation;
                List methoddInjections;
                if (this.encBindingHolder != null && (methoddInjections = this.encBindingHolder.getMethodInjectionTargets(clazz.getName())) != null) {
                    for (IInjectionTargetEnc methodInjection : methoddInjections) {
                        if (!methods[i].getName().equals(methodInjection.getName())) continue;
                        AnnotationProcessorServletHandler.lookupMethodResource(this.context, instance, methods[i], methodInjection.getEncName(), clazz);
                    }
                }
                if (this.disabledAnnotation) continue;
                if (methods[i].isAnnotationPresent(Resource.class)) {
                    annotation = methods[i].getAnnotation(Resource.class);
                    AnnotationProcessorServletHandler.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
                }
                if (methods[i].isAnnotationPresent(EJB.class)) {
                    annotation = methods[i].getAnnotation(EJB.class);
                    AnnotationProcessorServletHandler.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
                }
                if (methods[i].isAnnotationPresent(WebServiceRef.class)) {
                    annotation = methods[i].getAnnotation(WebServiceRef.class);
                    AnnotationProcessorServletHandler.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
                }
                if (methods[i].isAnnotationPresent(PersistenceContext.class)) {
                    annotation = methods[i].getAnnotation(PersistenceContext.class);
                    AnnotationProcessorServletHandler.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
                }
                if (methods[i].isAnnotationPresent(PersistenceUnit.class)) {
                    annotation = methods[i].getAnnotation(PersistenceUnit.class);
                    AnnotationProcessorServletHandler.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
                }
                if ((annotations = methods[i].getDeclaredAnnotations()) == null) continue;
                for (Annotation annotation3 : annotations) {
                    if (!"org.ow2.easybeans.osgi.annotation.OSGiResource".equals(annotation3.annotationType().getName())) continue;
                    AnnotationProcessorServletHandler.lookupMethodResource(this.context, instance, methods[i], "BundleContext", clazz);
                }
            }
        }
    }

    protected static void lookupFieldResource(Context context, Object instance, Field field, String name, Class<?> clazz) throws NamingException, IllegalAccessException {
        Object lookedupResource = null;
        boolean accessibility = false;
        lookedupResource = name != null && name.length() > 0 ? context.lookup(name) : context.lookup(clazz.getName() + "/" + field.getName());
        accessibility = field.isAccessible();
        field.setAccessible(true);
        field.set(instance, lookedupResource);
        field.setAccessible(accessibility);
    }

    protected static void lookupMethodResource(Context context, Object instance, Method method, String name, Class<?> clazz) throws NamingException, IllegalAccessException, InvocationTargetException {
        if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || !method.getReturnType().getName().equals("void")) {
            throw new IllegalArgumentException("Invalid method resource injection annotation");
        }
        Object lookedupResource = null;
        boolean accessibility = false;
        lookedupResource = name != null && name.length() > 0 ? context.lookup(name) : context.lookup(clazz.getName() + "/" + method.getName().substring(3));
        accessibility = method.isAccessible();
        method.setAccessible(true);
        method.invoke(instance, lookedupResource);
        method.setAccessible(accessibility);
    }

    public void setEncBindingHolder(IENCBindingHolder encBindingHolder) {
        this.encBindingHolder = encBindingHolder;
    }

    public IENCBindingHolder getEncBindingHolder() {
        return this.encBindingHolder;
    }
}

