/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.listener.statistics;

import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.impl.listener.statistics.BasicPoolStatsFillerPoolListener;
import org.ow2.util.pool.impl.enhanced.impl.listener.statistics.ExtendedPoolStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedPoolStatsFillerPoolListener<E>
extends BasicPoolStatsFillerPoolListener<E> {
    private ThreadLocal<Long> callTime = new ThreadLocal();
    private ExtendedPoolStats extendedPoolStats = new ExtendedPoolStats();

    @Override
    public void getMethodCalled(IWaitControl timeout) {
        this.callTime.set(System.currentTimeMillis());
        super.getMethodCalled(timeout);
    }

    protected void updateGetMethodDurationAverage() {
        long duration = System.currentTimeMillis() - this.callTime.get();
        this.callTime.remove();
        long oldCount = this.extendedPoolStats.getGetMethodCount();
        double getMethodDurationAverage = (this.extendedPoolStats.getGetMethodDurationAverage() * (double)oldCount + (double)duration) / (double)(oldCount + 1L);
        this.extendedPoolStats.setGetMethodDurationAverage(getMethodDurationAverage);
        this.extendedPoolStats.setGetMethodCount(oldCount + 1L);
    }

    @Override
    public void getMethodFailed(Exception poolException, IWaitControl timeout) {
        this.updateGetMethodDurationAverage();
        super.getMethodFailed(poolException, timeout);
    }

    @Override
    public void getMethodReturned(E result, IWaitControl timeout) {
        this.updateGetMethodDurationAverage();
        super.getMethodReturned(result, timeout);
    }
}

