/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.thread;

import java.lang.ref.WeakReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.thread.IReusableThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractReusableThread
implements IReusableThread,
Runnable {
    private static final Log LOG = LogFactory.getLog(AbstractReusableThread.class);
    private Runnable runnable;
    private WeakReference<IPool<IReusableThread>> reusableThreadPoolWeakReference;
    private Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUsed(IPool<IReusableThread> reusableThreadPool, Runnable runnable) {
        if (reusableThreadPool == null || runnable == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.runnable != null) {
                throw new IllegalStateException();
            }
            this.reusableThreadPoolWeakReference = new WeakReference<IPool<IReusableThread>>(reusableThreadPool);
            this.runnable = runnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.runnable.run();
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Runnable exit with runtime exception", new Object[]{e});
        }
        catch (Error e) {
            LOG.error((Object)"Runnable exit with error, this thread is lost", new Object[]{e});
            throw e;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.runnable = null;
            IPool reusableThreadPool = (IPool)this.reusableThreadPoolWeakReference.get();
            if (reusableThreadPool != null) {
                try {
                    reusableThreadPool.put(this);
                }
                catch (PoolException e) {
                    LOG.error((Object)"Pool refuse the item", new Object[]{e});
                }
            }
            this.reusableThreadPoolWeakReference = null;
        }
    }
}

