/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.waitcontrol;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.WaiterInterruptedException;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.WaitAuthorization;
import org.ow2.util.pool.impl.enhanced.internal.conditionWaitPart.IConditionWaitPart;

public class ExpireWaitControl
implements IWaitControl {
    private long expireTime;
    private List<WaitAuthorization> waitAuthorizations;

    public ExpireWaitControl(long expireTime) {
        this.expireTime = expireTime;
        this.waitAuthorizations = new ArrayList<WaitAuthorization>();
    }

    public void popWaitAuthorization() {
        this.waitAuthorizations.remove(0);
    }

    public void pushWaitAuthorization(WaitAuthorization waitAuthorization) {
        this.waitAuthorizations.add(0, waitAuthorization);
    }

    protected boolean canWait() {
        for (WaitAuthorization waitAuthorization : this.waitAuthorizations) {
            if (waitAuthorization.isWaitAllowed()) continue;
            return false;
        }
        return true;
    }

    public boolean waitOnCondition(Condition condition) throws InterruptedException, WaiterInterruptedException {
        long timeToWait = this.expireTime - System.currentTimeMillis();
        if (timeToWait <= 0L) {
            return false;
        }
        if (!this.canWait()) {
            throw new WaiterInterruptedException();
        }
        return condition.await(timeToWait, TimeUnit.MILLISECONDS);
    }

    public boolean waitOnMutex(Object mutex) throws InterruptedException, WaiterInterruptedException {
        long timeToWait = this.expireTime - System.currentTimeMillis();
        if (timeToWait <= 0L) {
            return false;
        }
        if (!this.canWait()) {
            throw new WaiterInterruptedException();
        }
        mutex.wait(timeToWait);
        return this.expireTime > System.currentTimeMillis();
    }

    public boolean canContinueToWait() {
        return this.expireTime > System.currentTimeMillis();
    }

    public boolean waitOnConditionWaitPart(IConditionWaitPart condition) throws InterruptedException, WaiterInterruptedException {
        long timeToWait = this.expireTime - System.currentTimeMillis();
        if (timeToWait <= 0L) {
            return false;
        }
        if (!this.canWait()) {
            throw new WaiterInterruptedException();
        }
        return condition.await(timeToWait, TimeUnit.MILLISECONDS);
    }

    public void verifyInterrupted() throws WaiterInterruptedException {
        if (!this.canWait()) {
            throw new WaiterInterruptedException();
        }
    }
}

