/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.waitcontrol;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.WaiterInterruptedException;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.WaitAuthorization;
import org.ow2.util.pool.impl.enhanced.internal.conditionWaitPart.IConditionWaitPart;

public class InfiniteWaitControl
implements IWaitControl {
    private List<WaitAuthorization> waitAuthorizations = new ArrayList<WaitAuthorization>();

    protected boolean canWait() {
        for (WaitAuthorization waitAuthorization : this.waitAuthorizations) {
            if (waitAuthorization.isWaitAllowed()) continue;
            return false;
        }
        return true;
    }

    public void pushWaitAuthorization(WaitAuthorization waitAuthorization) {
        this.waitAuthorizations.add(0, waitAuthorization);
    }

    public void popWaitAuthorization() {
        this.waitAuthorizations.remove(0);
    }

    public boolean waitOnCondition(Condition condition) throws InterruptedException, WaiterInterruptedException {
        if (!this.canWait()) {
            throw new WaiterInterruptedException();
        }
        condition.await();
        return true;
    }

    public boolean waitOnMutex(Object mutex) throws InterruptedException, WaiterInterruptedException {
        if (!this.canWait()) {
            throw new WaiterInterruptedException();
        }
        mutex.wait();
        return true;
    }

    public boolean canContinueToWait() {
        return true;
    }

    public boolean waitOnConditionWaitPart(IConditionWaitPart condition) throws InterruptedException, WaiterInterruptedException {
        if (!this.canWait()) {
            throw new WaiterInterruptedException();
        }
        condition.await();
        return true;
    }

    public void verifyInterrupted() throws WaiterInterruptedException {
        if (!this.canWait()) {
            throw new WaiterInterruptedException();
        }
    }
}

