/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.internal.thread.impl;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicLong;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.internal.thread.impl.Cleaner;
import org.ow2.util.pool.impl.enhanced.internal.thread.impl.ICleanable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CleanerReferencer
extends WeakReference<Cleaner>
implements Runnable {
    private static final Log LOG = LogFactory.getLog(CleanerReferencer.class);
    private static AtomicLong instanceCount = new AtomicLong(0L);
    private int instanceToClean;
    private Cleaner cleaner;
    private Thread thread;
    private ReferenceQueue<Object> referenceQueue;
    private Object mutex = new Object();

    public CleanerReferencer(Cleaner cleaner) {
        super(cleaner, cleaner.getReferenceQueue());
        this.referenceQueue = cleaner.getReferenceQueue();
        this.thread = new Thread((Runnable)this, "Cleaner thread " + instanceCount.getAndIncrement());
        this.thread.setDaemon(true);
        this.instanceToClean = 0;
        this.thread.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                do {
                    Reference<Object> reference;
                    if (!((reference = this.referenceQueue.remove()) instanceof ICleanable)) continue;
                    ICleanable cleanable = (ICleanable)((Object)reference);
                    try {
                        cleanable.clean();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                } while (!this.remove());
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"InterruptedException occurs", new Object[]{e});
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add() {
        Object object = this.mutex;
        synchronized (object) {
            ++this.instanceToClean;
            this.cleaner = (Cleaner)this.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.instanceToClean < 0) {
                throw new IllegalStateException();
            }
            if (this.instanceToClean == 0) {
                return true;
            }
            --this.instanceToClean;
            if (this.instanceToClean == 0) {
                this.cleaner = null;
            }
            return false;
        }
    }
}

