/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SecurityTokenReference {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$message$token$SecurityTokenReference == null ? (class$org$apache$ws$security$message$token$SecurityTokenReference = SecurityTokenReference.class$("org.apache.ws.security.message.token.SecurityTokenReference")) : class$org$apache$ws$security$message$token$SecurityTokenReference).getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    public static final String SECURITY_TOKEN_REFERENCE = "SecurityTokenReference";
    public static final String KEY_NAME = "KeyName";
    public static final String SKI_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier";
    protected Element element = null;
    private XMLX509IssuerSerial issuerSerial = null;
    private byte[] skiBytes = null;
    protected WSSConfig wssConfig = WSSConfig.getDefaultWSConfig();
    private static boolean doDebug = false;
    static /* synthetic */ Class class$org$apache$ws$security$message$token$SecurityTokenReference;

    public SecurityTokenReference(WSSConfig wssConfig, Element elem) throws WSSecurityException {
        doDebug = log.isDebugEnabled();
        this.element = elem;
        this.wssConfig = wssConfig;
        boolean goodElement = false;
        if (SECURITY_TOKEN_REFERENCE.equals(this.element.getLocalName())) {
            if (wssConfig.getProcessNonCompliantMessages()) {
                for (int i = 0; !goodElement && i < WSConstants.WSSE_NS_ARRAY.length; ++i) {
                    goodElement = WSConstants.WSSE_NS_ARRAY[i].equals(this.element.getNamespaceURI());
                }
            } else {
                goodElement = wssConfig.getWsseNS().equals(this.element.getNamespaceURI());
            }
        } else if (KEY_NAME.equals(this.element.getLocalName())) {
            goodElement = "http://www.w3.org/2000/09/xmldsig#".equals(this.element.getNamespaceURI());
        }
        if (!goodElement) {
            throw new WSSecurityException(0, "badElement", null);
        }
    }

    public SecurityTokenReference(WSSConfig wssConfig, Document doc) {
        doDebug = log.isDebugEnabled();
        this.wssConfig = wssConfig;
        this.element = doc.createElementNS(wssConfig.getWsseNS(), "wsse:SecurityTokenReference");
    }

    public void setReference(Reference ref) {
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(ref.getElement(), elem);
        } else {
            this.element.appendChild(ref.getElement());
        }
    }

    public Reference getReference() throws WSSecurityException {
        Element elem = this.getFirstElement();
        return new Reference(this.wssConfig, elem);
    }

    public Element getTokenElement(Document doc, WSDocInfo docInfo) throws WSSecurityException {
        Reference ref = this.getReference();
        String uri = ref.getURI();
        if (doDebug) {
            log.debug((Object)("Token reference uri: " + uri));
        }
        if (uri == null) {
            throw new WSSecurityException(3, "badReferenceURI");
        }
        Element tokElement = null;
        String tmpS = "http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-saml-token-profile-1.0#SAMLAssertion-1.1";
        if (tmpS.equals(ref.getValueType())) {
            Element sa = docInfo.getAssertion();
            String saID = null;
            if (sa != null) {
                saID = sa.getAttribute("AssertionID");
            }
            if (doDebug) {
                log.debug((Object)("SAML token ID: " + saID));
            }
            String id = uri.substring(1);
            if (saID == null || !saID.equals(id)) {
                throw new WSSecurityException(3, "badReferenceURI", new Object[]{"uri:" + uri + ", saID: " + saID});
            }
            tokElement = sa;
        } else {
            tokElement = WSSecurityUtil.getElementByWsuId(this.wssConfig, doc, uri);
        }
        if (tokElement == null) {
            throw new WSSecurityException(7, "noToken", new Object[]{uri});
        }
        return tokElement;
    }

    public void setKeyIdentifier(X509Certificate cert) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        byte[] data = null;
        try {
            data = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError");
        }
        Text certText = doc.createTextNode(Base64.encode(data));
        Element keyId = doc.createElementNS(this.wssConfig.getWsseNS(), "wsse:KeyIdentifier");
        if (this.wssConfig.isBSTAttributesQualified()) {
            keyId.setAttributeNS(this.wssConfig.getWsseNS(), "wsse:ValueType", X509Security.getType(this.wssConfig));
            keyId.setAttributeNS(this.wssConfig.getWsseNS(), "wsse:EncodingType", BinarySecurity.getBase64EncodingValue(this.wssConfig));
        } else {
            keyId.setAttributeNS(null, "ValueType", X509Security.getType(this.wssConfig));
            keyId.setAttributeNS(null, "EncodingType", BinarySecurity.getBase64EncodingValue(this.wssConfig));
        }
        keyId.appendChild(certText);
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(keyId, elem);
        } else {
            this.element.appendChild(keyId);
        }
    }

    public void setKeyIdentifierSKI(X509Certificate cert, Crypto crypto) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        byte[] data = crypto.getSKIBytesFromCert(cert);
        Text skiText = doc.createTextNode(Base64.encode(data));
        Element keyId = doc.createElementNS(this.wssConfig.getWsseNS(), "wsse:KeyIdentifier");
        if (this.wssConfig.isBSTAttributesQualified()) {
            keyId.setAttributeNS(this.wssConfig.getWsseNS(), "wsse:ValueType", SKI_URI);
            keyId.setAttributeNS(this.wssConfig.getWsseNS(), "wsse:EncodingType", BinarySecurity.getBase64EncodingValue(this.wssConfig));
        } else {
            keyId.setAttributeNS(null, "ValueType", SKI_URI);
            keyId.setAttributeNS(null, "EncodingType", BinarySecurity.getBase64EncodingValue(this.wssConfig));
        }
        keyId.appendChild(skiText);
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(keyId, elem);
        } else {
            this.element.appendChild(keyId);
        }
    }

    public void setSAMLKeyIdentifier(String keyIdVal) throws WSSecurityException {
        Document doc = this.element.getOwnerDocument();
        Element keyId = doc.createElementNS(this.wssConfig.getWsseNS(), "wsse:KeyIdentifier");
        keyId.setAttributeNS(this.wssConfig.getWsseNS(), "ValueType", "http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-saml-token-profile-1.0#SAMLAssertionID");
        keyId.appendChild(doc.createTextNode(keyIdVal));
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(keyId, elem);
        } else {
            this.element.appendChild(keyId);
        }
    }

    public X509Certificate[] getKeyIdentifier(Crypto crypto) throws WSSecurityException {
        String alias;
        X509Security token = null;
        Element elem = this.getFirstElement();
        String value = elem.getAttribute("ValueType");
        if (value.length() == 0 && (this.wssConfig.getProcessNonCompliantMessages() || this.wssConfig.isBSTAttributesQualified())) {
            value = WSSecurityUtil.getAttributeValueWSSE(elem, "ValueType", null);
        }
        if (value.endsWith("X509v3")) {
            token = new X509Security(this.wssConfig, elem);
            if (token != null) {
                X509Certificate cert = token.getX509Certificate(crypto);
                X509Certificate[] certs = new X509Certificate[]{cert};
                return certs;
            }
        } else if (value.equals(SKI_URI) && (alias = this.getX509SKIAlias(crypto)) != null) {
            return crypto.getCertificates(alias);
        }
        return null;
    }

    public String getX509SKIAlias(Crypto crypto) throws WSSecurityException {
        if (this.skiBytes == null) {
            this.skiBytes = this.getSKIBytes();
            if (this.skiBytes == null) {
                return null;
            }
        }
        String alias = crypto.getAliasForX509Cert(this.skiBytes);
        if (doDebug) {
            log.info((Object)("X509 SKI alias: " + alias));
        }
        return alias;
    }

    public byte[] getSKIBytes() {
        if (this.skiBytes != null) {
            return this.skiBytes;
        }
        Node node = this.getFirstElement().getFirstChild();
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 3) {
            try {
                this.skiBytes = Base64.decode(((Text)node).getData());
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.skiBytes;
    }

    public void setX509IssuerSerial(XMLX509IssuerSerial ref) {
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(ref.getElement(), elem);
        } else {
            this.element.appendChild(ref.getElement());
        }
    }

    public X509Certificate[] getX509IssuerSerial(Crypto crypto) throws WSSecurityException {
        String alias = this.getX509IssuerSerialAlias(crypto);
        if (alias != null) {
            return crypto.getCertificates(alias);
        }
        return null;
    }

    public String getX509IssuerSerialAlias(Crypto crypto) throws WSSecurityException {
        if (this.issuerSerial == null) {
            this.issuerSerial = this.getIssuerSerial();
            if (this.issuerSerial == null) {
                return null;
            }
        }
        String alias = crypto.getAliasForX509Cert(this.issuerSerial.getIssuerName(), this.issuerSerial.getSerialNumber());
        if (doDebug) {
            log.info((Object)("X509IssuerSerial alias: " + alias));
        }
        return alias;
    }

    private XMLX509IssuerSerial getIssuerSerial() throws WSSecurityException {
        if (this.issuerSerial != null) {
            return this.issuerSerial;
        }
        Element elem = this.getFirstElement();
        if (elem == null) {
            return null;
        }
        try {
            this.issuerSerial = new XMLX509IssuerSerial(elem, "");
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(7, "noToken", new Object[]{"Issuer/Serial data element missing"});
        }
        return this.issuerSerial;
    }

    public Element getFirstElement() {
        for (Node currentChild = this.element.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!(currentChild instanceof Element)) continue;
            return (Element)currentChild;
        }
        return null;
    }

    public boolean containsKeyName() {
        return this.element.getLocalName().equals(KEY_NAME);
    }

    public String getKeyNameValue() {
        return this.element.getFirstChild().getNodeValue();
    }

    public boolean containsReference() {
        return this.lengthReference() > 0;
    }

    public int lengthReference() {
        if (this.wssConfig.getProcessNonCompliantMessages()) {
            int length = 0;
            for (int i = 0; length == 0 && i < WSConstants.WSSE_NS_ARRAY.length; ++i) {
                length = this.length(WSConstants.WSSE_NS_ARRAY[i], "Reference");
            }
            return length;
        }
        return this.length(this.wssConfig.getWsseNS(), "Reference");
    }

    public boolean containsX509IssuerSerial() {
        return this.lengthX509IssuerSerial() > 0;
    }

    public int lengthX509IssuerSerial() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial");
    }

    public boolean containsKeyIdentifier() {
        return this.lengthKeyIdentifier() > 0;
    }

    public int lengthKeyIdentifier() {
        if (this.wssConfig.getProcessNonCompliantMessages()) {
            for (int i = 0; i < WSConstants.WSSE_NS_ARRAY.length; ++i) {
                int len = this.length(WSConstants.WSSE_NS_ARRAY[i], "KeyIdentifier");
                if (len <= 0) continue;
                return len;
            }
        } else {
            return this.length(this.wssConfig.getWsseNS(), "KeyIdentifier");
        }
        return 0;
    }

    public int length(String namespace, String localname) {
        NodeList childNodes = this.element.getChildNodes();
        int maxLength = childNodes.getLength();
        int result = 0;
        for (int i = 0; i < maxLength; ++i) {
            Node n = childNodes.item(i);
            if (n.getNodeType() != 1) continue;
            String ns = n.getNamespaceURI();
            String name = n.getLocalName();
            if ((namespace == null || ns == null || !namespace.equals(ns)) && (namespace != null || ns != null) || !localname.equals(name)) continue;
            ++result;
        }
        return result;
    }

    public Element getElement() {
        return this.element;
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, this.wssConfig.getWsuNS(), "wsu");
        this.element.setAttributeNS(this.wssConfig.getWsuNS(), prefix + ":Id", id);
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

