/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.war.impl.xml.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ow2.util.ee.metadata.common.api.ICommonClassMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonFieldMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonMethodMetadata;
import org.ow2.util.ee.metadata.common.api.interfaces.IEnvironmentRefAccessor;
import org.ow2.util.ee.metadata.common.api.interfaces.ISharedMetadata;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEnvironment;
import org.ow2.util.ee.metadata.common.impl.xml.merge.MetadataMerge;
import org.ow2.util.ee.metadata.war.api.IWarClassMetadata;
import org.ow2.util.ee.metadata.war.api.IWarFieldMetadata;
import org.ow2.util.ee.metadata.war.api.IWarMethodMetadata;
import org.ow2.util.ee.metadata.war.impl.WarDeployableMetadata;
import org.ow2.util.ee.metadata.war.impl.xml.struct.WAR;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarMetadataMerge
extends MetadataMerge {
    private static final Log LOGGER = LogFactory.getLog(WarMetadataMerge.class);
    private WarDeployableMetadata warDeployableMetadata;

    public WarMetadataMerge(WarDeployableMetadata warDeployableMetadata) {
        this.warDeployableMetadata = warDeployableMetadata;
    }

    public void merge(WAR war) {
        this.applyJndiEnvironmentRefsGroup((IEnvironment)war, (IEnvironmentRefAccessor)this.warDeployableMetadata);
        for (IWarClassMetadata warClassmetadata : this.warDeployableMetadata.getWarClassMetadataCollection()) {
            List annotationResourcesDeployable;
            List persistenceUnitsDeployable = this.warDeployableMetadata.getJavaxPersistencePersistenceUnits();
            if (persistenceUnitsDeployable != null && persistenceUnitsDeployable.size() > 0) {
                List persistenceUnitsClass = warClassmetadata.getJavaxPersistencePersistenceUnits();
                if (persistenceUnitsClass == null) {
                    warClassmetadata.setJavaxPersistencePersistenceUnits(persistenceUnitsDeployable);
                } else {
                    persistenceUnitsClass.addAll(persistenceUnitsDeployable);
                }
            }
            if ((annotationResourcesDeployable = this.warDeployableMetadata.getJAnnotationResources()) == null || annotationResourcesDeployable.size() <= 0) continue;
            List annotationResourcesClass = warClassmetadata.getJAnnotationResources();
            if (annotationResourcesClass == null) {
                warClassmetadata.setJAnnotationResources(annotationResourcesDeployable);
                continue;
            }
            annotationResourcesClass.addAll(annotationResourcesDeployable);
        }
    }

    protected List<IJaxwsWebServiceRef> findJaxwsWebServiceRefMetadata(IEnvironmentRefAccessor warMetadata, String name) {
        ArrayList<IJaxwsWebServiceRef> elements = new ArrayList<IJaxwsWebServiceRef>();
        Collection<IWarClassMetadata> clientClassesMetadata = this.warDeployableMetadata.getWarClassMetadataCollection();
        if (clientClassesMetadata != null) {
            for (IWarClassMetadata classMetadata : clientClassesMetadata) {
                Collection methodMetadatas;
                Collection fieldMetadatas = classMetadata.getStandardFieldMetadataCollection();
                if (fieldMetadatas != null) {
                    for (IWarFieldMetadata fieldMetadata : fieldMetadatas) {
                        this.addJaxwsWebServiceRefIfFound((ISharedMetadata)fieldMetadata, name, elements);
                    }
                }
                if ((methodMetadatas = classMetadata.getStandardMethodMetadataCollection()) == null) continue;
                for (IWarMethodMetadata methodMetadata : methodMetadatas) {
                    this.addJaxwsWebServiceRefIfFound((ISharedMetadata)methodMetadata, name, elements);
                }
            }
        }
        return elements;
    }

    public IWarClassMetadata getClassMetadata(String className) {
        return this.warDeployableMetadata.getWarClassMetadata(className);
    }

    public String findDefaultClassForEnvironment(IEnvironmentRefAccessor env) {
        return null;
    }

    protected Collection<? extends ICommonClassMetadata> getAllClassMetadatas() {
        return this.warDeployableMetadata.getWarClassMetadataCollection();
    }

    protected Collection<? extends ICommonMethodMetadata> getAllMethodMetadatas() {
        ArrayList methodMetadatas = new ArrayList();
        Collection<IWarClassMetadata> classMetadatas = this.warDeployableMetadata.getWarClassMetadataCollection();
        for (ICommonClassMetadata iCommonClassMetadata : classMetadatas) {
            methodMetadatas.addAll(iCommonClassMetadata.getStandardMethodMetadataCollection());
        }
        return methodMetadatas;
    }

    protected Collection<? extends ICommonFieldMetadata> getAllFieldMetadatas() {
        ArrayList fieldMetadatas = new ArrayList();
        Collection<IWarClassMetadata> classMetadatas = this.warDeployableMetadata.getWarClassMetadataCollection();
        for (ICommonClassMetadata iCommonClassMetadata : classMetadatas) {
            fieldMetadatas.addAll(iCommonClassMetadata.getStandardFieldMetadataCollection());
        }
        return fieldMetadatas;
    }
}

