/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cluster.daemon;

import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import org.ow2.jonas.cluster.daemon.ClusterDaemonTools;
import org.ow2.jonas.cluster.daemon.mbean.JMXRemoteHelper;

public class ClusterDaemonAdmin {
    private static MBeanServerConnection cnx = null;
    private static ObjectInstance oi = null;
    private static final int STOP_CMD = 0;
    private static String confFile = null;
    private static String username = null;
    private static String password = null;

    private ClusterDaemonAdmin() {
    }

    private static void initJmxCnt() {
        try {
            cnx = JMXRemoteHelper.connect(ClusterDaemonTools.getJmxUrl(ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getName()), username, password);
            oi = JMXRemoteHelper.getInstance(cnx, "*:type=ClusterDaemon");
        }
        catch (Exception e) {
            System.err.println("Cannot init MBean server connection : " + e);
            System.exit(2);
        }
    }

    private static void usage() {
        System.err.println("usage : jclusterd <options>");
        System.err.println("list of available options:");
        System.err.println("    start : start the cluster daemon.");
        System.err.println("    stop  : stop the cluster daemon.");
    }

    public static void main(String[] args) {
        int cmd = -1;
        block7: for (int argn = 0; argn < args.length; ++argn) {
            String arg = args[argn];
            if (arg.equals("-stop")) {
                cmd = 0;
            }
            if (arg.equals("-confFile")) {
                confFile = args[++argn];
                continue;
            }
            if (arg.equals("-username")) {
                username = args[++argn];
                continue;
            }
            if (arg.equals("-password")) {
                password = args[++argn];
                continue;
            }
            try {
                ClusterDaemonTools.loadClusterDaemonConfiguration(confFile);
            }
            catch (Exception e) {
                System.err.println("Error during the loading of the configuration file : " + e);
                System.exit(2);
            }
            ClusterDaemonAdmin.initJmxCnt();
            switch (cmd) {
                case 0: {
                    try {
                        Object[] params = new Object[]{};
                        String[] sig = new String[]{};
                        cnx.invoke(oi.getObjectName(), "stopClusterDaemon", params, sig);
                        System.out.println("Cluster daemon stopped");
                    }
                    catch (Exception e) {
                        System.err.println("MBean invocation exception : " + e);
                        System.exit(2);
                    }
                    continue block7;
                }
                default: {
                    System.err.println("Bad cmd: " + cmd);
                    ClusterDaemonAdmin.usage();
                    System.exit(2);
                }
            }
        }
    }
}

