/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.rmi.multi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.util.List;
import java.util.Properties;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorStore;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorsGroup;
import org.ow2.carol.rmi.jrmp.server.JUnicastRemoteObject;
import org.ow2.carol.rmi.util.PortNumber;
import org.ow2.carol.util.configuration.ConfigurationRepository;

public class JrmpPRODelegate
implements PortableRemoteObjectDelegate {
    private int port;

    public JrmpPRODelegate() {
        Properties prop = ConfigurationRepository.getProperties();
        if (prop != null) {
            String propertyName = "carol.jrmp.server.port";
            this.port = PortNumber.strToint(prop.getProperty(propertyName, "0"), propertyName);
        }
    }

    public void exportObject(Remote obj) throws RemoteException {
        JInterceptorStore jiStore = JInterceptorStore.getJInterceptorStore();
        List<JInterceptorsGroup> jinterceptorsList = jiStore.getJInterceptors();
        JUnicastRemoteObject.exportObject(obj, this.port, jinterceptorsList);
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        JUnicastRemoteObject.unexportObject(obj, true);
    }

    public void connect(Remote target, Remote source) throws RemoteException {
    }

    public Object narrow(Object narrowFrom, Class narrowTo) throws ClassCastException {
        if (narrowTo.isAssignableFrom(narrowFrom.getClass())) {
            return narrowFrom;
        }
        throw new ClassCastException("Cannot cast '" + narrowFrom.getClass().getName() + "' in '" + narrowTo.getName() + "'.");
    }

    public Remote toStub(Remote obj) throws NoSuchObjectException {
        return RemoteObject.toStub(obj);
    }
}

