/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.naming.NamingException;
import org.apache.myfaces.config.annotation.DiscoverableLifecycleProvider;
import org.apache.myfaces.config.annotation.LifecycleProvider2;
import org.apache.myfaces.config.annotation.TomcatAnnotationLifecycleProvider;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.tomcat.InstanceManager;

public class Tomcat7AnnotationLifecycleProvider
implements DiscoverableLifecycleProvider,
LifecycleProvider2 {
    private static Logger log = Logger.getLogger(TomcatAnnotationLifecycleProvider.class.getName());
    private WeakHashMap<ClassLoader, InstanceManager> instanceManagers = new WeakHashMap();

    public Tomcat7AnnotationLifecycleProvider(ExternalContext externalContext) {
    }

    public Object newInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NamingException, InvocationTargetException {
        Class clazz = ClassUtils.classForName(className);
        log.info("Creating instance of " + className);
        Object object = clazz.newInstance();
        return object;
    }

    public void destroyInstance(Object instance) throws IllegalAccessException, InvocationTargetException {
        InstanceManager manager = this.instanceManagers.get(ClassUtils.getContextClassLoader());
        if (manager != null) {
            manager.destroyInstance(instance);
        }
    }

    public void postConstruct(Object instance) throws IllegalAccessException, InvocationTargetException {
        InstanceManager manager = this.instanceManagers.get(ClassUtils.getContextClassLoader());
        if (manager == null) {
            manager = this.initManager();
        }
        if (manager != null) {
            try {
                manager.newInstance(instance);
            }
            catch (NamingException e) {
                throw new FacesException((Throwable)e);
            }
        }
    }

    public boolean isAvailable() {
        try {
            Class.forName("org.apache.tomcat.InstanceManager", true, ClassUtils.getContextClassLoader());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private InstanceManager initManager() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            return null;
        }
        ExternalContext extCtx = context.getExternalContext();
        if (extCtx == null) {
            return null;
        }
        Map applicationMap = extCtx.getApplicationMap();
        InstanceManager instanceManager = (InstanceManager)applicationMap.get(InstanceManager.class.getName());
        if (instanceManager != null) {
            this.instanceManagers.put(ClassUtils.getContextClassLoader(), instanceManager);
        }
        return instanceManager;
    }
}

