/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.util.HTMLEncoder;
import org.apache.myfaces.shared_impl.renderkit.html.util.UnicodeEncoder;
import org.apache.myfaces.shared_impl.util.CommentUtils;
import org.apache.myfaces.shared_impl.util.FastWriter;

public class HtmlResponseWriterImpl
extends ResponseWriter {
    private static final Logger log = Logger.getLogger(HtmlResponseWriterImpl.class.getName());
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private static final String UTF8 = "UTF-8";
    private static String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    private static String TEXT_XML_CONTENT_TYPE = "text/xml";
    private Writer _outputWriter;
    private Writer _currentWriter;
    private FastWriter _bufferedWriter;
    private String _contentType;
    private boolean _isXhtmlContentType;
    private boolean _useStraightXml;
    private String _characterEncoding;
    private boolean _wrapScriptContentWithXmlCommentTag;
    private String _startElementName;
    private Boolean _isInsideScript;
    private Boolean _isStyle;
    private Boolean _isTextArea;
    private UIComponent _startElementUIComponent;
    private boolean _startTagOpen;
    private boolean _cdataOpen;
    private static final Set<String> s_emptyHtmlElements = new HashSet<String>();
    private static final String CDATA_START = "<![CDATA[ \n";
    private static final String CDATA_START_NO_LINE_RETURN = "<![CDATA[";
    private static final String COMMENT_START = "<!--\n";
    private static final String CDATA_COMMENT_START = "//<![CDATA[ \n";
    private static final String CDATA_COMMENT_END = "\n//]]>";
    private static final String CDATA_END = "\n]]>";
    private static final String CDATA_END_NO_LINE_RETURN = "]]>";
    private static final String COMMENT_COMMENT_END = "\n//-->";
    private static final String COMMENT_END = "\n-->";

    public HtmlResponseWriterImpl(Writer writer, String contentType, String characterEncoding) {
        this(writer, contentType, characterEncoding, true);
    }

    public HtmlResponseWriterImpl(Writer writer, String contentType, String characterEncoding, boolean wrapScriptContentWithXmlCommentTag) throws FacesException {
        this._currentWriter = this._outputWriter = writer;
        this._bufferedWriter = new FastWriter(1024);
        this._wrapScriptContentWithXmlCommentTag = wrapScriptContentWithXmlCommentTag;
        this._contentType = contentType;
        if (this._contentType == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No content type given, using default content type text/html");
            }
            this._contentType = DEFAULT_CONTENT_TYPE;
        }
        this._isXhtmlContentType = HtmlRendererUtils.isXHTMLContentType(this._contentType);
        boolean bl = this._useStraightXml = this._contentType.indexOf(APPLICATION_XML_CONTENT_TYPE) != -1 || this._contentType.indexOf(TEXT_XML_CONTENT_TYPE) != -1;
        if (characterEncoding == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No character encoding given, using default character encoding ISO-8859-1");
            }
            this._characterEncoding = DEFAULT_CHARACTER_ENCODING;
        } else {
            try {
                new String("myfaces".getBytes(), characterEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Unsupported encoding: " + characterEncoding);
            }
            this._characterEncoding = characterEncoding.toUpperCase();
        }
    }

    public static boolean supportsContentType(String contentType) {
        String[] supportedContentTypes = HtmlRendererUtils.getSupportedContentTypes();
        for (int i = 0; i < supportedContentTypes.length; ++i) {
            String supportedContentType = supportedContentTypes[i];
            if (supportedContentType.indexOf(contentType) == -1) continue;
            return true;
        }
        return false;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public void flush() throws IOException {
        this.closeStartTagIfNecessary();
    }

    public void startDocument() {
    }

    public void endDocument() throws IOException {
        this._currentWriter.flush();
    }

    public void startElement(String name, UIComponent uiComponent) throws IOException {
        if (name == null) {
            throw new NullPointerException("elementName name must not be null");
        }
        this.closeStartTagIfNecessary();
        this._currentWriter.write(60);
        this._currentWriter.write(name);
        this.resetStartedElement();
        this._startElementName = name;
        this._startElementUIComponent = uiComponent;
        this._startTagOpen = true;
        if (this.isScript(name)) {
            this._isInsideScript = Boolean.TRUE;
            this._isStyle = Boolean.FALSE;
            this._isTextArea = Boolean.FALSE;
        } else if (this.isStyle(name)) {
            this._isInsideScript = Boolean.FALSE;
            this._isStyle = Boolean.TRUE;
            this._isTextArea = Boolean.FALSE;
        }
    }

    public void startCDATA() throws IOException {
        if (!this._cdataOpen) {
            this.write(CDATA_START_NO_LINE_RETURN);
            this._cdataOpen = true;
        }
    }

    public void endCDATA() throws IOException {
        if (this._cdataOpen) {
            this.write(CDATA_END_NO_LINE_RETURN);
            this._cdataOpen = false;
        }
    }

    private void closeStartTagIfNecessary() throws IOException {
        if (this._startTagOpen) {
            if (!this._useStraightXml && s_emptyHtmlElements.contains(this._startElementName.toLowerCase())) {
                this._currentWriter.write(" />");
                this.resetStartedElement();
            } else {
                this._currentWriter.write(62);
                if (this.isScript(this._startElementName) && (this._isXhtmlContentType || this._wrapScriptContentWithXmlCommentTag)) {
                    this._bufferedWriter.reset();
                    this._currentWriter = this._bufferedWriter;
                }
                if (this.isStyle(this._startElementName) && this._isXhtmlContentType) {
                    this._bufferedWriter.reset();
                    this._currentWriter = this._bufferedWriter;
                }
            }
            this._startTagOpen = false;
        }
    }

    private void resetStartedElement() {
        this._startElementName = null;
        this._startElementUIComponent = null;
        this._isStyle = null;
        this._isTextArea = null;
    }

    public void endElement(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("elementName name must not be null");
        }
        if (log.isLoggable(Level.WARNING) && this._startElementName != null && !name.equals(this._startElementName)) {
            log.warning("HTML nesting warning on closing " + name + ": element " + this._startElementName + (this._startElementUIComponent == null ? "" : " rendered by component : " + RendererUtils.getPathToComponent(this._startElementUIComponent)) + " not explicitly closed");
        }
        if (this._startTagOpen) {
            this.closeStartTagIfNecessary();
            if (this._startElementName != null) {
                if (this.isScript() && (this._isXhtmlContentType || this._wrapScriptContentWithXmlCommentTag)) {
                    this.writeScriptContent();
                    this._currentWriter = this._outputWriter;
                } else if (this.isStyle() && this._isXhtmlContentType) {
                    this.writeStyleContent();
                    this._currentWriter = this._outputWriter;
                }
                this.writeEndTag(name);
            }
        } else if (this._useStraightXml || !s_emptyHtmlElements.contains(name.toLowerCase())) {
            if (this.isScript() && (this._isXhtmlContentType || this._wrapScriptContentWithXmlCommentTag)) {
                this.writeScriptContent();
                this._currentWriter = this._outputWriter;
            } else if (this.isStyle() && this._isXhtmlContentType) {
                this.writeStyleContent();
                this._currentWriter = this._outputWriter;
            }
            this.writeEndTag(name);
        }
        this.resetStartedElement();
    }

    private void writeStyleContent() throws IOException {
        String content = this._bufferedWriter.toString();
        if (this._isXhtmlContentType) {
            String trimmedContent = content.trim();
            if (trimmedContent.startsWith(CDATA_START_NO_LINE_RETURN) && trimmedContent.endsWith(CDATA_END_NO_LINE_RETURN)) {
                this._outputWriter.write(content);
                return;
            }
            if (CommentUtils.isStartMatchWithCommentedCDATA(trimmedContent) && CommentUtils.isEndMatchWithCommentedCDATA(trimmedContent)) {
                this._outputWriter.write(content);
                return;
            }
            if (trimmedContent.startsWith("<!--") && trimmedContent.endsWith("-->")) {
                this._outputWriter.write(CDATA_START);
                this._outputWriter.write(trimmedContent.substring(4, trimmedContent.length() - 3));
                this._outputWriter.write(CDATA_END);
                return;
            }
            this._outputWriter.write(CDATA_START);
            this._outputWriter.write(content);
            this._outputWriter.write(CDATA_END);
            return;
        }
        this._outputWriter.write(content);
    }

    private void writeScriptContent() throws IOException {
        String content = this._bufferedWriter.toString();
        String trimmedContent = null;
        if (this._isXhtmlContentType) {
            trimmedContent = content.trim();
            if (trimmedContent.startsWith("<!--") && CommentUtils.isEndMatchtWithInlineCommentedXmlCommentTag(trimmedContent)) {
                if (this._cdataOpen) {
                    this._outputWriter.write("//\n");
                } else {
                    this._outputWriter.write(CDATA_COMMENT_START);
                }
                this._outputWriter.write(trimmedContent.substring(4));
                if (this._cdataOpen) {
                    this._outputWriter.write("\n");
                } else {
                    this._outputWriter.write(CDATA_COMMENT_END);
                }
                return;
            }
            if (CommentUtils.isStartMatchWithCommentedCDATA(trimmedContent) && CommentUtils.isEndMatchWithCommentedCDATA(trimmedContent)) {
                this._outputWriter.write(content);
                return;
            }
            if (CommentUtils.isStartMatchWithInlineCommentedCDATA(trimmedContent) && CommentUtils.isEndMatchWithInlineCommentedCDATA(trimmedContent)) {
                this._outputWriter.write(content);
                return;
            }
            if (this._cdataOpen) {
                this._outputWriter.write("//\n");
            } else {
                this._outputWriter.write(CDATA_COMMENT_START);
            }
            this._outputWriter.write(content);
            if (this._cdataOpen) {
                this._outputWriter.write("\n");
            } else {
                this._outputWriter.write(CDATA_COMMENT_END);
            }
            return;
        }
        if (this._wrapScriptContentWithXmlCommentTag) {
            trimmedContent = content.trim();
            if (trimmedContent.startsWith("<!--") && CommentUtils.isEndMatchtWithInlineCommentedXmlCommentTag(trimmedContent)) {
                this._outputWriter.write(content);
                return;
            }
            if (CommentUtils.isStartMatchWithCommentedCDATA(trimmedContent) && CommentUtils.isEndMatchWithCommentedCDATA(trimmedContent)) {
                this._outputWriter.write(content);
                return;
            }
            if (CommentUtils.isStartMatchWithInlineCommentedCDATA(trimmedContent) && CommentUtils.isEndMatchWithInlineCommentedCDATA(trimmedContent)) {
                this._outputWriter.write(content);
                return;
            }
            this._outputWriter.write(COMMENT_START);
            this._outputWriter.write(content);
            this._outputWriter.write(COMMENT_COMMENT_END);
            return;
        }
        this._outputWriter.write(content);
    }

    private void writeEndTag(String name) throws IOException {
        if (this.isScript(name)) {
            this._isInsideScript = Boolean.FALSE;
        } else if (this.isStyle(name)) {
            this._isStyle = Boolean.FALSE;
        }
        this._currentWriter.write("</");
        this._currentWriter.write(name);
        this._currentWriter.write(62);
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (name == null) {
            throw new NullPointerException("attributeName name must not be null");
        }
        if (!this._startTagOpen) {
            throw new IllegalStateException("Must be called before the start element is closed (attribute '" + name + "')");
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                this._currentWriter.write(32);
                this._currentWriter.write(name);
                this._currentWriter.write("=\"");
                this._currentWriter.write(name);
                this._currentWriter.write(34);
            }
        } else {
            String strValue = value == null ? "" : value.toString();
            this._currentWriter.write(32);
            this._currentWriter.write(name);
            this._currentWriter.write("=\"");
            this._currentWriter.write(HTMLEncoder.encode(strValue, false, false, !UTF8.equals(this._characterEncoding)));
            this._currentWriter.write(34);
        }
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (name == null) {
            throw new NullPointerException("attributeName name must not be null");
        }
        if (!this._startTagOpen) {
            throw new IllegalStateException("Must be called before the start element is closed (attribute '" + name + "')");
        }
        String strValue = value.toString();
        this._currentWriter.write(32);
        this._currentWriter.write(name);
        this._currentWriter.write("=\"");
        if (strValue.toLowerCase().startsWith("javascript:")) {
            this._currentWriter.write(HTMLEncoder.encode(strValue, false, false, !UTF8.equals(this._characterEncoding)));
        } else {
            this._currentWriter.write(HTMLEncoder.encodeURIAtributte(strValue, this._characterEncoding));
        }
        this._currentWriter.write(34);
    }

    public void writeComment(Object value) throws IOException {
        if (value == null) {
            throw new NullPointerException("comment name must not be null");
        }
        this.closeStartTagIfNecessary();
        this._currentWriter.write("<!--");
        this._currentWriter.write(value.toString());
        this._currentWriter.write("-->");
    }

    public void writeText(Object value, String componentPropertyName) throws IOException {
        if (value == null) {
            throw new NullPointerException("Text must not be null.");
        }
        this.closeStartTagIfNecessary();
        String strValue = value.toString();
        if (this.isScriptOrStyle()) {
            if (UTF8.equals(this._characterEncoding)) {
                this._currentWriter.write(strValue);
            } else {
                this._currentWriter.write(UnicodeEncoder.encode(strValue));
            }
        } else {
            this._currentWriter.write(HTMLEncoder.encode(strValue, false, false, !UTF8.equals(this._characterEncoding)));
        }
    }

    public void writeText(char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            throw new NullPointerException("cbuf name must not be null");
        }
        if (cbuf.length < off + len) {
            throw new IndexOutOfBoundsException(off + len + " > " + cbuf.length);
        }
        this.closeStartTagIfNecessary();
        if (this.isScriptOrStyle()) {
            String strValue = new String(cbuf, off, len);
            if (UTF8.equals(this._characterEncoding)) {
                this._currentWriter.write(strValue);
            } else {
                this._currentWriter.write(UnicodeEncoder.encode(strValue));
            }
        } else if (this.isTextarea()) {
            HTMLEncoder.encode(cbuf, off, len, false, false, !UTF8.equals(this._characterEncoding), this._currentWriter);
        } else {
            HTMLEncoder.encode(cbuf, off, len, true, true, !UTF8.equals(this._characterEncoding), this._currentWriter);
        }
    }

    private boolean isScriptOrStyle() {
        return this._isStyle != null && this._isStyle != false || this._isInsideScript != null && this._isInsideScript != false;
    }

    private boolean isScript(String element) {
        return "script".equalsIgnoreCase(element);
    }

    private boolean isScript() {
        return this._isInsideScript != null && this._isInsideScript != false;
    }

    private boolean isStyle(String element) {
        return "style".equalsIgnoreCase(element);
    }

    private boolean isStyle() {
        return this._isStyle != null && this._isStyle != false;
    }

    private boolean isTextarea() {
        this.initializeStartedTagInfo();
        return this._isTextArea != null && this._isTextArea != false;
    }

    private void initializeStartedTagInfo() {
        if (this._startElementName != null && this._isTextArea == null) {
            this._isTextArea = this._startElementName.equalsIgnoreCase("textarea") ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        HtmlResponseWriterImpl newWriter = new HtmlResponseWriterImpl(writer, this.getContentType(), this.getCharacterEncoding(), this._wrapScriptContentWithXmlCommentTag);
        return newWriter;
    }

    public void close() throws IOException {
        this.closeStartTagIfNecessary();
        this._currentWriter.close();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartTagIfNecessary();
        String strValue = new String(cbuf, off, len);
        if (UTF8.equals(this._characterEncoding)) {
            this._currentWriter.write(strValue);
        } else {
            this._currentWriter.write(UnicodeEncoder.encode(strValue));
        }
    }

    public void write(int c) throws IOException {
        this.closeStartTagIfNecessary();
        this._currentWriter.write(c);
    }

    public void write(char[] cbuf) throws IOException {
        this.closeStartTagIfNecessary();
        String strValue = new String(cbuf);
        if (UTF8.equals(this._characterEncoding)) {
            this._currentWriter.write(strValue);
        } else {
            this._currentWriter.write(UnicodeEncoder.encode(strValue));
        }
    }

    public void write(String str) throws IOException {
        this.closeStartTagIfNecessary();
        if (str.length() > 0) {
            if (UTF8.equals(this._characterEncoding)) {
                this._currentWriter.write(str);
            } else {
                this._currentWriter.write(UnicodeEncoder.encode(str));
            }
        }
    }

    public void write(String str, int off, int len) throws IOException {
        this.closeStartTagIfNecessary();
        String strValue = str.substring(off, off + len);
        if (UTF8.equals(this._characterEncoding)) {
            this._currentWriter.write(strValue);
        } else {
            this._currentWriter.write(UnicodeEncoder.encode(strValue));
        }
    }

    public void writeText(Object object, UIComponent component, String string) throws IOException {
        this.writeText(object, string);
    }

    static {
        s_emptyHtmlElements.add("area");
        s_emptyHtmlElements.add("br");
        s_emptyHtmlElements.add("base");
        s_emptyHtmlElements.add("basefont");
        s_emptyHtmlElements.add("col");
        s_emptyHtmlElements.add("frame");
        s_emptyHtmlElements.add("hr");
        s_emptyHtmlElements.add("img");
        s_emptyHtmlElements.add("input");
        s_emptyHtmlElements.add("isindex");
        s_emptyHtmlElements.add("link");
        s_emptyHtmlElements.add("meta");
        s_emptyHtmlElements.add("param");
    }
}

