/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;

public class PointbaseDictionary
extends DBDictionary {
    public PointbaseDictionary() {
        this.platform = "Pointbase Embedded";
        this.supportsDeferredConstraints = false;
        this.supportsMultipleNontransactionalResultSets = false;
        this.requiresAliasForSubselect = true;
        this.supportsLockingWithDistinctClause = false;
        this.supportsLockingWithMultipleTables = false;
        this.supportsLockingWithDistinctClause = false;
        this.bitTypeName = "TINYINT";
        this.blobTypeName = "BLOB(1M)";
        this.longVarbinaryTypeName = "BLOB(1M)";
        this.charTypeName = "CHARACTER{0}";
        this.clobTypeName = "CLOB(1M)";
        this.doubleTypeName = "DOUBLE PRECISION";
        this.floatTypeName = "FLOAT";
        this.bigintTypeName = "BIGINT";
        this.integerTypeName = "INTEGER";
        this.realTypeName = "REAL";
        this.smallintTypeName = "SMALLINT";
        this.tinyintTypeName = "TINYINT";
        this.supportsAutoAssign = true;
        this.lastGeneratedKeyQuery = "SELECT MAX({0}) FROM {1}";
        this.autoAssignTypeName = "BIGINT IDENTITY";
    }

    public int getPreferredType(int type) {
        switch (type) {
            case -1: {
                return 2005;
            }
        }
        return super.getPreferredType(type);
    }

    public Column[] getColumns(DatabaseMetaData meta, String catalog, String schemaName, String tableName, String columnName, Connection conn) throws SQLException {
        return this.getColumns(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), DBIdentifier.newColumn(columnName), conn);
    }

    public Column[] getColumns(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, DBIdentifier columnName, Connection conn) throws SQLException {
        Column[] cols = super.getColumns(meta, catalog, schemaName, tableName, columnName, conn);
        for (int i = 0; cols != null && i < cols.length; ++i) {
            if (!cols[i].getTypeIdentifier().getName().toUpperCase().startsWith("CLOB")) continue;
            cols[i].setType(2005);
        }
        return cols;
    }

    public String getFullName(Index index) {
        return this.toDBName(this.getNamingUtil().append(DBIdentifier.DBIdentifierType.INDEX, this.getFullIdentifier(index.getTable(), false), index.getIdentifier()));
    }

    public void substring(SQLBuffer buf, FilterValue str, FilterValue start, FilterValue end) {
        buf.append("SUBSTRING(");
        str.appendTo(buf);
        buf.append(" FROM ");
        start.appendTo(buf);
        buf.append(" + 1");
        if (end != null) {
            buf.append(" FOR ");
            end.appendTo(buf);
            buf.append(" - (");
            start.appendTo(buf);
            buf.append(")");
        }
        buf.append(")");
    }

    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        buf.append("(POSITION(");
        find.appendTo(buf);
        buf.append(" IN ");
        if (start != null) {
            this.substring(buf, str, start, null);
        } else {
            str.appendTo(buf);
        }
        buf.append(") - 1");
        if (start != null) {
            buf.append(" + ");
            start.appendTo(buf);
        }
        buf.append(")");
    }
}

