/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.openjpa.lib.jdbc.DecoratingDataSource;
import org.apache.openjpa.slice.jdbc.DistributedConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedDataSource
extends DecoratingDataSource
implements Iterable<DataSource> {
    private List<DataSource> real = new ArrayList<DataSource>();
    private DataSource master;

    public DistributedDataSource(List<DataSource> dataSources) {
        super(dataSources.get(0));
        this.real = dataSources;
        this.master = dataSources.get(0);
    }

    public void addDataSource(DataSource ds) {
        this.real.add(ds);
    }

    Connection getConnection(DataSource ds) throws SQLException {
        if (ds instanceof DecoratingDataSource) {
            return this.getConnection(((DecoratingDataSource)ds).getInnermostDelegate());
        }
        if (ds instanceof XADataSource) {
            return ((XADataSource)((Object)ds)).getXAConnection().getConnection();
        }
        return ds.getConnection();
    }

    Connection getConnection(DataSource ds, String user, String pwd) throws SQLException {
        if (ds instanceof DecoratingDataSource) {
            return this.getConnection(((DecoratingDataSource)ds).getInnermostDelegate(), user, pwd);
        }
        if (ds instanceof XADataSource) {
            return ((XADataSource)((Object)ds)).getXAConnection(user, pwd).getConnection();
        }
        return ds.getConnection(user, pwd);
    }

    @Override
    public Iterator<DataSource> iterator() {
        return this.real.iterator();
    }

    @Override
    public Connection getConnection() throws SQLException {
        ArrayList<Connection> c = new ArrayList<Connection>();
        for (DataSource ds : this.real) {
            c.add(ds.getConnection());
        }
        return DistributedConnection.newInstance(c);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        ArrayList<Connection> c = new ArrayList<Connection>();
        for (DataSource ds : this.real) {
            c.add(ds.getConnection(username, password));
        }
        return DistributedConnection.newInstance(c);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.master.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.master.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        for (DataSource ds : this.real) {
            ds.setLogWriter(out);
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        for (DataSource ds : this.real) {
            ds.setLoginTimeout(seconds);
        }
    }

    @Override
    protected void enforceAbstract() {
    }
}

