/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.cluster;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.ow2.jonas.ant.cluster.ClusterTasks;
import org.ow2.jonas.ant.jonasbase.Carol;

public class CarolCluster
extends ClusterTasks {
    private static final String INFO = "[CarolCluster] ";
    private String[] portRange = null;
    private String protocols = null;
    private boolean jrmpOptimization = false;

    public void setProtocols(String protocols) {
        this.protocols = protocols;
    }

    public void setPortRange(String portRange) {
        this.portRange = portRange.split(",");
    }

    public void setJrmpOptimization(boolean jrmpOptimization) {
        this.jrmpOptimization = jrmpOptimization;
    }

    public void generatesTasks() {
        int portInd = 0;
        for (int i = this.getDestDirSuffixIndFirst(); i <= this.getDestDirSuffixIndLast(); ++i) {
            String destDir = CarolCluster.getDestDir(this.getDestDirPrefix(), i);
            Carol carol = new Carol();
            this.log("[CarolCluster] tasks generation for " + destDir);
            carol.setDefaultPort(this.portRange[portInd]);
            carol.setProtocols(this.protocols);
            carol.setJrmpOptimization(this.jrmpOptimization);
            carol.setCmiStarted(true);
            int webIstNb = this.getWebInstNb();
            if (this.getArch().equals("diffWebEjb") && i <= webIstNb) {
                int ejbInstNb = this.getEjbInstNb();
                String seqProtocol2ProviderURLs = "";
                for (String protocol : this.protocols.split(",")) {
                    if (seqProtocol2ProviderURLs != "") {
                        seqProtocol2ProviderURLs = seqProtocol2ProviderURLs + ";";
                    }
                    seqProtocol2ProviderURLs = seqProtocol2ProviderURLs + protocol + "::";
                    if (protocol.equals("jrmp") || protocol.equals("irmi")) {
                        seqProtocol2ProviderURLs = seqProtocol2ProviderURLs + "rmi://";
                    } else if (protocol.equals("iiop")) {
                        seqProtocol2ProviderURLs = seqProtocol2ProviderURLs + "iiop://";
                    } else {
                        this.log("[CarolCluster] Unknown protocol: " + protocol);
                        throw new BuildException("Unknown protocol: " + protocol);
                    }
                    for (int j = webIstNb; j < webIstNb + ejbInstNb; ++j) {
                        if (j != webIstNb) {
                            seqProtocol2ProviderURLs = seqProtocol2ProviderURLs + ",";
                        }
                        seqProtocol2ProviderURLs = seqProtocol2ProviderURLs + "localhost:" + this.portRange[j];
                    }
                }
                carol.setClusterViewProviderUrls(seqProtocol2ProviderURLs);
            }
            carol.setDestDir(new File(destDir));
            this.addTask(carol);
            ++portInd;
        }
    }
}

