/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.jaxws;

import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.RuntimeModeler;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.wsdl.writer.WSDLGenerator;
import com.sun.xml.ws.wsdl.writer.WSDLResolver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Binding;
import javax.xml.ws.Holder;
import javax.xml.ws.handler.Handler;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.jaxws.binding.BindingUtils;
import org.apache.axis2.jaxws.context.WebServiceContextImpl;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.factory.EndpointLifecycleManagerFactory;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportReceiver;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.TransportHeaders;
import org.apache.axis2.transport.http.util.RESTUtil;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.axis2.util.UUIDGenerator;
import org.apache.xbean.recipe.ObjectRecipe;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.easybeans.resolver.api.EZBJNDIBeanData;
import org.ow2.easybeans.resolver.api.EZBRemoteJNDIResolver;
import org.ow2.jonas.ws.axis2.easybeans.Axis2EjbMessageReceiver;
import org.ow2.jonas.ws.axis2.easybeans.Axis2EndpointLifecycleManagerFactory;
import org.ow2.jonas.ws.axis2.http.Axis2RequestResponseTransport;
import org.ow2.jonas.ws.axis2.http.Axis2TransportInfo;
import org.ow2.jonas.ws.axis2.http.AxisServiceGenerator;
import org.ow2.jonas.ws.axis2.http.WSDLQueryHandler;
import org.ow2.jonas.ws.axis2.jaxws.description.impl.DescriptionUtils;
import org.ow2.jonas.ws.axis2.util.JAXWSUtils;
import org.ow2.jonas.ws.jaxws.IWSRequest;
import org.ow2.jonas.ws.jaxws.IWSResponse;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortIdentifier;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2WSEndpoint
implements IWebServiceEndpoint {
    private static final Log logger = LogFactory.getLog(Axis2WSEndpoint.class);
    private String style = "document";
    private String use = "literal";
    protected ConfigurationContext configurationContext;
    protected AxisService service;
    protected Binding binding;
    protected PortMetaData portMetaData;
    protected Class endpointClass;
    protected WSDLQueryHandler wsdlQueryHandler;
    protected StatelessSessionFactory factory;
    protected URL moduleURL;
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String TOOLS = "tools.jar";
    private int forkTimeout;
    private static final long FORK_POLL_FREQUENCY = 2000L;
    private URL wsdlFile;
    private URL wsdlFileURL;
    private PortIdentifier identifier;
    private IWebServiceEndpoint.EndpointType type;
    public static final String END_POINT_TYPE = "EndPointType";

    public Axis2WSEndpoint(Class endpointClass, IWebServiceEndpoint.EndpointType type, PortMetaData portMetaData, StatelessSessionFactory factory, URL moduleURL) {
        this.endpointClass = endpointClass;
        this.portMetaData = portMetaData;
        this.type = type;
        this.factory = factory;
        this.moduleURL = moduleURL;
        this.forkTimeout = 60000;
        String name = endpointClass.getSimpleName();
        String namespace = JAXWSUtils.getDefaultNamespace(endpointClass);
        this.identifier = new PortIdentifier(new QName(namespace, name), portMetaData.getContextRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        this.configurationContext = ConfigurationContextFactory.createBasicConfigurationContext((String)"META-INF/axis2.xml");
        AxisServiceGenerator serviceGen = this.createServiceGenerator();
        this.service = serviceGen.getServiceFromClass(this.endpointClass, this.configurationContext, this.portMetaData);
        this.service.setScope("application");
        this.configurationContext.getAxisConfiguration().addService(this.service);
        this.wsdlQueryHandler = new WSDLQueryHandler(this.service);
        if (this.type == IWebServiceEndpoint.EndpointType.EJB) {
            this.configurationContext.setContextRoot(this.portMetaData.getContextRoot());
            this.configurationContext.setServicePath(this.portMetaData.getUrlPattern());
        }
        this.configureHandlers();
        FactoryRegistry.setFactory(EndpointLifecycleManagerFactory.class, (Object)new Axis2EndpointLifecycleManagerFactory());
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            this.wsdlFile = this.generateWSDL();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private URL generateWSDL() throws Exception {
        BindingID bindingID = BindingID.parse(this.endpointClass);
        WebServiceFeatureList wsfeatures = new WebServiceFeatureList(this.endpointClass);
        QName qName = new QName(this.service.getTargetNamespace(), this.service.getName());
        RuntimeModeler rtModeler = new RuntimeModeler(this.endpointClass, qName, bindingID);
        URL mURL = null;
        mURL = this.type == IWebServiceEndpoint.EndpointType.POJO ? new URL(this.moduleURL.toString() + "WEB-INF/classes/") : new URL(this.moduleURL.toString());
        ClassLoader classLoader = null;
        classLoader = this.type == IWebServiceEndpoint.EndpointType.POJO ? new URLClassLoader(new URL[]{mURL}, this.getClass().getClassLoader()) : Thread.currentThread().getContextClassLoader();
        rtModeler.setClassLoader(classLoader);
        if (this.service.getPortTypeName() != null) {
            rtModeler.setPortName(qName);
        }
        AbstractSEIModelImpl rtModel = null;
        try {
            rtModel = rtModeler.buildRuntimeModel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final File[] wsdlFileName = new File[1];
        final HashMap schemaFiles = new HashMap();
        WSDLGenerator wsdlGenerator = new WSDLGenerator(rtModel, new WSDLResolver(){

            private File toFile(String suggestedFilename) {
                return new File(Axis2WSEndpoint.this.moduleURL.getPath(), suggestedFilename);
            }

            private Result toResult(File file) {
                StreamResult result;
                try {
                    result = new StreamResult(new FileOutputStream(file));
                    result.setSystemId(file.getPath().replace('\\', '/'));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
                return result;
            }

            @Override
            public Result getWSDL(String suggestedFilename) {
                File f;
                wsdlFileName[0] = f = this.toFile(suggestedFilename);
                return this.toResult(f);
            }

            public Result getSchemaOutput(String namespace, String suggestedFilename) {
                if (namespace.equals("")) {
                    return null;
                }
                File f = this.toFile(suggestedFilename);
                schemaFiles.put(namespace, f);
                return this.toResult(f);
            }

            @Override
            public Result getAbstractWSDL(Holder<String> filename) {
                return this.toResult(this.toFile((String)filename.value));
            }

            @Override
            public Result getSchemaOutput(String namespace, Holder<String> filename) {
                return this.getSchemaOutput(namespace, (String)filename.value);
            }
        }, bindingID.createBinding(wsfeatures.toArray()), null, this.endpointClass, ServiceFinder.find(WSDLGeneratorExtension.class).toArray());
        wsdlGenerator.doGeneration();
        return wsdlFileName[0].toURL();
    }

    public static String getRelativeNameOrURL(File baseDir, File file) {
        String basePath = baseDir.getAbsolutePath();
        String path = file.getAbsolutePath();
        if (path.startsWith(basePath)) {
            if (File.separatorChar == path.charAt(basePath.length())) {
                return path.substring(basePath.length() + 1);
            }
            return path.substring(basePath.length());
        }
        return file.toURI().toString();
    }

    private File findWsdlFile(File baseDir) {
        QName serviceQName = JAXWSUtils.getServiceQName(this.endpointClass);
        String serviceName = serviceQName == null ? null : serviceQName.getLocalPart();
        return Axis2WSEndpoint.findWsdlFile(baseDir, serviceName);
    }

    private static File[] getWsdlFiles(File baseDir) {
        File[] files = baseDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".wsdl");
            }
        });
        return files;
    }

    public static File findWsdlFile(File baseDir, String serviceName) {
        File[] files = Axis2WSEndpoint.getWsdlFiles(baseDir);
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        if (serviceName != null) {
            String wsdlFileName = serviceName + ".wsdl";
            for (File file : files) {
                if (!wsdlFileName.equalsIgnoreCase(file.getName())) continue;
                return file;
            }
            return null;
        }
        return null;
    }

    private boolean forkWsgen(StringBuilder classPath, String[] arguments) throws Exception {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("-classpath");
        cmd.add(classPath.toString());
        cmd.add("com.sun.tools.ws.WsGen");
        cmd.addAll(Arrays.asList(arguments));
        try {
            return Axis2WSEndpoint.execJava(cmd, 60000L);
        }
        catch (Exception e) {
            throw new DeploymentException("WSDL generation failed", (Throwable)e);
        }
    }

    public static boolean execJava(List<String> arguments, long timeout) throws Exception {
        ArrayList<String> cmd = new ArrayList<String>();
        String javaHome = System.getProperty("java.home");
        String java = javaHome + File.separator + "bin" + File.separator + "java";
        cmd.add(java);
        cmd.addAll(arguments);
        return Axis2WSEndpoint.exec(cmd, timeout);
    }

    private static boolean waitFor(Process process, long timeout) throws Exception {
        CaptureOutputThread outputThread = new CaptureOutputThread(process.getInputStream());
        outputThread.start();
        for (long sleepTime = 0L; sleepTime < timeout; sleepTime += 2000L) {
            try {
                int errorCode = process.exitValue();
                if (errorCode == 0) {
                    logger.debug((Object)"Process output: {}", new Object[]{outputThread.getOutput()});
                    return true;
                }
                logger.error((Object)"Process failed: {}", new Object[]{outputThread.getOutput()});
                return false;
            }
            catch (IllegalThreadStateException e) {
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException ee) {
                    process.destroy();
                    throw new Exception("Process was interrupted");
                }
            }
        }
        process.destroy();
        logger.error((Object)"Process timed out: {}", new Object[]{outputThread.getOutput()});
        throw new Exception("Process timed out");
    }

    public static boolean exec(List<String> cmd, long timeout) throws Exception {
        logger.debug((Object)"Executing process: {}", new Object[]{cmd});
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        return Axis2WSEndpoint.waitFor(process, timeout);
    }

    private String[] buildArguments(String sei, String classPath, File moduleBaseDir) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-cp");
        arguments.add(classPath);
        arguments.add("-keep");
        arguments.add("-wsdl");
        arguments.add("-d");
        arguments.add(moduleBaseDir.getAbsolutePath() + "/WEB-INF");
        arguments.add(sei);
        return arguments.toArray(new String[0]);
    }

    private boolean waitFor(Process process) throws DeploymentException {
        CaptureOutputThread outputThread = new CaptureOutputThread(process.getInputStream());
        outputThread.start();
        for (long sleepTime = 0L; sleepTime < (long)this.forkTimeout; sleepTime += 2000L) {
            try {
                int errorCode = process.exitValue();
                if (errorCode == 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("wsgen output: " + outputThread.getOutput()), new Object[0]);
                    }
                    return true;
                }
                logger.error((Object)"WSDL generation process failed", new Object[0]);
                logger.error((Object)outputThread.getOutput(), new Object[0]);
                return false;
            }
            catch (IllegalThreadStateException e) {
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException ee) {
                    process.destroy();
                    throw new DeploymentException("WSDL generation process was interrupted");
                }
            }
        }
        process.destroy();
        logger.error((Object)"WSDL generation process timed out", new Object[0]);
        logger.error((Object)outputThread.getOutput(), new Object[0]);
        throw new DeploymentException("WSDL generation process timed out");
    }

    protected AxisServiceGenerator createServiceGenerator() {
        AxisServiceGenerator serviceGenerator = null;
        if (this.type == IWebServiceEndpoint.EndpointType.POJO) {
            serviceGenerator = new AxisServiceGenerator();
        } else if (this.type == IWebServiceEndpoint.EndpointType.EJB) {
            serviceGenerator = new AxisServiceGenerator();
            Axis2EjbMessageReceiver messageReceiver = new Axis2EjbMessageReceiver(this, this.endpointClass, this.factory);
            serviceGenerator.setMessageReceiver(messageReceiver);
        }
        return serviceGenerator;
    }

    public IWebServiceEndpoint.EndpointType getType() {
        return this.type;
    }

    public PortIdentifier getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(IWSRequest request, IWSResponse response) throws WSException {
        block14: {
            HttpServletRequest httpRequest = (HttpServletRequest)request.getAttribute(HttpServletRequest.class);
            MessageContext msgContext = new MessageContext();
            msgContext.setIncomingTransportName("http");
            msgContext.setProperty("REMOTE_ADDR", (Object)request.getRemoteAddr());
            msgContext.setProperty(END_POINT_TYPE, (Object)this.getType());
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.injectHandlers();
                TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut("http");
                TransportInDescription transportIn = this.configurationContext.getAxisConfiguration().getTransportIn("http");
                msgContext.setConfigurationContext(this.configurationContext);
                msgContext.setTransportIn(transportIn);
                msgContext.setTransportOut(transportOut);
                msgContext.setServiceGroupContextId(UUIDGenerator.getUUID());
                msgContext.setServerSide(true);
                msgContext.setAxisService(this.service);
                if ("GET".equals(httpRequest.getMethod())) {
                    this.processGETRequest(request, response, msgContext);
                    break block14;
                }
                if ("POST".equals(httpRequest.getMethod())) {
                    this.doService(request, response, msgContext);
                    break block14;
                }
                throw new UnsupportedOperationException("[" + httpRequest.getMethod() + " ] method not supported");
            }
            catch (Throwable e) {
                String msg = "Exception occurred while trying to invoke service method doService()";
                logger.error((Object)msg, new Object[]{e});
                try {
                    msgContext.setProperty("TRANSPORT_OUT", (Object)response.getOutputStream());
                    msgContext.setProperty("OutTransportInfo", (Object)new Axis2TransportInfo(response));
                    MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)msgContext, (Throwable)e);
                    if (AddressingHelper.isFaultRedirected((MessageContext)msgContext)) {
                        response.setStatus(202);
                    } else {
                        response.setStatus(500);
                    }
                    AxisEngine.sendFault((MessageContext)faultContext);
                }
                catch (Exception ex) {
                    if (AddressingHelper.isFaultRedirected((MessageContext)msgContext)) {
                        response.setStatus(202);
                        break block14;
                    }
                    response.setStatus(500);
                    response.setHeader("Content-Type", "text/plain");
                    PrintWriter pw = null;
                    try {
                        pw = new PrintWriter(response.getOutputStream());
                    }
                    catch (IOException e1) {
                        throw new WSException("Exception occured while getting output print writer", e);
                    }
                    ex.printStackTrace(pw);
                    pw.flush();
                    logger.error((Object)msg, new Object[]{ex});
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
        }
    }

    protected void doService(IWSRequest request, IWSResponse response, MessageContext msgContext) throws Exception {
        this.processPOSTRequest(request, response, this.service, msgContext);
        OperationContext operationContext = msgContext.getOperationContext();
        Object contextWritten = null;
        Object isTwoChannel = null;
        if (operationContext != null) {
            contextWritten = operationContext.getProperty("RESPONSE_WRITTEN");
            isTwoChannel = operationContext.getProperty("DIFFERENT_EPR");
        }
        if (contextWritten != null && "true".equals(contextWritten)) {
            if (isTwoChannel != null && "true".equals(isTwoChannel)) {
                response.setStatus(202);
                return;
            }
            response.setStatus(200);
        } else {
            response.setStatus(202);
        }
    }

    protected void setMsgContextProperties(IWSRequest request, IWSResponse response, AxisService service, MessageContext msgContext) throws IOException {
        msgContext.setProperty("TRANSPORT_OUT", (Object)response.getOutputStream());
        msgContext.setProperty("OutTransportInfo", (Object)new Axis2TransportInfo(response));
        msgContext.setProperty("RequestResponseTransportControl", (Object)new Axis2RequestResponseTransport(response));
        msgContext.setIncomingTransportName("http");
        HttpServletRequest servletRequest = (HttpServletRequest)request.getAttribute(HttpServletRequest.class);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, (Object)servletRequest);
        msgContext.setProperty("TransportInURL", (Object)servletRequest.getRequestURI().toString());
        HttpServletResponse servletResponse = (HttpServletResponse)request.getAttribute(HttpServletResponse.class);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, (Object)servletResponse);
        ServletContext servletContext = (ServletContext)request.getAttribute(ServletContext.class);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT, (Object)servletContext);
        if (servletRequest != null) {
            msgContext.setProperty("TRANSPORT_HEADERS", (Object)new TransportHeaders(servletRequest));
        }
        if (this.binding != null) {
            msgContext.setProperty(JAXWSMessageReceiver.PARAM_BINDING, (Object)this.binding);
        }
        msgContext.setTo(new EndpointReference(servletRequest.getRequestURL().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processURLRequest(IWSRequest request, IWSResponse response, AxisService service, MessageContext msgContext) throws Exception {
        String contentType = request.getHeader("Content-Type");
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        configurationContext.fillServiceContextAndServiceGroupContext(msgContext);
        this.setMsgContextProperties(request, response, service, msgContext);
        ServiceContext serviceContext = msgContext.getServiceContext();
        ObjectRecipe objectRecipe = new ObjectRecipe(this.endpointClass.getName());
        Object obj = objectRecipe.create(this.endpointClass.getClassLoader());
        WebServiceContextImpl wci = new WebServiceContextImpl();
        serviceContext.setProperty("serviceObject", obj);
        Handler.InvocationResponse processed = null;
        processed = RESTUtil.processURLRequest((MessageContext)msgContext, (OutputStream)response.getOutputStream(), (String)contentType);
        if (!processed.equals((Object)Handler.InvocationResponse.CONTINUE)) {
            String s = HTTPTransportReceiver.getServicesHTML((ConfigurationContext)configurationContext);
            PrintWriter pw = new PrintWriter(response.getOutputStream());
            pw.write(s);
            pw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPOSTRequest(IWSRequest request, IWSResponse response, AxisService service, MessageContext msgContext) throws Exception {
        HttpServletRequest httpRequest = (HttpServletRequest)request.getAttribute(HttpServletRequest.class);
        HttpServletResponse httpResponse = (HttpServletResponse)request.getAttribute(HttpServletResponse.class);
        String contentType = request.getHeader("Content-Type");
        String soapAction = request.getHeader("SOAPAction");
        if (soapAction == null) {
            soapAction = "\"\"";
        }
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        configurationContext.fillServiceContextAndServiceGroupContext(msgContext);
        this.setMsgContextProperties(request, response, service, msgContext);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            if (!HTTPTransportUtils.isRESTRequest((String)contentType)) {
                Thread.currentThread().setContextClassLoader(this.endpointClass.getClassLoader());
                HTTPTransportUtils.processHTTPPostRequest((MessageContext)msgContext, (InputStream)httpRequest.getInputStream(), (OutputStream)httpResponse.getOutputStream(), (String)contentType, (String)soapAction, (String)new URI(httpRequest.getRequestURI()).getPath());
            } else {
                RESTUtil.processXMLRequest((MessageContext)msgContext, (InputStream)request.getInputStream(), (OutputStream)response.getOutputStream(), (String)contentType);
            }
        }
        finally {
            Thread.currentThread();
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void start() {
    }

    public void stop() {
        List handlers = this.binding.getHandlerChain();
        for (Handler handler : handlers) {
            this.invokePreDestroy(handler);
        }
    }

    public PortMetaData getPortMetaData() {
        return this.portMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureHandlers() throws UnsupportedEncodingException, WSException {
        EndpointDescription desc = AxisServiceGenerator.getEndpointDescription(this.service);
        if (desc == null) {
            throw new WSException("There is no endpoint description for this service: " + this.service.getName());
        }
        String xml = this.portMetaData.getHandlerXML();
        HandlerChainsType handlerChains = null;
        if (xml != null) {
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            handlerChains = DescriptionUtils.loadHandlerChains(in, null);
            desc.setHandlerChain(handlerChains);
        }
        this.binding = BindingUtils.createBinding((EndpointDescription)desc);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.endpointClass.getClassLoader());
        try {
            DescriptionUtils.registerHandlerHeaders(desc.getAxisService(), this.binding.getHandlerChain());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    protected void injectHandlers() throws WSException {
        List handlers = this.binding.getHandlerChain();
        try {
            for (Handler handler : handlers) {
                this.injectEJBResources(handler);
                this.invokePostConstruct(handler);
            }
        }
        catch (Exception e) {
            throw new WSException("Injection of @EJB resource for " + this.service.getName() + " failed!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void injectEJBResources(Object instance) throws WSException {
        Field[] fieldArray;
        for (Field field : fieldArray = instance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(EJB.class)) continue;
            EJB ejbResource = field.getAnnotation(EJB.class);
            String dependentEJBName = ejbResource.name();
            try {
                InitialContext ictx = new InitialContext();
                EZBRemoteJNDIResolver jndiResolver = (EZBRemoteJNDIResolver)ictx.lookup("EZB_Remote_JNDIResolver");
                String ejbResourceName = ((EZBJNDIBeanData)jndiResolver.getEJBJNDINames(dependentEJBName).toArray()[0]).getName();
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.endpointClass.getClassLoader());
                    Object ejbObject = ictx.lookup(ejbResourceName);
                    boolean accessibility = field.isAccessible();
                    try {
                        field.setAccessible(true);
                        field.set(instance, ejbObject);
                    }
                    catch (Exception e) {
                        throw new WSException("Exception occurs while injecting field for " + this.service.getName() + "!", (Throwable)e);
                    }
                    finally {
                        field.setAccessible(accessibility);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            catch (Exception e) {
                throw new WSException("Unable to inject the field for " + this.service.getName() + "!", (Throwable)e);
            }
        }
    }

    protected void processGETRequest(IWSRequest request, IWSResponse response, MessageContext msgContext) throws Exception {
        HttpServletRequest httpRequest = (HttpServletRequest)request.getAttribute(HttpServletRequest.class);
        HttpServletResponse httpResponse = (HttpServletResponse)request.getAttribute(HttpServletResponse.class);
        response.setStatus(200);
        response.setContentType("text/xml");
        InputStream inStream = null;
        String epr = httpRequest.getRequestURL().toString();
        if (this.wsdlFile != null) {
            inStream = this.endpointClass.getClassLoader().getResourceAsStream(this.wsdlFile.toString());
            OutputStream outStream = response.getOutputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = null;
            doc = db.parse(inStream);
            doc.normalize();
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            this.replaceURL(nodeList, epr);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            Properties properties = transformer.getOutputProperties();
            properties.setProperty("encoding", "UTF-8");
            properties.setProperty("method", "xml");
            transformer.setOutputProperties(properties);
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(outStream);
            transformer.transform(source, result);
        }
    }

    public void replaceURL(NodeList nodeList, String url) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"service".equals(node.getNodeName()) && !"wsdl:service".equals(node.getNodeName())) continue;
            NodeList nl1 = node.getChildNodes();
            for (int j = 0; j < nl1.getLength(); ++j) {
                Node nd1 = nl1.item(j);
                if (nd1.getNodeType() != 1 || !"port".equals(nd1.getNodeName()) && !"wsdl:port".equals(nd1.getNodeName())) continue;
                logger.debug((Object)nd1.getNodeName(), new Object[0]);
                NodeList nl2 = nd1.getChildNodes();
                for (int k = 0; k < nl2.getLength(); ++k) {
                    Node nd2 = nl2.item(k);
                    if (nd2.getNodeType() != 1 || !"soap:address".equals(nd2.getNodeName()) && !"soap12:address".equals(nd2.getNodeName()) && !"http:address".equals(nd2.getNodeName())) continue;
                    logger.debug((Object)nd2.getNodeName(), new Object[0]);
                    nd2.getAttributes().getNamedItem("location").setNodeValue(url);
                    logger.debug((Object)nd2.getAttributes().getNamedItem("location"), new Object[0]);
                }
            }
        }
    }

    public void displayInfos() {
        String endpointURL = "not yet available";
        if (this.portMetaData != null && this.portMetaData.getEndpointURL() != null) {
            endpointURL = this.portMetaData.getEndpointURL();
        }
        logger.info((Object)"{0} endpoint URL at ''{1}''", new Object[]{this.type, endpointURL});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokePostConstruct(Object instance) {
        for (Method method : this.getMethods(instance.getClass(), PostConstruct.class)) {
            PostConstruct pc = method.getAnnotation(PostConstruct.class);
            if (pc == null) continue;
            boolean accessible = method.isAccessible();
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                logger.warn((Object)("@PostConstruct method is not visible: " + method), new Object[0]);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)"@PostConstruct method threw exception", new Object[]{e});
            }
            finally {
                method.setAccessible(accessible);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokePreDestroy(Object instance) {
        for (Method method : this.getMethods(instance.getClass(), PreDestroy.class)) {
            PreDestroy pc = method.getAnnotation(PreDestroy.class);
            if (pc == null) continue;
            boolean accessible = method.isAccessible();
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                logger.warn((Object)("@PreDestroy method is not visible: " + method), new Object[0]);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)"@PreDestroy method threw exception", new Object[]{e});
            }
            finally {
                method.setAccessible(accessible);
            }
        }
    }

    private Collection<Method> getMethods(Class target, Class<? extends Annotation> annotationType) {
        HashSet<Method> methods = new HashSet<Method>();
        this.addMethods(target.getMethods(), annotationType, methods);
        this.addMethods(target.getDeclaredMethods(), annotationType, methods);
        return methods;
    }

    private void addMethods(Method[] methods, Class<? extends Annotation> annotationType, Collection<Method> methodsCol) {
        for (Method method : methods) {
            if (!method.isAnnotationPresent(annotationType)) continue;
            methodsCol.add(method);
        }
    }

    private static class CaptureOutputThread
    extends Thread {
        private InputStream in;
        private ByteArrayOutputStream out;

        public CaptureOutputThread(InputStream in) {
            this.in = in;
            this.out = new ByteArrayOutputStream();
        }

        public String getOutput() {
            try {
                this.join(10000L);
                if (this.isAlive()) {
                    this.interrupt();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            byte[] arr = this.out.toByteArray();
            String output = new String(arr, 0, arr.length);
            return output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                CaptureOutputThread.copyAll(this.in, this.out);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException ee) {}
                try {
                    this.in.close();
                }
                catch (IOException ee) {}
            }
        }

        private static void copyAll(InputStream in, OutputStream out) throws IOException {
            int count;
            byte[] buffer = new byte[4096];
            while ((count = in.read(buffer)) > 0) {
                out.write(buffer, 0, count);
            }
            out.flush();
        }
    }
}

