/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import java.io.Serializable;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.JoramAdapter;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;

public class ActivationSpecImpl
implements ActivationSpec,
ResourceAdapterAssociation,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String AUTO_ACKNOWLEDGE = "Auto-acknowledge";
    public static final String DUPS_OK_ACKNOWLEDGE = "Dups-ok-acknowledge";
    private String destinationType;
    private String destination;
    private String userName = "anonymous";
    private String password = "anonymous";
    String identityClass = SimpleIdentity.class.getName();
    private String messageSelector = null;
    private String subscriptionDurability = null;
    private String subscriptionName;
    private String acknowledgeMode = "Auto-acknowledge";
    private String maxNumberOfWorks = "0";
    private String maxMessages = "10";
    private transient ResourceAdapter ra = null;

    public void validate() throws InvalidPropertyException {
        if (this.destinationType != null && !this.destinationType.equals("javax.jms.Queue") && !this.destinationType.equals("javax.jms.Topic")) {
            throw new InvalidPropertyException("Invalid destination type: " + this.destinationType);
        }
        if (this.destination == null) {
            throw new InvalidPropertyException("Missing destination property.");
        }
        if (this.acknowledgeMode != null && !this.acknowledgeMode.equals(AUTO_ACKNOWLEDGE) && !this.acknowledgeMode.equals(DUPS_OK_ACKNOWLEDGE)) {
            throw new InvalidPropertyException("Invalid acknowledge mode: " + this.acknowledgeMode);
        }
        if (this.subscriptionDurability != null) {
            if (this.subscriptionDurability.equals("Durable") && this.destinationType.equals("javax.jms.Queue")) {
                throw new InvalidPropertyException("Can't set a durable subscription on a JMS queue.");
            }
            if (this.subscriptionDurability.equals("Durable") && this.subscriptionName == null) {
                throw new InvalidPropertyException("Missing durable subscription name.");
            }
        }
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " setResourceAdapter(" + ra + ")"));
        }
        if (this.ra != null) {
            throw new IllegalStateException("Can not change resource adapter association.");
        }
        if (!(ra instanceof JoramAdapter)) {
            throw new ResourceException("Provided resource adapter is not a JORAM resource adapter: " + ra.getClass().getName());
        }
        this.ra = ra;
    }

    public ResourceAdapter getResourceAdapter() {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " getResourceAdapter = " + this.ra));
        }
        return this.ra;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setIdentityClass(String identityClass) {
        this.identityClass = identityClass;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public void setSubscriptionDurability(String subscriptionDurability) {
        this.subscriptionDurability = subscriptionDurability;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setMaxNumberOfWorks(String maxNumberOfWorks) {
        this.maxNumberOfWorks = maxNumberOfWorks;
    }

    public void setMaxMessages(String maxMessages) {
        this.maxMessages = maxMessages;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getIdentityClass() {
        return this.identityClass;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public String getSubscriptionDurability() {
        return this.subscriptionDurability;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public String getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public String getMaxNumberOfWorks() {
        return this.maxNumberOfWorks;
    }

    public String getMaxMessages() {
        return this.maxMessages;
    }
}

