/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.wsdl;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.AbstractJOnASBaseAntTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JReplace;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JTask;
import org.ow2.jonas.antmodular.jonasbase.wsdl.File;
import org.ow2.jonas.antmodular.jonasbase.wsdl.Uddi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlPublish
extends AbstractJOnASBaseAntTask {
    private static final String INFO = "[WSDL-Publish] ";
    private static final String WSDL_PUBLISHER_PROPERTY = "jonas.service.wsdl-publisher.publishers";
    private static final String TOKEN_WSDLPUBLISHER = "jonas.service.wsdl-publisher.publishers    file1";
    private List<File> files = new ArrayList<File>();
    private List<Uddi> uddis = new ArrayList<Uddi>();

    public void addConfiguredFile(File file) {
        this.files.add(file);
    }

    public void addConfiguredUddi(Uddi uddi) {
        this.uddis.add(uddi);
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public void setUddis(List<Uddi> uddis) {
        this.uddis = uddis;
    }

    @Override
    public void execute() {
        super.execute();
        String fileNameList = "";
        JTask jtask = new JTask();
        jtask.setDestDir(this.destDir);
        java.io.File jonasBaseConfDir = new java.io.File(this.destDir.getPath() + java.io.File.separator + "conf");
        for (File f : this.files) {
            String dir = f.getDir();
            String encoding = f.getEncoding();
            String name = f.getName();
            fileNameList = fileNameList.length() == 0 ? name : fileNameList + "," + name;
            String fileName = name + ".properties";
            Properties props = new Properties();
            props.put("jonas.service.wsdl.class", "org.ow2.jonas.ws.publish.internal.file.FileWSDLPublisher");
            props.put("jonas.service.publish.file.directory", dir);
            props.put("jonas.service.publish.file.encoding", encoding);
            java.io.File writeFile = new java.io.File(jonasBaseConfDir, fileName);
            this.log("[WSDL-Publish] Generating a WSDL publish file with name '" + name + "', dir '" + dir + "' and encoding '" + encoding + "' in file '" + writeFile + "'...");
            jtask.writePropsToFile(INFO, props, writeFile);
        }
        for (Uddi uddi : this.uddis) {
            String name = uddi.getName();
            String username = uddi.getUserName();
            String password = uddi.getPassword();
            String orgName = uddi.getOrgName();
            String orgDesc = uddi.getOrgDesc();
            String orgPersonName = uddi.getOrgPersonName();
            String lifecyclemanagerURL = uddi.getLifecyclemanagerURL();
            String queryManagerURL = uddi.getQueryManagerURL();
            fileNameList = fileNameList.length() == 0 ? name : fileNameList + "," + name;
            String fileName = name + ".properties";
            Properties props = new Properties();
            props.put("jonas.service.wsdl.class", "org.ow2.jonas.ws.publish.internal.registry.RegistryWSDLPublisher");
            props.put("jonas.service.publish.uddi.username", username);
            props.put("jonas.service.publish.uddi.password", password);
            props.put("jonas.service.publish.uddi.organization.name", orgName);
            props.put("jonas.service.publish.uddi.organization.desc", orgDesc);
            props.put("jonas.service.publish.uddi.organization.person_name", orgPersonName);
            props.put("javax.xml.registry.lifeCycleManagerURL", lifecyclemanagerURL);
            props.put("javax.xml.registry.queryManagerURL", queryManagerURL);
            java.io.File writeFile = new java.io.File(jonasBaseConfDir, fileName);
            this.log("[WSDL-Publish] Generating a WSDL publish UDDI with name '" + name + "' in file '" + writeFile + "'...");
            jtask.writePropsToFile(INFO, props, writeFile);
        }
        JReplace propertyReplace = new JReplace();
        propertyReplace.setProject(this.getProject());
        propertyReplace.setConfigurationFile("jonas.properties");
        propertyReplace.setDestDir(new java.io.File(this.destDir.getPath()));
        propertyReplace.setToken(TOKEN_WSDLPUBLISHER);
        propertyReplace.setValue("jonas.service.wsdl-publisher.publishers    " + fileNameList);
        this.log("[WSDL-Publish] Adding WSDL Publishers '" + fileNameList + "' in " + "jonas.properties" + " file.");
        propertyReplace.execute();
        this.addTask(jtask);
        super.executeAllTask();
    }
}

