/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.datasource.reader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public class DatasourceValidator {
    private static final String DATASOURCE_10_XSD = "/org/ow2/jonas/datasource/binding/schema/jonas-datasources-1.0.xsd";
    private static final String DATASOURCE_XSD = "/org/ow2/jonas/datasource/binding/schema/jonas-datasources-1.1.xsd";

    private DatasourceValidator() {
    }

    public DatasourceValidator(File xmlFile) throws SAXException, ParserConfigurationException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new Source[]{this.getStreamSource(DATASOURCE_10_XSD), this.getStreamSource(DATASOURCE_XSD)});
        Validator validator = schema.newValidator();
        StreamSource xmlSource = new StreamSource(xmlFile);
        validator.validate(xmlSource);
    }

    private Source getStreamSource(String resource) {
        InputStream is = this.getClass().getResourceAsStream(resource);
        if (is == null) {
            throw new IllegalStateException("Unable to find the XSD '" + resource + "'");
        }
        StreamSource source = new StreamSource(is);
        if (source == null) {
            throw new IllegalStateException("Unable to find the XSD '" + resource + "'");
        }
        return source;
    }
}

