/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component.visit;

import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;

public class VisitUtils {
    private static String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";
    private static String EXECUTE_STATE_SAVING_HINT = "javax.faces.visit.EXECUTE_STATE_SAVING";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doFullNonIteratingVisit(FacesContext context, VisitCallback callback) {
        assert (context != null);
        assert (callback != null);
        UIViewRoot root = context.getViewRoot();
        VisitContext vContext = VisitContext.createVisitContext((FacesContext)context);
        VisitUtils.startSkipIteration(context);
        try {
            boolean bl = root.visitTree(vContext, callback);
            return bl;
        }
        finally {
            VisitUtils.endSkipIteration(context);
        }
    }

    public static boolean isSkippingIteration(FacesContext context) {
        Object hint = context.getAttributes().get(SKIP_ITERATION_HINT);
        return Boolean.TRUE.equals(hint);
    }

    public static void startStateSaveRestore(FacesContext context) {
        context.getAttributes().put(EXECUTE_STATE_SAVING_HINT, true);
    }

    public static void endStateSaveRestore(FacesContext context) {
        context.getAttributes().remove(EXECUTE_STATE_SAVING_HINT);
    }

    private static void startSkipIteration(FacesContext context) {
        assert (!VisitUtils.isSkippingIteration(context));
        context.getAttributes().put(SKIP_ITERATION_HINT, true);
    }

    private static void endSkipIteration(FacesContext context) {
        assert (VisitUtils.isSkippingIteration(context));
        context.getAttributes().remove(SKIP_ITERATION_HINT);
    }
}

