/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.config.LoggingInitializer;
import org.jacorb.orb.ORB;
import org.jacorb.slf4j.Logger;
import org.jacorb.slf4j.LoggerFactory;
import org.jacorb.util.ObjectUtil;

public class JacORBConfiguration
implements Configuration {
    private static final String CONFIG_LOG_VERBOSITY = "jacorb.config.log.verbosity";
    private static final String fileSuffix = ".properties";
    private static final String COMMON_PROPS = "orb.properties";
    private static final String TRUE = "true";
    private static final String ON = "on";
    private static final String EMPTY_STR = "";
    private static final String ATTR_LOG_VERBOSITY = "jacorb.log.default.verbosity";
    private static final String ATTR_LOG_FILE = "jacorb.logfile";
    private static final String ATTR_LOG_APPEND = "jacorb.logfile.append";
    private static final String ATTR_LOGGING_INITIALIZER = "jacorb.log.initializer";
    private static final int DEFAULT_LOG_LEVEL = 0;
    private Properties attributes;
    private String name;
    private final ORB orb;
    private Logger logger;

    public static Configuration getConfiguration(Properties properties, ORB oRB, boolean bl) throws ConfigurationException {
        String string;
        String string2 = "jacorb";
        String string3 = null;
        if (!bl) {
            try {
                string3 = System.getProperty("ORBid");
            }
            catch (SecurityException securityException) {
                bl = true;
                JacORBConfiguration.println("Could not access system property 'ORBid' - will use default...");
            }
        }
        if (properties != null && (string = (String)properties.get("ORBid")) != null) {
            string3 = string;
        }
        if (string3 != null) {
            if (string3.equals("orb") || string3.equals("jacorb")) {
                throw new ConfigurationException("Illegal orbID, <" + string3 + "> is reserved");
            }
            string2 = string3;
        }
        return new JacORBConfiguration(string2, properties, oRB, bl);
    }

    private JacORBConfiguration(String string, Properties properties, ORB oRB, boolean bl) throws ConfigurationException {
        this.name = string;
        this.orb = oRB;
        this.attributes = new Properties();
        this.logger = this.getLogger("jacorb.config");
        if (bl) {
            this.initApplet(string, properties);
        } else {
            this.init(string, properties);
        }
        if (oRB != null) {
            this.initLogging();
        }
    }

    private static void println(String string) {
        System.out.println(string);
    }

    private static void printErr(String string) {
        System.err.println(string);
    }

    private void init(String string, Properties properties) throws ConfigurationException {
        List list;
        String string2;
        if (string == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        String string3 = System.getProperty("file.separator");
        String string4 = System.getProperty("user.home");
        String string5 = System.getProperty("java.home");
        boolean bl = false;
        this.setAttributes(System.getProperties());
        String string6 = string5 + string3 + "lib" + string3 + COMMON_PROPS;
        Properties properties2 = JacORBConfiguration.loadPropertiesFromFile(string6);
        if (properties2 != null) {
            this.setAttributes(properties2);
            bl = true;
            this.logger.debug("base configuration loaded from file " + string6);
        }
        if ((properties2 = JacORBConfiguration.loadPropertiesFromFile(string6 = string4 + string3 + COMMON_PROPS)) != null) {
            this.setAttributes(properties2);
            bl = true;
            this.logger.debug("base configuration loaded from file " + string6);
        }
        if ((properties2 = this.loadPropertiesFromClassPath(COMMON_PROPS)) != null) {
            bl = true;
            this.setAttributes(properties2);
            this.logger.debug("base configuration loaded from classpath orb.properties");
        }
        if ((string2 = this.getAttribute("jacorb.config.dir", EMPTY_STR)).length() == 0) {
            string2 = this.getAttribute("jacorb.home", EMPTY_STR);
        }
        if (string2.length() != 0) {
            string2 = string2 + string3 + "etc";
        } else {
            this.logger.debug("jacorb.home unset! Will use '.'");
            string2 = ".";
        }
        string6 = string2 + string3 + string + fileSuffix;
        Properties properties3 = JacORBConfiguration.loadPropertiesFromFile(string6);
        if (properties3 != null) {
            this.setAttributes(properties3);
            bl = true;
            this.logger.info("configuration " + string + " loaded from file " + string6);
        } else {
            this.logger.debug("File " + string6 + " for configuration " + string + " not found");
        }
        properties3 = this.loadPropertiesFromClassPath(string + fileSuffix);
        if (properties3 != null) {
            this.setAttributes(properties3);
            bl = true;
            this.logger.debug("configuration " + string + " loaded from classpath");
        }
        if (!(list = this.getAttributeList("custom.props")).isEmpty()) {
            for (String string7 : list) {
                Properties properties4 = JacORBConfiguration.loadPropertiesFromFile(string7);
                if (properties4 != null) {
                    this.setAttributes(properties4);
                    bl = true;
                    this.logger.info("custom properties loaded from file " + string7);
                    continue;
                }
                this.logger.warn("custom properties not found in " + string7);
            }
        }
        this.setAttributes(System.getProperties());
        if (properties != null) {
            bl = true;
            this.setAttributes(properties);
        }
        if (!bl) {
            this.logger.warn("no properties found for configuration " + string);
        }
    }

    private void initApplet(String string, Properties properties) throws ConfigurationException {
        String string2;
        Properties properties2;
        Properties properties3;
        if (string == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        boolean bl = false;
        if (properties != null) {
            this.setAttributes(properties);
        }
        if ((properties3 = this.loadPropertiesFromClassPath(COMMON_PROPS)) != null) {
            this.setAttributes(properties3);
            bl = true;
            this.logger.info("base configuration loaded from classpath orb.properties");
        }
        if ((properties2 = this.loadPropertiesFromClassPath(string2 = string + fileSuffix)) != null) {
            this.setAttributes(properties2);
            bl = true;
            this.logger.info("configuration " + string + " loaded from classpath " + string2);
        } else {
            this.logger.warn("File " + string2 + " for configuration " + string + " not found in classpath");
        }
        List list = this.getAttributeList("custom.props");
        if (!list.isEmpty()) {
            for (String string3 : list) {
                Properties properties4 = this.loadPropertiesFromClassPath(string3);
                if (properties4 != null) {
                    this.setAttributes(properties4);
                    bl = true;
                    this.logger.info("custom properties loaded from classpath " + string3);
                    continue;
                }
                this.logger.warn("custom properties " + string3 + " not found in classpath");
            }
        }
        if (properties != null) {
            bl = true;
            this.setAttributes(properties);
        }
        if (!bl) {
            this.logger.warn("no properties found for configuration " + string);
        }
    }

    public void setAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    void setAttributes(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            Object obj = enumeration.nextElement();
            if (!(obj instanceof String) || !((string2 = properties.getProperty(string = (String)obj)) instanceof String) && string2 != null) continue;
            this.setAttribute(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromFile(String string) {
        Properties properties;
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            Properties properties2 = new Properties();
            properties2.load(fileInputStream);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            catch (IOException iOException) {
                JacORBConfiguration.println("could not read config file: " + string);
                iOException.printStackTrace();
                return null;
            }
        }
        ((InputStream)fileInputStream).close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFromClassPath(String string) {
        Properties properties;
        block6: {
            properties = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : JacORBConfiguration.class.getClassLoader();
                URL uRL = classLoader.getResource(string);
                if (uRL == null) break block6;
                properties = new Properties();
                InputStream inputStream = uRL.openStream();
                try {
                    properties.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                this.logger.error("could not read config file: " + string, iOException);
            }
        }
        return properties;
    }

    private void initLogging() {
        LoggingInitializer loggingInitializer = (LoggingInitializer)this.getAttributeAsObject(ATTR_LOGGING_INITIALIZER, "org.jacorb.config.JdkLoggingInitializer");
        loggingInitializer.init(this);
    }

    public ORB getORB() {
        return this.orb;
    }

    public Logger getLogger(String string) {
        String string2;
        String string3 = string;
        if (this.getAttributeAsBoolean("jacorb.log.split_on_implname", false) && (string2 = this.getAttribute("jacorb.implname", null)) != null && string2.length() > 0) {
            if (string.equals("jacorb")) {
                string3 = "jacorb." + string2;
            } else if (string.startsWith("jacorb.")) {
                string3 = "jacorb." + string2 + "." + string.substring(7);
            }
        }
        return LoggerFactory.getLogger(string3);
    }

    public String getLoggerName(Class clazz) {
        String string = clazz.getName();
        String string2 = string.substring(0, string.lastIndexOf(46));
        if (string2 != null && string2.startsWith("org.jacorb")) {
            return string2.substring(4);
        }
        return string2;
    }

    public String getAttribute(String string) {
        String string2 = this.attributes.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        throw new ConfigurationException("attribute " + string + " is not defined");
    }

    public String getAttribute(String string, String string2) {
        return this.attributes.getProperty(string, string2);
    }

    public int getAttributeAsInteger(String string, int n) {
        String string2 = this.attributes.getProperty(string, null);
        if (string2 == null) {
            return n;
        }
        if (string2 instanceof String) {
            if (string2.trim().length() < 1) {
                return n;
            }
            try {
                int n2 = Integer.parseInt(string2.trim());
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ConfigurationException("value for attribute " + string + " is not numeric: " + string2);
    }

    public int getAttributeAsInteger(String string) {
        String string2 = this.attributes.getProperty(string, null);
        if (string2 == null) {
            throw new ConfigurationException("value for attribute " + string + " is not set");
        }
        return this.getAttributeAsInteger(string, 0);
    }

    public long getAttributeAsLong(String string, long l) {
        String string2 = this.attributes.getProperty(string, null);
        if (string2 == null) {
            return l;
        }
        if (string2 instanceof String) {
            try {
                long l2 = Long.parseLong(string2.trim());
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ConfigurationException("value for attribute " + string + " is not numeric: " + string2);
    }

    public List getAttributeList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        try {
            string2 = this.getAttribute(string);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
        }
        return arrayList;
    }

    public Object getAttributeAsObject(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string, null);
        if (string2 != null && string2.length() > 0) {
            return this.newInstance(string, string2);
        }
        return null;
    }

    private Object newInstance(String string, String string2) throws ConfigurationException {
        try {
            Class clazz = ObjectUtil.classForName(string2);
            Object t = clazz.newInstance();
            if (t instanceof Configurable) {
                ((Configurable)t).configure(this);
            }
            return t;
        }
        catch (Exception exception) {
            throw new ConfigurationException("Unable to build class from key >" + string + "<: " + exception);
        }
    }

    public Object getAttributeAsObject(String string, String string2) throws ConfigurationException {
        Object object = this.getAttributeAsObject(string);
        if (object == null) {
            return this.newInstance("default", string2);
        }
        return object;
    }

    public boolean getAttributeAsBoolean(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string);
        if (string2 != null && string2.length() > 0) {
            return ON.equals(string2 = string2.trim().toLowerCase()) || TRUE.equals(string2);
        }
        return false;
    }

    public boolean getAttributeAsBoolean(String string, boolean bl) {
        String string2 = this.getAttribute(string, EMPTY_STR);
        if (string2.length() > 0) {
            return ON.equals(string2 = string2.trim().toLowerCase()) || TRUE.equals(string2);
        }
        return bl;
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[0]);
    }

    public List getAttributeNamesWithPrefix(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            arrayList.add(stringArray[i]);
        }
        return Collections.unmodifiableList(arrayList);
    }
}

