/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import org.jacorb.ir.IdlWriter;
import org.jacorb.orb.ORB;
import org.jacorb.slf4j.Logger;
import org.omg.CORBA.Contained;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;

public class QueryIR {
    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: qir <RepositoryID>");
            System.exit(1);
        }
        try {
            Contained contained;
            ORB oRB = (ORB)org.omg.CORBA.ORB.init(stringArray, null);
            Repository repository = RepositoryHelper.narrow(oRB.resolve_initial_references("InterfaceRepository"));
            Logger logger = oRB.getConfiguration().getLogger("jacorb.ir");
            if (repository == null) {
                System.out.println("Could not find IR.");
                System.exit(1);
            }
            if ((contained = repository.lookup_id(stringArray[0])) != null) {
                IdlWriter idlWriter = new IdlWriter(oRB, System.out, logger);
                idlWriter.printContained(contained, 2);
            } else {
                System.out.println(stringArray[0] + " not found in IR.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

