/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.io.Serializable;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.ejb2.JTimerHandleInfo;
import org.ow2.jonas.ejb2.TimerHandleDelegate;
import org.ow2.jonas.lib.ejb21.JContext;
import org.ow2.jonas.lib.naming.SingletonNamingManager;
import org.ow2.jonas.lib.timer.TraceTimer;
import org.ow2.jonas.naming.JNamingManager;

public class JTimerHandle
implements TimerHandle {
    private JTimerHandleInfo infos = null;
    private transient TimerHandleDelegate delegate = null;

    public JTimerHandle(long starttime, long duration, long period, Serializable info, String beanname, String container, Serializable pk) {
        if (TraceTimer.isDebug()) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("New JTimerHandle start = " + starttime + ", initial = " + duration + ", period = " + period));
        }
        this.infos = new JTimerHandleInfo();
        this.infos.setContainerId(container);
        this.infos.setBeanId(beanname);
        this.infos.setDuration(duration);
        this.infos.setInfo(info);
        this.infos.setPeriod(period);
        this.infos.setPk(pk);
        this.infos.setStartTime(starttime);
    }

    public Timer getTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkAllowedOperations();
        return this.getTimerHandleDelegate().getTimer(this.infos);
    }

    public Timer restartTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.checkAllowedOperations();
        return this.getTimerHandleDelegate().restartTimer(this.infos);
    }

    private TimerHandleDelegate getTimerHandleDelegate() throws IllegalStateException {
        if (this.delegate == null) {
            try {
                InitialContext ictx = new InitialContext();
                this.delegate = (TimerHandleDelegate)ictx.lookup("java:comp/TimerHandleDelegate");
            }
            catch (NamingException e) {
                throw new IllegalStateException("TimerHandleDelegate not retrieved:", e);
            }
        }
        return this.delegate;
    }

    private void checkAllowedOperations() {
        try {
            JNamingManager naming = SingletonNamingManager.getInstance();
            Context ctx = naming.getComponentContext();
            JContext sc = (JContext)ctx.lookup("MY_SF_CONTEXT");
            if (sc.getState() != 2) {
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"This operation is not allowed here");
                throw new IllegalStateException("This operation is not allowed here");
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JTimerHandle)) {
            return false;
        }
        JTimerHandle handle = (JTimerHandle)obj;
        return this.infos.equals((Object)handle.infos);
    }

    public int hashCode() {
        return this.infos.hashCode();
    }
}

