/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.impl.batchlucene.BatchBackend;
import org.hibernate.search.batchindexing.BatchIndexingWorkspace;
import org.hibernate.search.batchindexing.Executors;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchCoordinator
implements Runnable {
    private static final Logger log = LoggerFactory.make();
    private final Class<?>[] rootEntities;
    private final SearchFactoryImplementor searchFactoryImplementor;
    private final SessionFactory sessionFactory;
    private final int objectLoadingThreads;
    private final int collectionLoadingThreads;
    private final CacheMode cacheMode;
    private final int objectLoadingBatchSize;
    private final boolean optimizeAtEnd;
    private final boolean purgeAtStart;
    private final boolean optimizeAfterPurge;
    private final CountDownLatch endAllSignal;
    private final MassIndexerProgressMonitor monitor;
    private final long objectsLimit;
    private BatchBackend backend;

    public BatchCoordinator(Set<Class<?>> rootEntities, SearchFactoryImplementor searchFactoryImplementor, SessionFactory sessionFactory, int objectLoadingThreads, int collectionLoadingThreads, CacheMode cacheMode, int objectLoadingBatchSize, long objectsLimit, boolean optimizeAtEnd, boolean purgeAtStart, boolean optimizeAfterPurge, MassIndexerProgressMonitor monitor) {
        this.rootEntities = rootEntities.toArray(new Class[rootEntities.size()]);
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.sessionFactory = sessionFactory;
        this.objectLoadingThreads = objectLoadingThreads;
        this.collectionLoadingThreads = collectionLoadingThreads;
        this.cacheMode = cacheMode;
        this.objectLoadingBatchSize = objectLoadingBatchSize;
        this.optimizeAtEnd = optimizeAtEnd;
        this.purgeAtStart = purgeAtStart;
        this.optimizeAfterPurge = optimizeAfterPurge;
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
        this.endAllSignal = new CountDownLatch(rootEntities.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.backend = this.searchFactoryImplementor.makeBatchBackend(this.monitor);
        try {
            this.beforeBatch();
            this.doBatchWork();
            this.backend.stopAndFlush(86400L, TimeUnit.SECONDS);
            this.afterBatch();
        }
        catch (InterruptedException e) {
            log.error("Batch indexing was interrupted");
            Thread.currentThread().interrupt();
        }
        finally {
            this.backend.close();
        }
    }

    private void doBatchWork() throws InterruptedException {
        ThreadPoolExecutor executor = Executors.newFixedThreadPool(this.rootEntities.length, "BatchIndexingWorkspace");
        for (Class<?> type : this.rootEntities) {
            executor.execute(new BatchIndexingWorkspace(this.searchFactoryImplementor, this.sessionFactory, type, this.objectLoadingThreads, this.collectionLoadingThreads, this.cacheMode, this.objectLoadingBatchSize, this.endAllSignal, this.monitor, this.backend, this.objectsLimit));
        }
        executor.shutdown();
        this.endAllSignal.await();
    }

    private void afterBatch() {
        if (this.optimizeAtEnd) {
            Set<Class<?>> targetedClasses = this.searchFactoryImplementor.getIndexedTypesPolymorphic(this.rootEntities);
            this.optimize(targetedClasses);
        }
    }

    private void beforeBatch() {
        if (this.purgeAtStart) {
            Set<Class<?>> targetedClasses = this.searchFactoryImplementor.getIndexedTypesPolymorphic(this.rootEntities);
            for (Class<?> clazz : targetedClasses) {
                this.backend.doWorkInSync(new PurgeAllLuceneWork(clazz));
            }
            if (this.optimizeAfterPurge) {
                this.optimize(targetedClasses);
            }
        }
    }

    private void optimize(Set<Class<?>> targetedClasses) {
        for (Class<?> clazz : targetedClasses) {
            this.backend.doWorkInSync(new OptimizeLuceneWork(clazz));
        }
    }
}

