/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat7.ws;

import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.ow2.jonas.web.tomcat7.ws.URLUtils;
import org.ow2.jonas.ws.jaxws.IJAXWSService;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.jonas.ws.jaxws.http.servlet.JAXWSServlet;
import org.ow2.util.ee.metadata.war.api.IWarClassMetadata;

public class EndpointInstanceListener
implements InstanceListener {
    private IWarClassMetadata endpointMetadata;
    private IJAXWSService service;
    private IWebServiceEndpoint endpoint;

    public EndpointInstanceListener(IWarClassMetadata endpointMetadata, IJAXWSService service) {
        this.endpointMetadata = endpointMetadata;
        this.service = service;
    }

    public void instanceEvent(InstanceEvent event) {
        if ("afterInit".equals(event.getType())) {
            JAXWSServlet servlet = (JAXWSServlet)event.getServlet();
            if (this.endpoint == null) {
                ClassLoader loader = event.getWrapper().getLoader().getClassLoader();
                try {
                    ServletContext sc = event.getServlet().getServletConfig().getServletContext();
                    this.endpoint = this.service.createPOJOWebServiceEndpoint(this.endpointMetadata, loader, sc);
                }
                catch (WSException e) {
                    throw new RuntimeException("WebServiceEndpoint creation failed", e);
                }
                PortMetaData pmd = this.endpoint.getPortMetaData();
                String pattern = null;
                String[] mappings = event.getWrapper().findMappings();
                if (mappings.length != 0) {
                    pattern = URLUtils.findValidUrlPattern(mappings);
                }
                if (pattern != null) {
                    pmd.setUrlPattern(pattern);
                }
                Context context = (Context)event.getWrapper().getParent();
                pmd.setContextRoot(context.getName());
                Host host = (Host)context.getParent();
                String url = URLUtils.getEndpointURL(pmd, host);
                pmd.setEndpointURL(url);
                this.endpointMetadata = null;
                this.service = null;
            }
            servlet.setWebServiceEndpoint(this.endpoint);
            this.endpoint.displayInfos();
        }
    }
}

