/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.stream.impl.delegator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.stream.api.IStreamAccessor;
import org.ow2.util.stream.impl.delegator.DelegatorInputStream;
import org.ow2.util.stream.impl.delegator.DelegatorOutputStream;

public class DelegatorStreamAccessor
implements IStreamAccessor {
    private static final int BUFFER_SIZE = 8192;
    private File delegatorFile;
    private Object mutex = new Object();
    private IStreamAccessor parentFileAccessor;

    public DelegatorStreamAccessor(IStreamAccessor parentFileAccessor) throws IOException {
        try {
            this.initDelegatorFileAccessor(parentFileAccessor.getInputStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.parentFileAccessor = parentFileAccessor;
    }

    protected DelegatorStreamAccessor(IStreamAccessor parentFileAccessor, InputStream inputStream) throws IOException {
        this.initDelegatorFileAccessor(inputStream);
        this.parentFileAccessor = parentFileAccessor;
    }

    private void initDelegatorFileAccessor(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            this.delegatorFile = null;
        } else {
            this.delegatorFile = File.createTempFile("DelegatorFileAccessor", ".data");
            byte[] buf = new byte[8192];
            FileOutputStream outputStream = new FileOutputStream(this.delegatorFile);
            int read = inputStream.read(buf);
            while (read != -1) {
                ((OutputStream)outputStream).write(buf, 0, read);
                read = inputStream.read(buf);
            }
            inputStream.close();
            ((OutputStream)outputStream).close();
        }
    }

    protected void writeToParent(IStreamAccessor parentFileAccessor, InputStream inputStream) throws IOException {
        OutputStream parentOutputStream = parentFileAccessor.getOutputStream();
        byte[] buf = new byte[8192];
        int read = inputStream.read(buf);
        while (read != -1) {
            parentOutputStream.write(buf, 0, read);
            read = inputStream.read(buf);
        }
        parentOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doWrite() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.delegatorFile == null) {
                throw new FileNotFoundException("unable to write, the file was delete");
            }
            this.writeToParent(this.parentFileAccessor, new FileInputStream(this.delegatorFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doWrite(File temporaryFile) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            this.writeToParent(this.parentFileAccessor, new FileInputStream(temporaryFile));
            if (this.delegatorFile == null) {
                this.delegatorFile = File.createTempFile("DelegatorFileAccessor", ".data");
                try {
                    FileUtils.copyFile((File)temporaryFile, (File)this.delegatorFile);
                }
                catch (FileUtilsException e) {
                    throw new IOException("unable to copy file");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.delegatorFile == null) {
                throw new FileNotFoundException();
            }
            return new DelegatorInputStream(this, this.delegatorFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.delegatorFile == null) {
                this.delegatorFile = File.createTempFile("DelegatorFileAccessor", ".data");
            }
            return new DelegatorOutputStream(this, this.delegatorFile, false);
        }
    }

    public OutputStream getTemporaryOutputStream() throws IOException {
        return new DelegatorOutputStream(this, File.createTempFile("DelegatorFileAccessor", ".data"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.delegatorFile != null) {
                this.delegatorFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.delegatorFile != null) {
                this.delegatorFile.delete();
                this.delegatorFile = null;
            }
        }
        this.parentFileAccessor.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegatorFile != null;
            {
            }
        }
    }
}

