/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.deployer;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.osgi.framework.BundleContext;
import org.ow2.jonas.Version;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.jonas.addon.deploy.api.deployable.ISortableDeployable;
import org.ow2.jonas.addon.deploy.api.deployer.IAddonDeployer;
import org.ow2.jonas.addon.deploy.api.util.IAddonLogEntry;
import org.ow2.jonas.addon.deploy.impl.deployable.AddonDeployableImpl;
import org.ow2.jonas.addon.deploy.impl.deployer.AddonMetaData;
import org.ow2.jonas.addon.deploy.impl.deployer.ConfDeployerImpl;
import org.ow2.jonas.addon.deploy.impl.util.AddonDeployerLog;
import org.ow2.jonas.addon.deploy.impl.util.AddonUtil;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.lib.work.DeployerLogException;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.OSGiDeployable;
import org.ow2.util.ee.deploy.api.deployable.UnknownDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.api.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.api.helper.IDeployableHelper;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployer;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.file.FileUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.deploy.deployable.api.DeploymentPlanDeployable;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddonDeployerImpl
extends AbsDeployer<IAddonDeployable>
implements IAddonDeployer {
    private static Log logger = LogFactory.getLog(AddonDeployerImpl.class);
    private ServerProperties serverProperties;
    private IDeployableHelper deployableHelper;
    private Map<URL, IAddonDeployable> addons = null;
    private AddonDeployerLog deployerLog;
    private IDeployerManager deployerManager;
    private boolean isCleanup = false;
    private List<String> deployedAddonNames;
    private BundleContext bundleContext;
    private ConfDeployerImpl confDeployer;
    private ConfigurationManager configurationManager;

    public AddonDeployerImpl(ServerProperties serverProperties, IDeployableHelper deployableHelper, AddonDeployerLog deployerLog, IDeployerManager deployerManager, BundleContext bundleContext, ConfigurationManager configurationManager) {
        this.serverProperties = serverProperties;
        this.deployableHelper = deployableHelper;
        this.deployerLog = deployerLog;
        this.deployerManager = deployerManager;
        this.addons = new HashMap<URL, IAddonDeployable>();
        this.isCleanup = Boolean.getBoolean("jonas.cache.clean");
        this.deployedAddonNames = new ArrayList<String>();
        this.bundleContext = bundleContext;
        this.configurationManager = configurationManager;
        this.confDeployer = new ConfDeployerImpl(this.bundleContext);
        this.checkLogs();
    }

    private void checkLogs() {
        HashMap<String, String> addonsToUndeploy = new HashMap<String, String>();
        Vector logEntries = this.deployerLog.getEntries();
        Vector<IAddonLogEntry> logEntriesToRemove = new Vector<IAddonLogEntry>();
        for (IAddonLogEntry logEntry : logEntries) {
            if (!logEntry.getOriginal().exists()) {
                addonsToUndeploy.put(logEntry.getName(), logEntry.getCopy().getAbsolutePath());
                logEntriesToRemove.add(logEntry);
                continue;
            }
            if (logEntry.getCopy().exists()) continue;
        }
        for (IAddonLogEntry logEntry : logEntriesToRemove) {
            try {
                this.deployerLog.removeEntry(logEntry);
                logger.info((Object)"''{0}'' Addon Deployable is now undeployed", new Object[]{logEntry.getOriginal().getAbsolutePath()});
            }
            catch (DeployerLogException e) {
                logger.error((Object)("Cannot remove log entry " + logEntry.getName() + "."), new Object[]{e});
            }
        }
        this.retrieveJOnASConfiguration(addonsToUndeploy, true);
    }

    public void doDeploy(IDeployable<IAddonDeployable> deployable) throws DeployerException {
        URL originalURL;
        File unpackedFile;
        File originalFile = null;
        try {
            originalFile = URLUtils.urlToFile((URL)deployable.getArchive().getURL());
        }
        catch (ArchiveException e) {
            logger.error((Object)("Cannot get the deployable " + deployable.getShortName()), new Object[]{e});
        }
        boolean isAlreadyDeployed = originalFile.exists() && this.deployerLog.getEntry(originalFile) != null;
        IAddonDeployable unpackedDeployable = null;
        if (isAlreadyDeployed) {
            IArchive archive = ArchiveManager.getInstance().getArchive((Object)this.deployerLog.getEntry(originalFile).getCopy());
            try {
                unpackedDeployable = (IAddonDeployable)IAddonDeployable.class.cast(this.deployableHelper.getDeployable(archive));
            }
            catch (DeployableHelperException e) {
                logger.error((Object)("Cannot get the deployable " + originalFile), new Object[]{e});
            }
            logger.debug((Object)"Deploying ''{0}''", new Object[]{unpackedDeployable});
        } else {
            unpackedDeployable = null;
            File folder = new File(AddonUtil.getAddonsWorkDirectory(this.serverProperties));
            try {
                originalFile = URLUtils.urlToFile((URL)deployable.getArchive().getURL());
                String archiveName = FileUtils.lastModifiedFileName((File)originalFile);
                unpackedDeployable = (IAddonDeployable)UnpackDeployableHelper.unpack((IDeployable)((IDeployable)IAddonDeployable.class.cast(deployable)), (File)folder, (String)archiveName, (boolean)false, (IDeployableHelper)this.deployableHelper);
            }
            catch (Exception e) {
                throw new DeployerException("Cannot deploy archive for '" + deployable.getArchive() + "'", (Throwable)e);
            }
            logger.info((Object)"Deploying ''{0}''", new Object[]{unpackedDeployable});
        }
        IArchive addonArchive = unpackedDeployable.getArchive();
        try {
            unpackedFile = URLUtils.urlToFile((URL)addonArchive.getURL());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot get URL from archive '" + addonArchive + "'", (Throwable)e);
        }
        AddonMetaData addonMetaData = AddonUtil.getAddonMetadata(AddonUtil.getAddonMetadataFile(addonArchive), unpackedFile.getAbsolutePath());
        try {
            originalURL = deployable.getArchive().getURL();
        }
        catch (Exception e) {
            throw new DeployerException("Cannot get the url of the initial deployable for the Addon Module '" + deployable + "'.", (Throwable)e);
        }
        this.checkAddonMetadata(addonMetaData);
        List<String> osgiDeployables = this.updateDeployables(unpackedFile.getAbsolutePath(), unpackedDeployable, addonMetaData);
        this.addons.put(originalURL, unpackedDeployable);
        if (this.deployerLog.getEntry(URLUtils.urlToFile((URL)originalURL)) != null) {
            this.deploy(unpackedDeployable, addonMetaData, true);
            logger.debug((Object)"''{0}'' addon is already deployed", new Object[]{deployable.getShortName()});
        } else {
            this.deploy(unpackedDeployable, addonMetaData, false);
            if (this.deployerLog != null) {
                try {
                    this.deployerLog.addEntry(addonMetaData.getName(), originalFile, unpackedFile, osgiDeployables);
                }
                catch (DeployerLogException e) {
                    logger.info((Object)"Cannot added a log entry to the addon logger", new Object[0]);
                }
            }
            this.deployedAddonNames.add(addonMetaData.getName());
            logger.info((Object)"''{0}'' addon is now deployed", new Object[]{deployable.getShortName()});
        }
    }

    public void doUndeploy(IDeployable<IAddonDeployable> deployable) throws DeployerException {
        URL addonURL;
        logger.info((Object)"Undeploying {0}", new Object[]{deployable.getShortName()});
        try {
            addonURL = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL on the Addon deployable '" + deployable + "'.", (Throwable)e);
        }
        IAddonDeployable unpackedDeployable = null;
        if (!this.addons.containsKey(addonURL)) {
            throw new DeployerException("Cannot get the URL of the unpacked Addon deployable '" + deployable + "'.");
        }
        unpackedDeployable = this.addons.get(addonURL);
        File unpackedDeployableFile = null;
        try {
            unpackedDeployableFile = URLUtils.urlToFile((URL)unpackedDeployable.getArchive().getURL());
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL on the unpacked deployable '" + unpackedDeployable + "'.", (Throwable)e);
        }
        AddonMetaData addonMetaData = AddonUtil.getAddonMetadata(AddonUtil.getAddonMetadataFile(unpackedDeployable.getArchive()), unpackedDeployableFile.getAbsolutePath());
        File originalFile = URLUtils.urlToFile((URL)addonURL);
        IAddonLogEntry logEntry = this.deployerLog.getEntry(originalFile);
        if (logEntry != null) {
            try {
                this.deployerLog.removeEntry(logEntry);
            }
            catch (DeployerLogException e) {
                logger.error((Object)"Cannot remove the LogEntry", new Object[0]);
            }
        }
        this.undeploy(unpackedDeployable, addonMetaData);
        this.deployedAddonNames.remove(addonMetaData.getName());
        this.addons.remove(addonURL);
        logger.info((Object)"''{0}'' addon is now undeployed", new Object[]{deployable.getShortName()});
    }

    public boolean supports(IDeployable<?> deployable) {
        return AddonDeployableImpl.class.isInstance(deployable);
    }

    private void checkAddonMetadata(AddonMetaData addonMetaData) throws DeployerException {
        if (this.deployedAddonNames.contains(addonMetaData.getName())) {
            throw new DeployerException("Cannot deploy " + addonMetaData.getName() + " addon. An Addon with the same " + "name is already deployed.");
        }
        String JOnASVersion = Version.getNumber();
        if (!addonMetaData.isJOnASVersionSupported(JOnASVersion)) {
            throw new DeployerException("Cannot deploy " + addonMetaData.getName() + " addon. JOnAS version " + JOnASVersion + " doesn't match ");
        }
        String jvmVersion = System.getProperty("java.version");
        if (!addonMetaData.isJvmVersionSupported(jvmVersion)) {
            throw new DeployerException("Cannot deploy " + addonMetaData.getName() + " addon. JVM version " + jvmVersion + " doesn't match ");
        }
    }

    private void deploy(IAddonDeployable unpackedDeployable, AddonMetaData addonMetaData, boolean isAlreadyDeployed) {
        if (isAlreadyDeployed) {
            List unpersistentDeployables = unpackedDeployable.getDeployables();
            if (!unpersistentDeployables.isEmpty()) {
                this.deploySortableDeployables(unpersistentDeployables);
            }
        } else {
            this.confDeployer.deploy(unpackedDeployable, addonMetaData, this.serverProperties, this.deployerLog, addonMetaData.getResource());
            ArrayList<ISortableDeployable> allDeployables = new ArrayList<ISortableDeployable>();
            allDeployables.addAll(unpackedDeployable.getDeployables());
            if (!allDeployables.isEmpty()) {
                this.deploySortableDeployables(allDeployables);
            }
            if (this.configurationManager != null) {
                this.configurationManager.updateServerProperties();
                if (addonMetaData.getAutostart().booleanValue()) {
                    String service = addonMetaData.getService();
                    try {
                        this.configurationManager.updateServiceConfiguration(service);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Cannot create the configuration for the service " + service), new Object[]{e});
                    }
                }
            }
        }
    }

    private void undeploy(IAddonDeployable unpackedDeployable, AddonMetaData addonMetaData) {
        this.confDeployer.undeploy(unpackedDeployable.getArchive(), addonMetaData, this.serverProperties, this.deployerLog);
        String service = addonMetaData.getService();
        if (this.configurationManager != null && addonMetaData.getAutostart().booleanValue()) {
            this.configurationManager.updateServerProperties();
            try {
                this.configurationManager.deleteServiceConfiguration(service);
            }
            catch (Exception e) {
                logger.error((Object)("Cannot delete the configuration for the service " + service), new Object[]{e});
            }
        }
        ArrayList<ISortableDeployable> allDeployables = new ArrayList<ISortableDeployable>();
        allDeployables.addAll(unpackedDeployable.getDeployables());
        if (!allDeployables.isEmpty()) {
            this.undeploySortableDeployables(allDeployables);
        }
    }

    public void retrieveJOnASConfiguration(Map<String, String> addonsToUndeploy, boolean isJOnASStarting) {
        IAddonDeployable unpackedDeployable;
        this.confDeployer.retrieveJOnASConfiguration(this.serverProperties, this.deployerLog, addonsToUndeploy, isJOnASStarting);
        if (isJOnASStarting) {
            for (Map.Entry<String, String> entry : addonsToUndeploy.entrySet()) {
                IArchive archive = ArchiveManager.getInstance().getArchive((Object)new File(entry.getValue()));
                unpackedDeployable = null;
                try {
                    unpackedDeployable = (IAddonDeployable)IAddonDeployable.class.cast(this.deployableHelper.getDeployable(archive));
                }
                catch (DeployableHelperException e) {
                    logger.error((Object)("Cannot get the deployable " + entry.getValue()), new Object[]{e});
                }
                File unpackedDeployableFile = null;
                try {
                    unpackedDeployableFile = URLUtils.urlToFile((URL)unpackedDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    logger.error((Object)("Cannot get the URL on the unpacked deployable '" + unpackedDeployable + "'."), new Object[]{e});
                }
                AddonMetaData addonMetaData = AddonUtil.getAddonMetadata(AddonUtil.getAddonMetadataFile(unpackedDeployable.getArchive()), unpackedDeployableFile.getAbsolutePath());
                String service = addonMetaData.getService();
                if (!addonMetaData.getAutostart().booleanValue()) continue;
                this.configurationManager.updateServerProperties();
                try {
                    this.configurationManager.deleteServiceConfiguration(service);
                }
                catch (Exception e) {
                    logger.error((Object)("Cannot delete the configuration for the service " + service), new Object[]{e});
                }
            }
        }
        for (Map.Entry<String, String> entry : addonsToUndeploy.entrySet()) {
            String unpackedDeployablePath = entry.getValue();
            unpackedDeployable = (IAddonDeployable)AddonUtil.getDeployable(this.deployableHelper, new File(unpackedDeployablePath));
            this.updateDeployables(unpackedDeployablePath, unpackedDeployable);
            List sortableDeployables = unpackedDeployable.getDeployables();
            if (sortableDeployables == null) continue;
            ArrayList<ISortableDeployable> persistentSortableDeployable = new ArrayList<ISortableDeployable>();
            for (ISortableDeployable sortableDeployable : sortableDeployables) {
                IDeployable deployable = sortableDeployable.getDeployable();
                if (!(deployable instanceof OSGiDeployable)) continue;
                persistentSortableDeployable.add(sortableDeployable);
            }
            this.undeploySortableDeployables(persistentSortableDeployable);
        }
        if (this.isCleanup) {
            for (IAddonLogEntry addonLogEntry : this.deployerLog.getEntries()) {
                List osgiDeployables = addonLogEntry.getOSGiDeployables();
                if (osgiDeployables == null) continue;
                ArrayList<ISortableDeployable> sortableDeployables = new ArrayList<ISortableDeployable>();
                for (String osgiDeployable : osgiDeployables) {
                    IDeployable deployable = AddonUtil.getDeployable(this.deployableHelper, new File(osgiDeployable));
                    sortableDeployables.add(AddonUtil.getSortableDeployable(deployable));
                }
                this.deploySortableDeployables(sortableDeployables);
            }
        }
    }

    public List<String> updateDeployables(String unpackedDeployablePath, IAddonDeployable unpackedDeployable, AddonMetaData addonMetaData) {
        ArrayList<String> osgiDeployables = new ArrayList<String>();
        File addonDeployWorkDirectory = new File(AddonUtil.getAddonDeployWorkDirectory(unpackedDeployablePath));
        if (addonDeployWorkDirectory.isDirectory()) {
            for (File file : addonDeployWorkDirectory.listFiles()) {
                IDeployable deployable = AddonUtil.getDeployable(this.deployableHelper, file);
                ISortableDeployable sortableDeployable = AddonUtil.getSortableDeployable(deployable);
                if (deployable instanceof OSGiDeployable) {
                    unpackedDeployable.addDeployable(sortableDeployable);
                    osgiDeployables.add(file.getAbsolutePath());
                    continue;
                }
                if (deployable instanceof DeploymentPlanDeployable) {
                    String service = addonMetaData.getService();
                    if (service != null) {
                        String implementation;
                        File urlInternalDirectory = new File(AddonUtil.JONAS_ROOT_URL_INTERNAL_DIRECTORY);
                        if (!urlInternalDirectory.exists()) {
                            urlInternalDirectory.getParentFile().mkdirs();
                        }
                        if ((implementation = addonMetaData.getImplementation()) == null) {
                            String defaultDeploymentPlanName = AddonUtil.getDefaultDeploymentPlan(service);
                            File defaultDeploymentPlan = new File(addonDeployWorkDirectory.getAbsolutePath(), defaultDeploymentPlanName);
                            if (defaultDeploymentPlan.exists()) {
                                AddonUtil.copyFile(defaultDeploymentPlan, new File(urlInternalDirectory.getAbsolutePath(), defaultDeploymentPlanName));
                            }
                        } else {
                            File jonasDeploymentPlanImpl;
                            String jonasAbstractDeploymentPlanName = AddonUtil.getAbstractDeploymentPlan(service);
                            String jonasDeploymentPlanImplName = AddonUtil.getImplDeploymentPlan(service, implementation);
                            File jonasAbstractDeploymentPlan = new File(addonDeployWorkDirectory.getAbsolutePath(), jonasAbstractDeploymentPlanName);
                            if (jonasAbstractDeploymentPlan.exists()) {
                                AddonUtil.copyFile(jonasAbstractDeploymentPlan, new File(urlInternalDirectory.getAbsolutePath(), jonasAbstractDeploymentPlanName));
                            }
                            if ((jonasDeploymentPlanImpl = new File(addonDeployWorkDirectory.getAbsolutePath(), jonasDeploymentPlanImplName)).exists()) {
                                AddonUtil.copyFile(jonasDeploymentPlanImpl, new File(urlInternalDirectory.getAbsolutePath(), jonasDeploymentPlanImplName));
                            }
                        }
                        unpackedDeployable.addDeployable(sortableDeployable);
                        continue;
                    }
                    unpackedDeployable.addDeployable(sortableDeployable);
                    continue;
                }
                if (deployable instanceof UnknownDeployable) continue;
                unpackedDeployable.addDeployable(sortableDeployable);
            }
        }
        return osgiDeployables;
    }

    public void updateDeployables(String unpackedDeployablePath, IAddonDeployable unpackedDeployable) {
        File addonDeployWorkDirectory = new File(AddonUtil.getAddonDeployWorkDirectory(unpackedDeployablePath));
        if (addonDeployWorkDirectory.isDirectory()) {
            for (File file : addonDeployWorkDirectory.listFiles()) {
                IDeployable deployable = AddonUtil.getDeployable(this.deployableHelper, file);
                ISortableDeployable sortableDeployable = AddonUtil.getSortableDeployable(deployable);
                if (deployable instanceof UnknownDeployable) continue;
                unpackedDeployable.addDeployable(sortableDeployable);
            }
        }
    }

    private void deployADeployable(IDeployable deployable) {
        try {
            if (!this.deployerManager.isDeployed(deployable)) {
                this.deployerManager.deploy(deployable);
            }
        }
        catch (DeployerException e) {
            logger.error((Object)("Cannot deploy the deployable " + deployable.getArchive().getName() + "."), new Object[]{e});
        }
        catch (UnsupportedDeployerException e) {
            logger.error((Object)("Cannot deploy the deployable " + deployable.getArchive().getName() + "."), new Object[]{e});
        }
    }

    private void undeployADeployable(IDeployable deployable) {
        try {
            this.deployerManager.undeploy(deployable);
        }
        catch (DeployerException e) {
            logger.error((Object)("Cannot undeploy the deployable " + deployable.getArchive().getName() + "."), new Object[]{e});
        }
        catch (UnsupportedDeployerException e) {
            logger.error((Object)("Cannot undeploy the deployable " + deployable.getArchive().getName() + "."), new Object[]{e});
        }
    }

    private void deploySortableDeployables(List<ISortableDeployable> sortableDeployables) {
        AddonUtil.sortSortableDeployable(sortableDeployables);
        ArrayList<IDeployable> deployables = new ArrayList<IDeployable>();
        for (ISortableDeployable sortableDeployable : sortableDeployables) {
            IDeployable deployable = sortableDeployable.getDeployable();
            try {
                if (this.deployerManager.isDeployed(deployable)) continue;
                deployables.add(sortableDeployable.getDeployable());
            }
            catch (DeployerException e) {
                logger.error((Object)("Could not find if the deployable " + deployable.getShortName() + " is already deployed"), new Object[]{e});
            }
            catch (UnsupportedDeployerException e) {
                logger.error((Object)("Could not find if the deployable " + deployable.getShortName() + " is already deployed"), new Object[]{e});
            }
        }
        try {
            this.deployerManager.deploy(deployables);
        }
        catch (DeployerException e) {
            for (IDeployable deployable : deployables) {
                logger.error((Object)("Cannot deploy the deployable " + deployable.getArchive().getName() + "."), new Object[]{e});
            }
        }
        catch (UnsupportedDeployerException e) {
            for (IDeployable deployable : deployables) {
                logger.error((Object)("Cannot deploy the deployable " + deployable.getArchive().getName() + "."), new Object[]{e});
            }
        }
    }

    private void undeploySortableDeployables(List<ISortableDeployable> sortableDeployables) {
        AddonUtil.sortSortableDeployable(sortableDeployables);
        Collections.reverse(sortableDeployables);
        ArrayList<IDeployable> deployables = new ArrayList<IDeployable>();
        for (ISortableDeployable sortableDeployable : sortableDeployables) {
            deployables.add(sortableDeployable.getDeployable());
        }
        try {
            this.deployerManager.undeploy(deployables);
        }
        catch (DeployerException e) {
            for (IDeployable deployable : deployables) {
                logger.error((Object)("Cannot deploy the deployable " + deployable.getArchive().getName() + "."), new Object[]{e});
            }
        }
        catch (UnsupportedDeployerException e) {
            for (IDeployable deployable : deployables) {
                logger.error((Object)("Cannot deploy the deployable " + deployable.getArchive().getName() + "."), new Object[]{e});
            }
        }
    }
}

