/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.deployer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.codehaus.plexus.util.IOUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jonas.addon.deploy.api.config.IAddonConfig;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.jonas.addon.deploy.api.util.IAddonLogEntry;
import org.ow2.jonas.addon.deploy.api.util.IAddonStructure;
import org.ow2.jonas.addon.deploy.impl.config.AddonConfigImpl;
import org.ow2.jonas.addon.deploy.impl.deployer.AddonMetaData;
import org.ow2.jonas.addon.deploy.impl.util.AddonDeployerLog;
import org.ow2.jonas.addon.deploy.impl.util.AddonUtil;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.maven.plugin.mergeproperties.core.AggregateStrategy;
import org.ow2.util.maven.plugin.mergeproperties.core.MergeProperties;
import org.ow2.util.maven.plugin.mergeproperties.core.Preferences;
import org.ow2.util.maven.plugin.mergeproperties.core.Resource;
import org.ow2.util.maven.plugin.mergeproperties.core.Strategies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfDeployerImpl {
    private static Log logger = LogFactory.getLog(ConfDeployerImpl.class);
    public final String SERVICE_REGISTRATION_ADDON_PROPERTY = "addon";
    private BundleContext bundleContext;
    private List<ServiceRegistration> serviceRegistrations;

    public ConfDeployerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.serviceRegistrations = new ArrayList<ServiceRegistration>();
    }

    public void deploy(IAddonDeployable unpackedDeployable, AddonMetaData addonMetaData, ServerProperties serverProperties, AddonDeployerLog deployerLog, Resource addonResource) {
        String addonConfigurationPath = null;
        String addonDirectory = null;
        try {
            addonDirectory = unpackedDeployable.getArchive().getURL().getPath();
            addonConfigurationPath = addonDirectory + "conf";
        }
        catch (ArchiveException e) {
            logger.error((Object)"Cant get URL archive", new Object[]{e});
        }
        String addonName = addonMetaData.getName();
        String JOnASAddonDirectoryPath = AddonUtil.getAddonDirectoryPath(addonName);
        File JOnASAddonDirectory = new File(JOnASAddonDirectoryPath);
        if (!JOnASAddonDirectory.exists()) {
            JOnASAddonDirectory.mkdirs();
        }
        File addonMetaDataFile = addonMetaData.getAddonMetaDataFile();
        try {
            FileUtils.copyFile((String)addonMetaDataFile.getAbsolutePath(), (String)(JOnASAddonDirectory + File.separator + addonMetaDataFile.getName()));
        }
        catch (FileUtilsException e) {
            logger.error((Object)("Cannot copy file " + addonMetaDataFile.getAbsolutePath() + "."), new Object[]{e});
        }
        AddonUtil.copyFiles(addonConfigurationPath, JOnASAddonDirectoryPath);
        this.updateGeneratedJonasPropertiesFragment(addonDirectory, addonMetaData);
        try {
            this.register(JOnASAddonDirectoryPath, addonName);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot register a new IAddonConfig component with " + JOnASAddonDirectoryPath + " directory"), new Object[]{e});
        }
        this.generateJonasPropertiesFile(serverProperties, deployerLog, addonResource);
    }

    public void undeploy(IArchive unpackedArchive, AddonMetaData addonMetaData, ServerProperties serverProperties, AddonDeployerLog addonDeployerLog) {
        String unpackedDeployablePath = null;
        try {
            unpackedDeployablePath = unpackedArchive.getURL().getPath();
        }
        catch (ArchiveException e) {
            logger.error((Object)"Cannot get the URL of the Archive to undeploy", new Object[]{e});
        }
        String addonName = addonMetaData.getName();
        HashMap<String, String> addonsToUndeploy = new HashMap<String, String>();
        addonsToUndeploy.put(addonName, unpackedDeployablePath);
        this.unregister(addonName);
        this.retrieveJOnASConfiguration(serverProperties, addonDeployerLog, addonsToUndeploy, false);
    }

    public void retrieveJOnASConfiguration(ServerProperties serverProperties, AddonDeployerLog addonDeployerLog, Map<String, String> addonsToUndeploy, boolean isJOnASStarting) {
        for (String addonName : addonsToUndeploy.keySet()) {
            String unpackedDeployablePath = addonsToUndeploy.get(addonName);
            this.deleteJonasPropertiesFragment(unpackedDeployablePath);
            String JOnASAddonDirectoryPath = AddonUtil.getAddonDirectoryPath(addonName);
            this.deleteFile(JOnASAddonDirectoryPath);
        }
        if (isJOnASStarting) {
            Vector logEntries = addonDeployerLog.getEntries();
            for (IAddonLogEntry logEntry : logEntries) {
                String addonMetaDataPath;
                File addonMetaDataFile;
                String addonName = logEntry.getName();
                String addonConfDirectory = AddonUtil.getAddonDirectoryPath(addonName);
                try {
                    this.register(addonConfDirectory, addonName);
                }
                catch (Exception e) {
                    logger.error((Object)("Cannot register a new IAddonConfig component with " + addonConfDirectory + " directory"), new Object[]{e});
                }
                if (!(addonMetaDataFile = new File(addonMetaDataPath = AddonUtil.getAddonDirectoryPath(addonName) + File.separator + "jonas-addon.xml")).exists()) continue;
                String addonWorkDirectoryPath = logEntry.getCopy().getAbsolutePath();
                AddonMetaData addonMetaData = AddonUtil.getAddonMetadata(addonMetaDataFile, addonWorkDirectoryPath);
                this.updateGeneratedJonasPropertiesFragment(addonWorkDirectoryPath, addonMetaData);
                try {
                    FileUtils.copyFile((String)addonMetaDataPath, (String)(addonWorkDirectoryPath + File.separator + IAddonStructure.JONAS_ADDON_METADATA));
                }
                catch (FileUtilsException e) {
                    logger.error((Object)("Cannot copy file " + addonMetaDataFile.getAbsolutePath() + "."), new Object[]{e});
                }
            }
        }
        this.generateJonasPropertiesFile(serverProperties, addonDeployerLog);
    }

    private Resource getBootstrapResource(ServerProperties serverProperties) {
        File jonasPropertiesFile = new File(AddonUtil.JONAS_CONF_DIRECTORY, "jonas.properties");
        FileInputStream jonasPropertiesInputStream = null;
        try {
            jonasPropertiesInputStream = new FileInputStream(jonasPropertiesFile);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("Cannot find jonas.properties file: " + serverProperties.getPropFileName() + " ."), new Object[]{e});
        }
        Resource jonasPropertiesResource = new Resource(jonasPropertiesInputStream);
        jonasPropertiesResource.setName(jonasPropertiesFile.getAbsolutePath());
        return jonasPropertiesResource;
    }

    public boolean deleteFile(String directoryPath) {
        return FileUtils.delete((String)directoryPath);
    }

    public void generateJonasPropertiesFile(ServerProperties serverProperties, AddonDeployerLog addonDeployerLog) {
        Resource jonasPropertiesMasterResource = this.getBootstrapResource(serverProperties);
        List<Resource> jonasPropertiesAddonResources = this.getJonasPropertiesAddonResources(addonDeployerLog);
        this.generateJonasPropertiesFile(serverProperties, jonasPropertiesMasterResource, jonasPropertiesAddonResources);
    }

    public void generateJonasPropertiesFile(ServerProperties serverProperties, AddonDeployerLog addonDeployerLog, Resource resource) {
        Resource jonasPropertiesMasterResource = this.getBootstrapResource(serverProperties);
        List<Resource> jonasPropertiesAddonResources = this.getJonasPropertiesAddonResources(addonDeployerLog);
        jonasPropertiesAddonResources.add(resource);
        this.generateJonasPropertiesFile(serverProperties, jonasPropertiesMasterResource, jonasPropertiesAddonResources);
    }

    private void generateJonasPropertiesFile(ServerProperties serverProperties, Resource jonasPropertiesMasterResource, List<Resource> jonasPropertiesAddonResources) {
        String jonasPropertiesGenerated = serverProperties.getWorkDirectory() + File.separator + "conf-generated" + File.separator + "jonas.properties";
        AggregateStrategy aggregateStrategy1 = new AggregateStrategy();
        aggregateStrategy1.setKey("jonas.services");
        AggregateStrategy[] aggregateStrategies = new AggregateStrategy[]{aggregateStrategy1};
        ArrayList<String> fileOrderPreferences = new ArrayList<String>();
        fileOrderPreferences.add("jonas.*");
        fileOrderPreferences.add("jonas.service[.].*");
        Preferences preferences = new Preferences();
        preferences.setFileOrderPreferences(fileOrderPreferences);
        Strategies strategies = new Strategies();
        strategies.setAggregateStrategies(aggregateStrategies);
        MergeProperties mergeProperties = new MergeProperties();
        mergeProperties.setMasterResource(jonasPropertiesMasterResource);
        mergeProperties.setTemplateResources(jonasPropertiesAddonResources);
        mergeProperties.setOutputFile(jonasPropertiesGenerated);
        mergeProperties.setPreferences(preferences);
        mergeProperties.setStrategies(strategies);
        try {
            mergeProperties.execute();
        }
        catch (Exception e) {
            logger.error((Object)("Generation of " + jonasPropertiesGenerated + " failed."), new Object[]{e});
        }
    }

    public String getJonasPropertiesFragment(String addonDirectory) {
        return AddonUtil.getGeneratedWorkDirectory(addonDirectory) + File.separator + "jonas.properties";
    }

    public List<Resource> getJonasPropertiesAddonResources(AddonDeployerLog deployerLog) {
        ArrayList<Resource> jonasPropertiesAddonResources = new ArrayList<Resource>();
        if (deployerLog != null) {
            Vector logEntries = deployerLog.getEntries();
            for (IAddonLogEntry logEntry : logEntries) {
                String jonasPropertiesFragment = this.getJonasPropertiesFragment(logEntry.getCopy().getAbsolutePath());
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(jonasPropertiesFragment);
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)("Cannot find the file " + jonasPropertiesFragment + "."), new Object[]{e});
                }
                Resource resource = new Resource(inputStream);
                resource.setName(jonasPropertiesFragment);
                jonasPropertiesAddonResources.add(resource);
            }
        }
        return jonasPropertiesAddonResources;
    }

    public void deleteJonasPropertiesFragment(String unpackedDeployablePath) {
        this.deleteFile(this.getJonasPropertiesFragment(unpackedDeployablePath));
    }

    private ServiceRegistration getServiceRegistration(String addonName) {
        for (ServiceRegistration serviceRegistration : this.serviceRegistrations) {
            if (!serviceRegistration.getReference().getProperty("addon").equals(addonName)) continue;
            return serviceRegistration;
        }
        return null;
    }

    private void register(String configurationDirectory, String addonName) throws Exception {
        AddonConfigImpl addonConfig = new AddonConfigImpl(configurationDirectory);
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("addon", addonName);
        this.serviceRegistrations.add(this.bundleContext.registerService(IAddonConfig.class.getName(), (Object)addonConfig, dictionary));
    }

    private void unregister(String addonName) {
        this.getServiceRegistration(addonName).unregister();
    }

    private void updateGeneratedJonasPropertiesFragment(String addonDirectory, AddonMetaData addonMetaData) {
        String jonasPropertiesFragmentPath = this.getJonasPropertiesFragment(addonDirectory);
        File jonasPropertiesFragment = new File(jonasPropertiesFragmentPath);
        if (!jonasPropertiesFragment.getParentFile().exists()) {
            jonasPropertiesFragment.getParentFile().mkdirs();
        }
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(jonasPropertiesFragmentPath);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("Cannot create file " + jonasPropertiesFragmentPath), new Object[]{e});
        }
        try {
            IOUtil.copy(addonMetaData.getResource().getInputStream(), (OutputStream)output);
        }
        catch (IOException e) {
            logger.error((Object)"Cannot write jonas.properties fragment of into ", new Object[]{e});
        }
    }
}

