/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.ow2.jonas.addon.deploy.api.util.IAddonLogEntry;
import org.ow2.jonas.lib.work.LogEntryImpl;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddonLogEntry
extends LogEntryImpl
implements IAddonLogEntry {
    private String name;
    private List<String> osgiDeployables;
    public final String OSGI_OPEN_TAG = "osgi{";
    public final String OSGI_SEPARATOR = ",";
    public final String OSGI_END_TAG = "}";
    private static Log logger = LogFactory.getLog(AddonLogEntry.class);

    public AddonLogEntry(String name, File original, File copy) {
        super(original, copy);
        this.name = name;
        this.osgiDeployables = new ArrayList<String>();
    }

    public String getName() {
        return this.name;
    }

    public String getOSGiDeployablesAsAString() {
        int i;
        String result = "osgi{";
        for (i = 0; i < this.osgiDeployables.size() - 1; ++i) {
            result = result + this.osgiDeployables.get(i) + ",";
        }
        if (i < this.osgiDeployables.size()) {
            result = result + this.osgiDeployables.get(i);
        }
        result = result + "}";
        return result;
    }

    public List<String> getOSGiDeployables() {
        return this.osgiDeployables;
    }

    public void addOSGiDeployable(String osgiDeployable) {
        this.osgiDeployables.add(osgiDeployable);
    }

    public void setOSGiDeployables(List<String> osgiDeployables) {
        this.osgiDeployables = osgiDeployables;
    }

    public void setOSGiDeployables(String osgiDeployables) {
        this.osgiDeployables = new ArrayList<String>();
        if (osgiDeployables.startsWith("osgi{") && osgiDeployables.endsWith("}")) {
            String elements = osgiDeployables.substring("osgi{".length(), osgiDeployables.length() - "}".length());
            StringTokenizer stringTokenizer = new StringTokenizer(elements, ",");
            while (stringTokenizer.hasMoreElements()) {
                this.osgiDeployables.add(stringTokenizer.nextElement().toString());
            }
        }
    }
}

