/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.addon.deploy.impl.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ow2.jonas.addon.deploy.api.deployable.IAddonDeployable;
import org.ow2.jonas.addon.deploy.api.deployable.ISortableDeployable;
import org.ow2.jonas.addon.deploy.api.util.IAddonStructure;
import org.ow2.jonas.addon.deploy.impl.deployable.SortableDeployable;
import org.ow2.jonas.addon.deploy.impl.deployable.SortableDeployableComparator;
import org.ow2.jonas.addon.deploy.impl.deployer.AddonMetaData;
import org.ow2.jonas.addon.deploy.impl.util.Range;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJB21Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.OSGiDeployable;
import org.ow2.util.ee.deploy.api.deployable.RARDeployable;
import org.ow2.util.ee.deploy.api.deployable.UnknownDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.api.helper.IDeployableHelper;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.deploy.deployable.api.DeploymentPlanDeployable;
import org.ow2.util.plan.deploy.deployable.api.FileDeployable;
import org.ow2.util.url.URLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddonUtil {
    private static Log logger = LogFactory.getLog(AddonUtil.class);
    public static final String EOL = "\n";
    public static final String PROPERTY_SEPARATOR = " ";
    public static final String JONAS_ROOT = JProp.getJonasRoot();
    public static final String JONAS_BASE = JProp.getJonasBase();
    public static final String JONAS_CONF_DIRECTORY = JONAS_BASE + File.separator + "conf";
    public static final String JONAS_ROOT_REPOSITORY = JProp.getRepositoriesRootDir();
    public static final String JONAS_BASE_REPOSITORY = JProp.getRepositoriesBaseDir();
    public static final String URL_INTERNAL_DIRECTORY_NAME = "url-internal";
    public static final String JONAS_ROOT_URL_INTERNAL_DIRECTORY = JONAS_ROOT_REPOSITORY + File.separator + "url-internal";
    public static final String JONAS_BASE_URL_INTERNAL_DIRECTORY = JONAS_BASE_REPOSITORY + File.separator + "url-internal";
    public static final String JONAS_ADDONS_DIRECTORY = JONAS_CONF_DIRECTORY + File.separator + "addons";
    public static final String LOG_FILE = "addons.log";
    public static final String JONAS_SERVICE = "jonas.service.";
    public static final Pattern JONAS_SERVICE_CLASS_PROPERTY_PATTERN = Pattern.compile("jonas.service.*.class");
    public static final String DOT = ".";
    public static final String DASH = "-";
    public static final String XML_EXTENSION = ".xml";
    public static final String CLASS_EXTENSION = ".class";
    public static final String ABSTRACT_DEPLOYMENT_PLAN_KEY = "base";
    public static final int OSGI_DEPLOYABLE_PRIORITY = 1;
    public static final int RAR_DEPLOYABLE_PRIORITY = 2;
    public static final int DATASOURCE_DEPLOYABLE_PRIORITY = 3;
    public static final int DEPLOYMENT_PLAN_DEPLOYABLE_PRIORITY = 4;
    public static final int CONFIG_ADMIN_DEPLOYABLE_PRIORITY = 5;
    public static final int EJB2_DEPLOYABLE_PRIORITY = 6;
    public static final int EJB3_DEPLOYABLE_PRIORITY = 7;
    public static final int EAR_DEPLOYABLE_PRIORITY = 8;
    public static final int WAR_DEPLOYABLE_PRIORITY = 9;
    public static final int DEFAULT_DEPLOYMENT_PLAN_PRIORITY = 10;

    public static AddonMetaData getAddonMetadata(File addonMetadataFile, String unpackedDeployablePath) {
        FileInputStream addonInputStream = null;
        try {
            addonInputStream = new FileInputStream(addonMetadataFile);
        }
        catch (FileNotFoundException e) {
            logger.info((Object)"Cannot create inputstream. AdddonMetaData file not found .", new Object[]{e});
        }
        AddonMetaData addonMetaData = new AddonMetaData();
        addonMetaData.setAddonMetaDataFile(addonMetadataFile);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)(DOT + e), new Object[0]);
        }
        Document dom = null;
        try {
            dom = db.parse(addonInputStream);
        }
        catch (SAXException e) {
            logger.error((Object)(DOT + e), new Object[0]);
        }
        catch (IOException e) {
            logger.error((Object)(DOT + e), new Object[0]);
        }
        Element rootElement = dom.getDocumentElement();
        for (Node child = rootElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            Node firstChild = child.getFirstChild();
            String value = "";
            if (firstChild != null) {
                value = child.getFirstChild().getNodeValue();
            }
            if (child.getNodeName().equals("name")) {
                addonMetaData.setName(value);
                continue;
            }
            if (child.getNodeName().equals("description")) {
                addonMetaData.setDescription(value);
                continue;
            }
            if (child.getNodeName().equals("author")) {
                addonMetaData.setAuthor(value);
                continue;
            }
            if (child.getNodeName().equals("licence")) {
                addonMetaData.setLicence(value);
                continue;
            }
            if (child.getNodeName().equals("jonas-version")) {
                try {
                    addonMetaData.setJonasVersions(AddonUtil.getRange(value));
                }
                catch (Exception e) {
                    logger.error((Object)"Cannot get the range of compatible JOnAS versions", new Object[]{e});
                }
                continue;
            }
            if (child.getNodeName().equals("autostart")) {
                addonMetaData.setAutostart(Boolean.parseBoolean(value));
                continue;
            }
            if (child.getNodeName().equals("jvm-version")) {
                try {
                    addonMetaData.setJvmVersions(AddonUtil.getRange(value));
                }
                catch (Exception e) {
                    logger.error((Object)"Cannot get the range of compatible Jvm versions", new Object[]{e});
                }
                continue;
            }
            if (child.getNodeName().equals("provides")) {
                addonMetaData.setProvides(value);
                continue;
            }
            if (child.getNodeName().equals("requirements")) {
                addonMetaData.setRequirements(value);
                continue;
            }
            if (!child.getNodeName().equals("properties")) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (Node node = ((Element)child).getFirstChild(); node != null; node = node.getNextSibling()) {
                Node valueNode;
                if (node.getNodeType() != 1 || (valueNode = node.getFirstChild()) == null) continue;
                String key = node.getNodeName();
                String val = valueNode.getNodeValue();
                String property = "";
                if (JONAS_SERVICE_CLASS_PROPERTY_PATTERN.matcher(key).matches()) {
                    int i;
                    String service = key.substring(key.indexOf(JONAS_SERVICE) + JONAS_SERVICE.length(), key.indexOf(CLASS_EXTENSION));
                    addonMetaData.setService(service);
                    if (addonMetaData.getAutostart().booleanValue()) {
                        property = property + "jonas.services " + service + EOL;
                    }
                    String defaultDeploymentPlan = AddonUtil.getDefaultDeploymentPlan(service);
                    String abstractDeploymentPlan = AddonUtil.getAbstractDeploymentPlan(service);
                    String addonDeployWorkDirectory = AddonUtil.getAddonDeployWorkDirectory(unpackedDeployablePath);
                    List<File> files = Arrays.asList(new File(addonDeployWorkDirectory).listFiles());
                    for (i = 0; i < files.size() && !files.get(i).getName().equals(abstractDeploymentPlan); ++i) {
                    }
                    if (i < files.size() && files.get(i).getName().equals(abstractDeploymentPlan)) {
                        StringTokenizer stringTokenizer = new StringTokenizer(val, DOT);
                        String implementation = null;
                        int countTokens = stringTokenizer.countTokens();
                        for (int y = 1; y < countTokens; ++y) {
                            implementation = stringTokenizer.nextElement().toString();
                        }
                        File implDeploymentPlan = new File(addonDeployWorkDirectory, AddonUtil.getImplDeploymentPlan(service, implementation));
                        if (!implDeploymentPlan.exists()) {
                            logger.error((Object)("Could not find the deployment plan " + implDeploymentPlan.getAbsolutePath()), new Object[0]);
                        } else {
                            addonMetaData.setImplementation(implementation);
                        }
                    } else {
                        int k;
                        for (k = 0; k < files.size() && !files.get(k).getName().equals(defaultDeploymentPlan); ++k) {
                        }
                        if (k >= files.size() || files.get(k).getName().equals(defaultDeploymentPlan)) {
                            // empty if block
                        }
                    }
                }
                property = property + key + PROPERTY_SEPARATOR + val + EOL;
                try {
                    byteArrayOutputStream.write(property.getBytes());
                    continue;
                }
                catch (IOException e) {
                    logger.error((Object)("Cannot write property \"" + property + "\" ."), new Object[]{e});
                }
            }
            addonMetaData.setResource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), addonMetaData.getAddonMetaDataFile().getAbsolutePath());
        }
        return addonMetaData;
    }

    public static File getAddonMetadataFile(IArchive addonArchive) {
        Iterator urls = null;
        try {
            urls = addonArchive.getResources();
        }
        catch (ArchiveException e) {
            logger.info((Object)"Cannot get resources from the archive .", new Object[]{e});
        }
        if (urls != null) {
            while (urls.hasNext()) {
                URL url = (URL)urls.next();
                if (!url.getFile().endsWith(IAddonStructure.JONAS_ADDON_METADATA)) continue;
                return URLUtils.urlToFile((URL)url);
            }
        }
        return null;
    }

    public static String getAddonsWorkDirectory(ServerProperties serverProperties) {
        return serverProperties.getWorkDirectory() + File.separator + "addons";
    }

    public static String getAddonConfWorkDirectory(String addonWorkDirectory) {
        return addonWorkDirectory + File.separator + "conf";
    }

    public static String getAddonDeployWorkDirectory(String addonWorkDirectory) {
        return addonWorkDirectory + File.separator + "deploy";
    }

    public static String getAddonAntWorkDirectory(String addonWorkDirectory) {
        return addonWorkDirectory + File.separator + "ant";
    }

    public static String getAddonBinWorkDirectory(String addonWorkDirectory) {
        return addonWorkDirectory + File.separator + "bin";
    }

    public static String getAddonLogFile(ServerProperties serverProperties) {
        return AddonUtil.getAddonsWorkDirectory(serverProperties) + File.separator + LOG_FILE;
    }

    public static String getAddonWorkDirectory(IAddonDeployable unpackedDeployable) {
        try {
            return unpackedDeployable.getArchive().getURL().getPath();
        }
        catch (ArchiveException e) {
            logger.error((Object)"Cant get the unpacked URL", new Object[]{e});
            return null;
        }
    }

    public static String getGeneratedWorkDirectory(String addonDirectory) {
        return addonDirectory + File.separator + "generated";
    }

    public static String getAddonDirectoryPath(String addonName) {
        return JONAS_ADDONS_DIRECTORY + File.separator + addonName;
    }

    public static IDeployable getDeployable(IDeployableHelper deployableHelper, File file) {
        IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
        if (archive == null) {
            logger.warn((Object)"Ignoring invalid file ''{0}''", new Object[]{file});
        }
        try {
            return deployableHelper.getDeployable(archive);
        }
        catch (DeployableHelperException e) {
            logger.error((Object)"Cannot get a deployable for the archive ''{0}''", new Object[]{archive, e});
            return null;
        }
    }

    public static String getDefaultDeploymentPlan(String service) {
        return service + XML_EXTENSION;
    }

    public static String getAbstractDeploymentPlan(String service) {
        return service + DASH + ABSTRACT_DEPLOYMENT_PLAN_KEY + XML_EXTENSION;
    }

    public static String getImplDeploymentPlan(String service, String implementation) {
        return service + DASH + implementation + XML_EXTENSION;
    }

    public static void copyFile(File sourceFile, File destFile) {
        try {
            FileUtils.copyFile((String)sourceFile.getAbsolutePath(), (String)destFile.getAbsolutePath());
        }
        catch (FileUtilsException e) {
            logger.error((Object)("Cannot copy file " + sourceFile.getAbsolutePath() + " to " + destFile.getAbsolutePath() + DOT), new Object[]{e});
        }
    }

    public static void sortSortableDeployable(List<ISortableDeployable> sortableDeployables) {
        Collections.sort(sortableDeployables, new SortableDeployableComparator());
    }

    public static ISortableDeployable getSortableDeployable(IDeployable deployable) {
        Integer priority = null;
        if (deployable instanceof OSGiDeployable) {
            priority = 1;
        } else if (deployable instanceof DeploymentPlanDeployable) {
            priority = 4;
        } else if (deployable instanceof EARDeployable) {
            priority = 8;
        } else if (deployable instanceof EJB3Deployable) {
            priority = 7;
        } else if (deployable instanceof EJB21Deployable) {
            priority = 6;
        } else if (deployable instanceof WARDeployable) {
            priority = 9;
        } else if (deployable instanceof RARDeployable) {
            priority = 2;
        } else if (deployable instanceof FileDeployable) {
            priority = 5;
        } else if (!(deployable instanceof UnknownDeployable)) {
            priority = 10;
        }
        return new SortableDeployable(deployable, priority);
    }

    private static Range getRange(String rangeProperty) throws Exception {
        Range range = null;
        if ((rangeProperty.startsWith("(") || rangeProperty.startsWith("[")) && (rangeProperty.endsWith(")") || rangeProperty.endsWith("]"))) {
            boolean isInclusionOpenTag = rangeProperty.startsWith("[");
            boolean isInclusionCloseTag = rangeProperty.endsWith("]");
            StringTokenizer stringTokenizer = new StringTokenizer(rangeProperty.substring(1, rangeProperty.length() - 1), ",");
            int countTockens = stringTokenizer.countTokens();
            if (countTockens == 1 && isInclusionOpenTag != isInclusionCloseTag || countTockens > 2 || countTockens < 0) {
                throw new Exception("Cannot find a valid range for property " + rangeProperty);
            }
            range = new Range(isInclusionOpenTag, isInclusionCloseTag, stringTokenizer.nextToken());
            if (countTockens == 2) {
                range.setMaxRange(stringTokenizer.nextToken());
            }
        }
        return range;
    }

    public static void copyFiles(String originalDirectoryPath, String targetDirectoryPath) {
        File configurationDirectory = new File(originalDirectoryPath);
        if (configurationDirectory.exists()) {
            for (File configurationFile : configurationDirectory.listFiles()) {
                String filename = configurationFile.getName();
                String confFile = targetDirectoryPath + File.separator + filename;
                try {
                    FileUtils.copyFile((String)configurationFile.getAbsolutePath(), (String)confFile);
                }
                catch (FileUtilsException e) {
                    logger.error((Object)("Cannot copy file " + filename + DOT), new Object[]{e});
                }
            }
        }
    }
}

