/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.maven.plugin.mergeproperties.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.maven.plugin.mergeproperties.core.Marker;
import org.ow2.util.maven.plugin.mergeproperties.core.Preference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preferences {
    private Preference[] fixedPreferences;
    private List<Preference> fixedPreferencesList;
    private Preference[] orderPreferences;
    private List<Preference> orderPreferencesList;
    private List<String> fileOrderPreferences;
    private static Log logger = LogFactory.getLog(Preferences.class);

    public List<String> applyPreferences(Marker marker) throws Exception {
        Iterator it;
        List<String> preferencesValues;
        int i;
        ArrayList<String> validValues = new ArrayList<String>();
        List markerValues = marker.getValues();
        if (this.fixedPreferencesList != null) {
            for (i = 0; i < this.fixedPreferencesList.size() && !this.fixedPreferencesList.get(i).matchPattern(marker.getKey()); ++i) {
            }
            if (i < this.fixedPreferencesList.size() && this.fixedPreferencesList.get(i).matchPattern(marker.getKey())) {
                preferencesValues = this.fixedPreferencesList.get(i).getListValues();
                for (String value : preferencesValues) {
                    if (!markerValues.contains(value)) continue;
                    validValues.add(value);
                    markerValues.remove(value);
                }
            }
        }
        if (this.orderPreferencesList != null) {
            for (i = 0; i < this.orderPreferencesList.size() && !this.orderPreferencesList.get(i).matchPattern(marker.getKey()); ++i) {
            }
            if (i < this.orderPreferencesList.size() && this.orderPreferencesList.get(i).matchPattern(marker.getKey())) {
                if (validValues.isEmpty()) {
                    preferencesValues = this.orderPreferencesList.get(i).getListValues();
                    for (String value : preferencesValues) {
                        if (!markerValues.contains(value)) continue;
                        validValues.add(value);
                        markerValues.remove(value);
                    }
                    it = markerValues.iterator();
                    while (it.hasNext()) {
                        validValues.add(it.next().toString());
                    }
                } else {
                    throw new Exception("There is more than one preference defined for key " + marker.getKey());
                }
            }
        }
        if (validValues.isEmpty()) {
            it = markerValues.iterator();
            while (it.hasNext()) {
                validValues.add(it.next().toString());
            }
        }
        return validValues;
    }

    public List<Preference> getFixedPreferences() {
        return this.fixedPreferencesList;
    }

    public List<Preference> getOrderPreferences() {
        return this.orderPreferencesList;
    }

    public List<String> getFileOrderPreferences() {
        return this.fileOrderPreferences;
    }

    public void initPatterns() {
        if (this.fixedPreferences != null) {
            this.fixedPreferencesList = new ArrayList<Preference>(Arrays.asList(this.fixedPreferences));
            for (Preference fixPreference : this.fixedPreferencesList) {
                fixPreference.initPattern();
            }
        }
        if (this.orderPreferences != null) {
            this.orderPreferencesList = new ArrayList<Preference>(Arrays.asList(this.orderPreferences));
            for (Preference ordPreference : this.orderPreferencesList) {
                ordPreference.initPattern();
            }
        }
    }

    public void setFixedPreferences(Preference[] fixedPreferences) {
        this.fixedPreferences = fixedPreferences;
    }

    public void setOrderPreferences(Preference[] orderPreferences) {
        this.orderPreferences = orderPreferences;
    }

    public void setFileOrderPreferences(List<String> fileOrderPreferences) {
        this.fileOrderPreferences = fileOrderPreferences;
    }
}

