/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.maven.plugin.mergeproperties.core;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.codehaus.plexus.util.IOUtil;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class Resource {
    private byte[] originalInputStream;
    private BufferedReader bufferedReader;
    private InputStreamReader inputStreamReader;
    private String name;
    protected Log logger = LogFactory.getLog(this.getClass());

    public Resource(InputStream inputStream) {
        try {
            this.originalInputStream = IOUtil.toByteArray(inputStream);
        }
        catch (IOException e) {
            this.logger.error((Object)"Cannot duplicate the inputstream", new Object[0]);
        }
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.originalInputStream);
    }

    public BufferedReader getBufferedReader() {
        this.close();
        this.inputStreamReader = new InputStreamReader(this.getInputStream());
        this.bufferedReader = new BufferedReader(this.inputStreamReader);
        return this.bufferedReader;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void close() {
        if (this.inputStreamReader != null) {
            try {
                this.inputStreamReader.close();
            }
            catch (IOException e) {
                this.logger.debug((Object)("Cannot close the InputStreamReader of the resource " + this.name + " ."), new Object[]{e});
            }
        }
        if (this.bufferedReader != null) {
            try {
                this.bufferedReader.close();
            }
            catch (IOException e) {
                this.logger.debug((Object)("Cannot close the BufferedReader of the resource " + this.name + " ."), new Object[]{e});
            }
        }
    }
}

