/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.maven.plugin.mergeproperties.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubsequenceKeyOccurrence {
    private int priority;
    private Pattern pattern;
    private HashMap<String, Integer> hashMapSubKeyOcc;

    public SubsequenceKeyOccurrence(int priority, String pattern) {
        this.priority = priority;
        this.pattern = Pattern.compile(pattern);
        this.hashMapSubKeyOcc = new HashMap();
    }

    public SubsequenceKeyOccurrence(int priority) {
        this.priority = priority;
        this.hashMapSubKeyOcc = new HashMap();
        this.pattern = null;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void initHashMap() {
        this.hashMapSubKeyOcc = new HashMap();
    }

    private boolean matchPattern(String key) {
        return this.pattern.matcher(key).matches();
    }

    public String getLongestCommonSubSequence(String s1, String s2) {
        int i;
        for (i = 0; i < s1.length() && i < s2.length() && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        return s1.substring(0, i);
    }

    public void addSubKeys(String key) {
        ArrayList<String> subKeys = new ArrayList<String>();
        Set<String> keys = this.hashMapSubKeyOcc.keySet();
        Iterator<String> it = keys.iterator();
        if (this.pattern == null || this.pattern != null && this.matchPattern(key)) {
            while (it.hasNext()) {
                String k = it.next();
                String commonSubSequence = this.getLongestCommonSubSequence(k, key);
                if (commonSubSequence.equals("") || subKeys.contains(commonSubSequence)) continue;
                subKeys.add(commonSubSequence);
            }
            for (String subKey : subKeys) {
                if (this.hashMapSubKeyOcc.containsKey(subKey)) {
                    this.hashMapSubKeyOcc.put(subKey, this.hashMapSubKeyOcc.get(subKey) + 1);
                    continue;
                }
                this.hashMapSubKeyOcc.put(subKey, 2);
            }
            if (this.hashMapSubKeyOcc.containsKey(key)) {
                this.hashMapSubKeyOcc.put(key, this.hashMapSubKeyOcc.get(key) + 1);
            } else {
                this.hashMapSubKeyOcc.put(key, 1);
            }
        }
    }

    public void sortHashMap(final OrderType orderType) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(this.hashMapSubKeyOcc.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (orderType.equals((Object)OrderType.DESC)) {
                    return ((Comparable)((Map.Entry)o2).getValue()).compareTo(((Map.Entry)o1).getValue());
                }
                return ((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        this.hashMapSubKeyOcc = result;
    }

    public HashMap<String, Integer> getHashMapSubKeyOcc() {
        return this.hashMapSubKeyOcc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OrderType {
        ASC,
        DESC;

    }
}

