/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.messages;

import org.objectweb.joram.shared.excepts.MessageValueException;

public class ConversionHelper {
    public static boolean toBoolean(Object value) throws MessageValueException {
        if (value == null) {
            return Boolean.valueOf(null);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new MessageValueException("Type " + value.getClass().getName() + " can't be converted to Boolean.");
    }

    public static byte toByte(Object value) throws MessageValueException {
        if (value == null) {
            return Byte.valueOf(null);
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.valueOf((String)value);
        }
        throw new MessageValueException("Type " + value.getClass().getName() + " can't be converted to Byte.");
    }

    public static short toShort(Object value) throws MessageValueException {
        if (value == null) {
            return Short.valueOf(null);
        }
        if (value instanceof Byte || value instanceof Short) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            return Short.valueOf((String)value);
        }
        throw new MessageValueException("Type " + value.getClass().getName() + " can't be converted to Short.");
    }

    public static int toInt(Object value) throws MessageValueException {
        if (value == null) {
            return Integer.valueOf(null);
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        throw new MessageValueException("Type " + value.getClass().getName() + " can't be converted to Integer.");
    }

    public static long toLong(Object value) throws MessageValueException {
        if (value == null) {
            return Long.valueOf(null);
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        throw new MessageValueException("Type " + value.getClass().getName() + " can't be converted to Long.");
    }

    public static float toFloat(Object value) throws MessageValueException {
        if (value == null) {
            return Float.valueOf(null).floatValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.valueOf((String)value).floatValue();
        }
        throw new MessageValueException("Type " + value.getClass().getName() + " can't be converted to Float.");
    }

    public static double toDouble(Object value) throws MessageValueException {
        if (value == null) {
            return Double.valueOf(null);
        }
        if (value instanceof Float || value instanceof Double) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        throw new MessageValueException("Type " + value.getClass().getName() + " can't be converted to Double.");
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        return value.toString();
    }

    public static char toChar(Object value) throws MessageValueException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new MessageValueException("Type " + value.getClass().getName() + " can't be converted to Character.");
    }

    public static byte[] toBytes(Object value) throws MessageValueException {
        if (value == null) {
            return (byte[])value;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new MessageValueException("Type " + value.getClass().getName() + " can't be converted to byte[].");
    }
}

