/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.work;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.ow2.jonas.lib.work.AbsDeployerLog;
import org.ow2.jonas.lib.work.DeployerLogException;
import org.ow2.jonas.lib.work.LogEntryImpl;
import org.ow2.jonas.workcleaner.LogEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployerLog
extends AbsDeployerLog<LogEntry> {
    public DeployerLog(File logFile) throws DeployerLogException {
        super(logFile);
    }

    @Override
    protected synchronized void loadEntries() throws DeployerLogException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.logFile));
        }
        catch (FileNotFoundException e) {
            throw new DeployerLogException("Can not read the " + this.logFile + " file");
        }
        String line = null;
        String field = null;
        File originalField = null;
        File copyField = null;
        StringTokenizer st = null;
        try {
            while ((line = br.readLine()) != null) {
                st = new StringTokenizer(line, ";");
                field = st.nextToken();
                if (field == null) {
                    throw new DeployerLogException("Inconsistent line in the file " + this.logFile);
                }
                originalField = new File(field);
                field = st.nextToken();
                if (field == null) {
                    throw new DeployerLogException("Inconsistent line in the file " + this.logFile);
                }
                copyField = new File(field);
                this.logger.debug((Object)("Entry[originalField=" + originalField + ",copyField=" + copyField + "]"), new Object[0]);
                this.logEntries.add(new LogEntryImpl(originalField, copyField));
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new DeployerLogException("Error while reading the log file " + this.logFile + " :" + ioe.getMessage());
        }
    }

    @Override
    protected synchronized void saveEntries() throws DeployerLogException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(this.logFile)));
        }
        catch (IOException e) {
            throw new DeployerLogException("Problem while trying to get an output stream for the " + this.logFile + " file");
        }
        LogEntry logEntry = null;
        String original = null;
        String copy = null;
        String line = null;
        Enumeration e = this.logEntries.elements();
        while (e.hasMoreElements()) {
            logEntry = (LogEntry)e.nextElement();
            try {
                original = logEntry.getOriginal().getCanonicalPath();
                copy = logEntry.getCopy().getCanonicalPath();
            }
            catch (IOException ioe) {
                throw new DeployerLogException("Problem while trying to get files names ");
            }
            line = original + ";" + copy;
            pw.println(line);
        }
        pw.close();
    }

    @Override
    public Vector<LogEntry> addEntry(LogEntry logEntry) throws DeployerLogException {
        if (this.logEntries == null) {
            throw new DeployerLogException("Can not add an entry, the vector is null");
        }
        File originalEntry = null;
        File copyEntry = null;
        boolean found = false;
        Enumeration e = this.logEntries.elements();
        while (e.hasMoreElements() && !found) {
            LogEntry entry = (LogEntry)e.nextElement();
            originalEntry = entry.getOriginal();
            copyEntry = entry.getCopy();
            if (!originalEntry.getPath().equals(logEntry.getOriginal().getPath()) || !copyEntry.getPath().equals(logEntry.getCopy().getPath())) continue;
            found = true;
        }
        if (found) {
            return this.logEntries;
        }
        this.logEntries.add(logEntry);
        this.saveEntries();
        return this.logEntries;
    }

    public synchronized Vector<LogEntry> addEntry(File original, File copy) throws DeployerLogException {
        if (this.logEntries == null) {
            throw new DeployerLogException("Can not add an entry, the vector is null");
        }
        LogEntryImpl logEntry = new LogEntryImpl(original, copy);
        return this.addEntry(logEntry);
    }

    @Override
    public LogEntry getEntry(File original) {
        for (LogEntry logEntry : this.logEntries) {
            if (!logEntry.getOriginal().equals(original)) continue;
            return logEntry;
        }
        return null;
    }
}

