/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.joram.admin;

import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.ipojo.annotations.Validate;
import org.objectweb.joram.client.connector.JoramAdapterMBean;
import org.objectweb.joram.client.jms.QueueMBean;
import org.osgi.framework.ServiceReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component(name="JoramQueue", immediate=false)
public class JoramQueue
implements Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(JoramQueue.class);
    private boolean __FjndiName;
    @Property(name="jndi.name", mandatory=true)
    private String jndiName;
    private boolean __Fservice;
    @Requires
    private JoramAdapterMBean service;
    private boolean __Fqueue;
    private QueueMBean queue;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MbindQueueService$org_objectweb_joram_client_jms_QueueMBean$org_osgi_framework_ServiceReference;
    private boolean __MunbindQueueService$org_osgi_framework_ServiceReference;

    String __getjndiName() {
        if (!this.__FjndiName) {
            return this.jndiName;
        }
        return (String)this.__IM.onGet((Object)this, "jndiName");
    }

    void __setjndiName(String string) {
        if (!this.__FjndiName) {
            this.jndiName = string;
            return;
        }
        this.__IM.onSet((Object)this, "jndiName", (Object)string);
    }

    JoramAdapterMBean __getservice() {
        if (!this.__Fservice) {
            return this.service;
        }
        return (JoramAdapterMBean)this.__IM.onGet((Object)this, "service");
    }

    void __setservice(JoramAdapterMBean joramAdapterMBean) {
        if (!this.__Fservice) {
            this.service = joramAdapterMBean;
            return;
        }
        this.__IM.onSet((Object)this, "service", (Object)joramAdapterMBean);
    }

    QueueMBean __getqueue() {
        if (!this.__Fqueue) {
            return this.queue;
        }
        return (QueueMBean)this.__IM.onGet((Object)this, "queue");
    }

    void __setqueue(QueueMBean queueMBean) {
        if (!this.__Fqueue) {
            this.queue = queueMBean;
            return;
        }
        this.__IM.onSet((Object)this, "queue", (Object)queueMBean);
    }

    public JoramQueue() {
        this(null);
    }

    private JoramQueue(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Validate
    private void __start() {
        ClassLoader old = null;
        try {
            ClassLoader ext = this.getClass().getClassLoader();
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ext);
            String res = this.__getservice().createQueue(this.__getjndiName());
            logger.info((Object)("Create the queue '" + this.__getjndiName() + "' : " + res), new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)("Error when creating the queue '" + this.__getjndiName() + "'"), new Object[]{e});
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
        try {
            if (this.__getqueue() != null) {
                this.__getqueue().delete();
                logger.info((Object)("Remove the queue '" + this.__getjndiName() + "'"), new Object[0]);
            } else {
                logger.warn((Object)("Unable to remove the queue service '" + this.__getjndiName() + "'. Service unavailable"), new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error when removing the queue '" + this.__getjndiName() + "'"), new Object[]{e});
        }
    }

    public void bindQueueService(QueueMBean queueMBean, ServiceReference serviceReference) {
        if (!this.__MbindQueueService$org_objectweb_joram_client_jms_QueueMBean$org_osgi_framework_ServiceReference) {
            this.__bindQueueService(queueMBean, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindQueueService$org_objectweb_joram_client_jms_QueueMBean$org_osgi_framework_ServiceReference", new Object[]{queueMBean, serviceReference});
            this.__bindQueueService(queueMBean, serviceReference);
            this.__IM.onExit((Object)this, "bindQueueService$org_objectweb_joram_client_jms_QueueMBean$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindQueueService$org_objectweb_joram_client_jms_QueueMBean$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Bind(optional=true, aggregate=true)
    private void __bindQueueService(QueueMBean service, ServiceReference ref) {
        String serviceName = (String)ref.getProperty("name");
        if (serviceName.startsWith(this.__getjndiName() + "[#")) {
            this.__setqueue(service);
            logger.debug((Object)("Bind QueueService - " + serviceName), new Object[0]);
        }
    }

    public void unbindQueueService(ServiceReference serviceReference) {
        if (!this.__MunbindQueueService$org_osgi_framework_ServiceReference) {
            this.__unbindQueueService(serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindQueueService$org_osgi_framework_ServiceReference", new Object[]{serviceReference});
            this.__unbindQueueService(serviceReference);
            this.__IM.onExit((Object)this, "unbindQueueService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindQueueService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Unbind
    private void __unbindQueueService(ServiceReference ref) {
        String name = (String)ref.getProperty("name");
        if (name.startsWith(this.__getjndiName() + "[#")) {
            this.__setqueue(null);
            logger.debug((Object)("Unbind Service - " + name), new Object[0]);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("queue")) {
                this.__Fqueue = true;
            }
            if (set.contains("service")) {
                this.__Fservice = true;
            }
            if (set.contains("jndiName")) {
                this.__FjndiName = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("bindQueueService$org_objectweb_joram_client_jms_QueueMBean$org_osgi_framework_ServiceReference")) {
                this.__MbindQueueService$org_objectweb_joram_client_jms_QueueMBean$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("unbindQueueService$org_osgi_framework_ServiceReference")) {
                this.__MunbindQueueService$org_osgi_framework_ServiceReference = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

