/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.configadmin.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.ow2.jonas.configadmin.internal.ConfigAdminDeployable;
import org.ow2.jonas.configadmin.internal.model.Configadmin;
import org.ow2.jonas.configadmin.internal.model.ConfigurationType;
import org.ow2.jonas.configadmin.internal.model.ObjectFactory;
import org.ow2.jonas.configadmin.internal.model.PropertyType;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployerList;
import org.ow2.util.file.FileUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigAdminDeployer
extends AbsDeployerList<ConfigAdminDeployable> {
    private InstanceManager __IM;
    private static final Log logger = LogFactory.getLog(ConfigAdminDeployer.class);
    private boolean __FconfigAdmin;
    private ConfigurationAdmin configAdmin;
    private boolean __Fcontext;
    private JAXBContext context;
    private boolean __Fstore;
    private Map<String, List<Configuration>> store;
    private boolean __Mvalidate;
    private boolean __MregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager;
    private boolean __MunregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager;
    private boolean __MbindConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin;
    private boolean __Mdeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __McreateFactoryConfiguration$org_ow2_jonas_configadmin_internal_model_ConfigurationType;
    private boolean __McreateConfiguration$org_ow2_jonas_configadmin_internal_model_ConfigurationType;
    private boolean __MgetUrl$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __Mundeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MisDeployed$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __Msupports$org_ow2_util_ee_deploy_api_deployable_IDeployable;

    ConfigurationAdmin __getconfigAdmin() {
        if (!this.__FconfigAdmin) {
            return this.configAdmin;
        }
        return (ConfigurationAdmin)this.__IM.onGet((Object)this, "configAdmin");
    }

    void __setconfigAdmin(ConfigurationAdmin configurationAdmin) {
        if (!this.__FconfigAdmin) {
            this.configAdmin = configurationAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "configAdmin", (Object)configurationAdmin);
    }

    JAXBContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (JAXBContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(JAXBContext jAXBContext) {
        if (!this.__Fcontext) {
            this.context = jAXBContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)jAXBContext);
    }

    Map __getstore() {
        if (!this.__Fstore) {
            return this.store;
        }
        return (Map)this.__IM.onGet((Object)this, "store");
    }

    void __setstore(Map map) {
        if (!this.__Fstore) {
            this.store = map;
            return;
        }
        this.__IM.onSet((Object)this, "store", (Object)map);
    }

    public ConfigAdminDeployer() {
        this(null);
    }

    private ConfigAdminDeployer(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void validate() throws Exception {
        if (!this.__Mvalidate) {
            this.__validate();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "validate", new Object[0]);
            this.__validate();
            this.__IM.onExit((Object)this, "validate", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "validate", throwable);
            throw throwable;
        }
    }

    private void __validate() throws Exception {
        this.__setcontext(JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class}));
        this.__setstore(new Hashtable());
    }

    public void registerDeployerManager(IDeployerManager iDeployerManager) {
        if (!this.__MregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager) {
            this.__registerDeployerManager(iDeployerManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "registerDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", new Object[]{iDeployerManager});
            this.__registerDeployerManager(iDeployerManager);
            this.__IM.onExit((Object)this, "registerDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", throwable);
            throw throwable;
        }
    }

    private void __registerDeployerManager(IDeployerManager deployerManager) {
        deployerManager.register((IDeployer)this);
    }

    public void unregisterDeployerManager(IDeployerManager iDeployerManager) {
        if (!this.__MunregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager) {
            this.__unregisterDeployerManager(iDeployerManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", new Object[]{iDeployerManager});
            this.__unregisterDeployerManager(iDeployerManager);
            this.__IM.onExit((Object)this, "unregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", throwable);
            throw throwable;
        }
    }

    private void __unregisterDeployerManager(IDeployerManager deployerManager) {
        deployerManager.unregister((IDeployer)this);
    }

    public void bindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (!this.__MbindConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin) {
            this.__bindConfigurationAdmin(configurationAdmin);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", new Object[]{configurationAdmin});
            this.__bindConfigurationAdmin(configurationAdmin);
            this.__IM.onExit((Object)this, "bindConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", throwable);
            throw throwable;
        }
    }

    private void __bindConfigurationAdmin(ConfigurationAdmin admin) {
        this.__setconfigAdmin(admin);
    }

    public void deploy(IDeployable<ConfigAdminDeployable> iDeployable) throws DeployerException, UnsupportedDeployerException {
        if (!this.__Mdeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this.__deploy(iDeployable);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deploy$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            this.__deploy(iDeployable);
            this.__IM.onExit((Object)this, "deploy$org_ow2_util_ee_deploy_api_deployable_IDeployable", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deploy$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void __deploy(IDeployable<ConfigAdminDeployable> untyped) throws DeployerException, UnsupportedDeployerException {
        ConfigAdminDeployable deployable = (ConfigAdminDeployable)((Object)ConfigAdminDeployable.class.cast(untyped));
        URL url = this.getUrl((IDeployable<?>)deployable);
        logger.info((Object)("Deploying Configurations for " + url), new Object[0]);
        InputStream is = null;
        try {
            Configuration c;
            is = url.openStream();
            StreamSource source = new StreamSource(is);
            Unmarshaller unmarshaller = this.__getcontext().createUnmarshaller();
            JAXBElement element = unmarshaller.unmarshal((Source)source, Configadmin.class);
            Configadmin ca = (Configadmin)element.getValue();
            deployable.setAttachedData(ca);
            ArrayList<Configuration> configurations = new ArrayList<Configuration>();
            for (ConfigurationType configuration : ca.getConfigurations()) {
                c = this.createConfiguration(configuration);
                if (c == null) continue;
                configurations.add(c);
            }
            for (ConfigurationType configuration : ca.getFactoryConfigurations()) {
                c = this.createFactoryConfiguration(configuration);
                if (c == null) continue;
                configurations.add(c);
            }
            this.__getstore().put(url.toExternalForm(), configurations);
        }
        catch (IOException e) {
            try {
                throw new DeployerException("Cannot open " + (Object)((Object)deployable), (Throwable)e);
                catch (JAXBException e2) {
                    throw new DeployerException("Cannot unmarshall " + (Object)((Object)deployable), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close((Closeable[])new Closeable[]{is});
                throw throwable;
            }
        }
        FileUtils.close((Closeable[])new Closeable[]{is});
    }

    private Configuration createFactoryConfiguration(ConfigurationType configurationType) {
        Configuration configuration;
        if (!this.__McreateFactoryConfiguration$org_ow2_jonas_configadmin_internal_model_ConfigurationType) {
            return this.__createFactoryConfiguration(configurationType);
        }
        try {
            this.__IM.onEntry((Object)this, "createFactoryConfiguration$org_ow2_jonas_configadmin_internal_model_ConfigurationType", new Object[]{configurationType});
            configuration = this.__createFactoryConfiguration(configurationType);
            this.__IM.onExit((Object)this, "createFactoryConfiguration$org_ow2_jonas_configadmin_internal_model_ConfigurationType", (Object)configuration);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createFactoryConfiguration$org_ow2_jonas_configadmin_internal_model_ConfigurationType", throwable);
            throw throwable;
        }
        return configuration;
    }

    private Configuration __createFactoryConfiguration(ConfigurationType configuration) {
        try {
            String servicePid = configuration.getPid();
            logger.debug((Object)("Create FactoryConfiguration for " + servicePid), new Object[0]);
            Configuration c = this.__getconfigAdmin().createFactoryConfiguration(servicePid, null);
            Properties properties = new Properties();
            for (PropertyType property : configuration.getProperties()) {
                properties.setProperty(property.getName(), property.getValue());
            }
            c.update((Dictionary)properties);
            logger.debug((Object)("Updated Factory" + c), new Object[0]);
            return c;
        }
        catch (IOException e) {
            logger.warn((Object)("Cannot push Factory Configuration " + configuration.getPid()), new Object[]{e});
            return null;
        }
    }

    private Configuration createConfiguration(ConfigurationType configurationType) {
        Configuration configuration;
        if (!this.__McreateConfiguration$org_ow2_jonas_configadmin_internal_model_ConfigurationType) {
            return this.__createConfiguration(configurationType);
        }
        try {
            this.__IM.onEntry((Object)this, "createConfiguration$org_ow2_jonas_configadmin_internal_model_ConfigurationType", new Object[]{configurationType});
            configuration = this.__createConfiguration(configurationType);
            this.__IM.onExit((Object)this, "createConfiguration$org_ow2_jonas_configadmin_internal_model_ConfigurationType", (Object)configuration);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createConfiguration$org_ow2_jonas_configadmin_internal_model_ConfigurationType", throwable);
            throw throwable;
        }
        return configuration;
    }

    private Configuration __createConfiguration(ConfigurationType configuration) {
        try {
            String servicePid = configuration.getPid();
            logger.debug((Object)("Create Configuration for " + servicePid), new Object[0]);
            Configuration c = this.__getconfigAdmin().getConfiguration(servicePid, null);
            Dictionary dict = c.getProperties();
            if (dict == null) {
                dict = new Properties();
            }
            for (PropertyType property : configuration.getProperties()) {
                dict.put(property.getName(), property.getValue());
            }
            if (c.getBundleLocation() != null) {
                c.setBundleLocation(null);
            }
            c.update(dict);
            logger.debug((Object)("Updated " + c), new Object[0]);
            return c;
        }
        catch (IOException e) {
            logger.warn((Object)("Cannot push Configuration " + configuration.getPid()), new Object[]{e});
            return null;
        }
    }

    private URL getUrl(IDeployable<?> iDeployable) throws DeployerException {
        URL uRL;
        if (!this.__MgetUrl$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            return this.__getUrl(iDeployable);
        }
        try {
            this.__IM.onEntry((Object)this, "getUrl$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            uRL = this.__getUrl(iDeployable);
            this.__IM.onExit((Object)this, "getUrl$org_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)uRL);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getUrl$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
        return uRL;
    }

    private URL __getUrl(IDeployable<?> deployable) throws DeployerException {
        URL url;
        try {
            url = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL of " + deployable, (Throwable)e);
        }
        return url;
    }

    public void undeploy(IDeployable<ConfigAdminDeployable> iDeployable) throws DeployerException {
        if (!this.__Mundeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this.__undeploy(iDeployable);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "undeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            this.__undeploy(iDeployable);
            this.__IM.onExit((Object)this, "undeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "undeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
    }

    private void __undeploy(IDeployable<ConfigAdminDeployable> deployable) throws DeployerException {
        URL url = this.getUrl(deployable);
        logger.info((Object)("Undeploying Configurations for " + url), new Object[0]);
        List configurations = (List)this.__getstore().remove(url.toExternalForm());
        for (Configuration configuration : configurations) {
            try {
                configuration.delete();
            }
            catch (Exception e) {
                logger.warn((Object)("Cannot delete Configuration " + configuration), new Object[]{e});
            }
        }
    }

    public boolean isDeployed(IDeployable<ConfigAdminDeployable> iDeployable) throws DeployerException {
        boolean bl;
        if (!this.__MisDeployed$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            return this.__isDeployed(iDeployable);
        }
        try {
            this.__IM.onEntry((Object)this, "isDeployed$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            bl = this.__isDeployed(iDeployable);
            this.__IM.onExit((Object)this, "isDeployed$org_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isDeployed$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isDeployed(IDeployable<ConfigAdminDeployable> deployable) throws DeployerException {
        return this.__getstore().containsKey(this.getUrl(deployable).toExternalForm());
    }

    public boolean supports(IDeployable<?> iDeployable) {
        boolean bl;
        if (!this.__Msupports$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            return this.__supports(iDeployable);
        }
        try {
            this.__IM.onEntry((Object)this, "supports$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            bl = this.__supports(iDeployable);
            this.__IM.onExit((Object)this, "supports$org_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "supports$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __supports(IDeployable<?> deployable) {
        return ConfigAdminDeployable.class.isAssignableFrom(deployable.getClass());
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("store")) {
                this.__Fstore = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("configAdmin")) {
                this.__FconfigAdmin = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("validate")) {
                this.__Mvalidate = true;
            }
            if (set.contains("registerDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager")) {
                this.__MregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager = true;
            }
            if (set.contains("unregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager")) {
                this.__MunregisterDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager = true;
            }
            if (set.contains("bindConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin")) {
                this.__MbindConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin = true;
            }
            if (set.contains("deploy$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__Mdeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("createFactoryConfiguration$org_ow2_jonas_configadmin_internal_model_ConfigurationType")) {
                this.__McreateFactoryConfiguration$org_ow2_jonas_configadmin_internal_model_ConfigurationType = true;
            }
            if (set.contains("createConfiguration$org_ow2_jonas_configadmin_internal_model_ConfigurationType")) {
                this.__McreateConfiguration$org_ow2_jonas_configadmin_internal_model_ConfigurationType = true;
            }
            if (set.contains("getUrl$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MgetUrl$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("undeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__Mundeploy$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("isDeployed$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MisDeployed$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("supports$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__Msupports$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

