/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.pool;

import javax.jms.Connection;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.pool.ConnectionPool;
import org.objectweb.joram.client.jms.pool.PooledConnection;

public class PooledConnectionFactory
implements javax.jms.ConnectionFactory {
    ConnectionFactory cf;
    ConnectionPool pool;
    int maxFreeConnections;

    public ConnectionFactory getConnectionFactory() {
        return this.cf;
    }

    public int getMaxFreeConnections() {
        return this.maxFreeConnections;
    }

    public void setMaxFreeConnections(int maxFreeConnections) {
        this.maxFreeConnections = maxFreeConnections;
    }

    public PooledConnectionFactory(javax.jms.ConnectionFactory cf) {
        this(cf, 10);
    }

    public PooledConnectionFactory(javax.jms.ConnectionFactory cf, int maxFreeConnections) {
        try {
            this.cf = (ConnectionFactory)cf;
            this.maxFreeConnections = maxFreeConnections;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Only Joram ConnectionFactory can be pooled");
        }
    }

    public Connection createConnection() throws JMSException {
        PooledConnectionFactory pooledConnectionFactory = this;
        PooledConnectionFactory pooledConnectionFactory2 = this;
        return this.createConnection(pooledConnectionFactory.cf.getDefaultLogin(), pooledConnectionFactory2.cf.getDefaultPassword());
    }

    public synchronized Connection createConnection(String name, String password) throws JMSException {
        PooledConnection cnx;
        if (this.pool == null) {
            this.pool = this.createConnectionPool(this.maxFreeConnections);
        }
        if ((cnx = this.pool.alloc(name, password)) == null) {
            cnx = new PooledConnection(this, name, password);
        }
        return cnx;
    }

    synchronized void free(PooledConnection cnx) throws JMSException {
        this.pool.free(cnx);
    }

    protected ConnectionPool createConnectionPool(int maxFreeConnections) {
        return new ConnectionPool(maxFreeConnections);
    }
}

