/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.internal.lock.impl;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.internal.lock.api.ISignalClearableCondition;
import org.ow2.util.pool.impl.enhanced.internal.lock.impl.Entry;
import org.ow2.util.pool.impl.enhanced.internal.lock.impl.ILockWithSignalClearableConditionControl;
import org.ow2.util.pool.impl.enhanced.internal.lock.impl.ISignalClearableConditionControl;
import org.ow2.util.pool.impl.enhanced.internal.lock.impl.UnparkResult;

public class BasicCondition
implements ISignalClearableCondition {
    private static final Log LOG = LogFactory.getLog(BasicCondition.class);
    private final ILockWithSignalClearableConditionControl lockControl;
    private Entry headUnsignaled;
    private Entry queueUnsignaled;
    private Entry headSignaled;
    private Entry queueUnclearableSignaled;
    private Entry queueSignaled;
    private volatile Thread effectivelySignaledThread;
    private ISignalClearableConditionControl signalClearableConditionControl = new ISignalClearableConditionControl(){

        public UnparkResult unparkOneThread() {
            Entry unparked;
            if (BasicCondition.this.effectivelySignaledThread != null) {
                return UnparkResult.ALREADY_SIGNALED;
            }
            do {
                if ((unparked = BasicCondition.this.headSignaled) == null) {
                    return UnparkResult.NOTHING_TO_SIGNAL;
                }
                if (unparked == BasicCondition.this.queueUnclearableSignaled) {
                    BasicCondition.this.queueUnclearableSignaled = null;
                }
                BasicCondition.this.headSignaled = unparked.getNext();
                if (BasicCondition.this.headSignaled != null) continue;
                BasicCondition.this.queueSignaled = null;
                BasicCondition.this.queueUnclearableSignaled = null;
            } while (unparked.isInterrupted());
            BasicCondition.this.effectivelySignaledThread = unparked.getThread();
            LockSupport.unpark(BasicCondition.this.effectivelySignaledThread);
            if (BasicCondition.this.headSignaled == null) {
                return UnparkResult.SIGNALED_NO_MORE_THEAD;
            }
            return UnparkResult.SIGNALED;
        }
    };

    public BasicCondition(ILockWithSignalClearableConditionControl lockControl) {
        this.lockControl = lockControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean await(Long untilLong) throws InterruptedException {
        boolean notTimeout = true;
        this.lockControl.checkOwner();
        long until = 0L;
        if (untilLong != null) {
            until = untilLong;
        }
        Thread current = Thread.currentThread();
        Entry next = new Entry(current);
        if (this.queueUnsignaled == null) {
            this.headUnsignaled = next;
        } else {
            this.queueUnsignaled.setNext(next);
        }
        this.queueUnsignaled = next;
        this.lockControl.innerUnlock();
        try {
            boolean ended = false;
            do {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (untilLong == null) {
                    LockSupport.park();
                    if (this.effectivelySignaledThread != current) continue;
                    ended = true;
                    continue;
                }
                LockSupport.parkUntil(until);
                if (this.effectivelySignaledThread == current) {
                    ended = true;
                    continue;
                }
                if (System.currentTimeMillis() <= until) continue;
                notTimeout = false;
                ended = true;
            } while (!ended);
            Object var9_7 = null;
            this.lockControl.innerLock(null);
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.lockControl.innerLock(null);
            if (this.effectivelySignaledThread == current) {
                this.effectivelySignaledThread = null;
                throw throwable;
            } else {
                next.setInterrupted(true);
            }
            throw throwable;
        }
        if (this.effectivelySignaledThread == current) {
            this.effectivelySignaledThread = null;
            return notTimeout;
        }
        next.setInterrupted(true);
        return notTimeout;
    }

    public void signalAll() {
        this.lockControl.checkOwner();
        if (this.headUnsignaled != null) {
            if (this.queueSignaled == null) {
                this.headSignaled = this.headUnsignaled;
            } else {
                this.queueSignaled.setNext(this.headUnsignaled);
            }
            this.queueSignaled = this.queueUnsignaled;
            this.headUnsignaled = null;
            this.queueUnsignaled = null;
            this.lockControl.askForUnparkOneThread(this.signalClearableConditionControl);
        }
    }

    public void signalAllUnclearable() {
        this.lockControl.checkOwner();
        if (this.headUnsignaled != null) {
            if (this.queueSignaled == null) {
                this.headSignaled = this.headUnsignaled;
            } else {
                this.queueSignaled.setNext(this.headUnsignaled);
            }
            this.queueSignaled = this.queueUnsignaled;
            this.headUnsignaled = null;
            this.queueUnsignaled = null;
            this.lockControl.askForUnparkOneThread(this.signalClearableConditionControl);
        }
        this.queueUnclearableSignaled = this.queueSignaled;
    }

    public void signal() {
        this.lockControl.checkOwner();
        if (this.headUnsignaled != null) {
            Entry signaledEntry = this.headUnsignaled;
            if (this.queueSignaled == null) {
                this.headSignaled = signaledEntry;
            } else {
                this.queueSignaled.setNext(signaledEntry);
            }
            this.queueSignaled = signaledEntry;
            this.headUnsignaled = signaledEntry.getNext();
            if (this.headUnsignaled == null) {
                this.queueUnsignaled = null;
            }
            signaledEntry.setNext(null);
            this.lockControl.askForUnparkOneThread(this.signalClearableConditionControl);
        }
    }

    public void clearAllSignal() {
        this.lockControl.checkOwner();
        LOG.debug((Object)"clearAllSignal", new Object[0]);
        if (this.headSignaled != null) {
            Entry unsignaledEntry;
            if (this.queueUnclearableSignaled != null) {
                unsignaledEntry = this.queueUnclearableSignaled.getNext();
                this.queueUnclearableSignaled.setNext(null);
            } else {
                unsignaledEntry = this.headSignaled;
                this.headSignaled = null;
                this.lockControl.avoidAskForUnparkOneThread(this.signalClearableConditionControl);
            }
            Entry oldQueueSignaled = this.queueSignaled;
            this.queueSignaled = this.queueUnclearableSignaled;
            if (unsignaledEntry != null) {
                oldQueueSignaled.setNext(this.headUnsignaled);
                this.headUnsignaled = unsignaledEntry;
                this.queueUnclearableSignaled = null;
            }
        }
    }

    public void await() throws InterruptedException {
        this.await(null);
    }

    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        long millisTimeout = unit.toMillis(time);
        if (millisTimeout <= 0L) {
            return false;
        }
        return this.await(System.currentTimeMillis() + millisTimeout);
    }

    public long awaitNanos(long nanosTimeout) throws InterruptedException {
        long lastTime = System.nanoTime();
        long millisTimeout = TimeUnit.MILLISECONDS.convert(nanosTimeout, TimeUnit.NANOSECONDS) + 1L;
        this.await(System.currentTimeMillis() + millisTimeout);
        return nanosTimeout - (System.nanoTime() - lastTime);
    }

    public void awaitUninterruptibly() {
        boolean success = true;
        do {
            try {
                this.await(null);
            }
            catch (InterruptedException e) {
                success = false;
            }
        } while (!success);
    }

    public boolean awaitUntil(Date deadline) throws InterruptedException {
        return this.await(deadline.getTime());
    }
}

