/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.catalina.Role;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.AbstractGroup;
import org.apache.catalina.users.MemoryUser;
import org.apache.catalina.users.MemoryUserDatabase;

public class MemoryGroup
extends AbstractGroup {
    protected MemoryUserDatabase database = null;
    protected ArrayList roles = new ArrayList();

    MemoryGroup(MemoryUserDatabase database, String groupname, String description) {
        this.database = database;
        this.setGroupname(groupname);
        this.setDescription(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getRoles() {
        ArrayList arrayList = this.roles;
        synchronized (arrayList) {
            return this.roles.iterator();
        }
    }

    public UserDatabase getUserDatabase() {
        return this.database;
    }

    public Iterator getUsers() {
        ArrayList<MemoryUser> results = new ArrayList<MemoryUser>();
        Iterator users = this.database.getUsers();
        while (users.hasNext()) {
            MemoryUser user = (MemoryUser)users.next();
            if (!user.isInGroup(this)) continue;
            results.add(user);
        }
        return results.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRole(Role role) {
        ArrayList arrayList = this.roles;
        synchronized (arrayList) {
            if (!this.roles.contains(role)) {
                this.roles.add(role);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInRole(Role role) {
        ArrayList arrayList = this.roles;
        synchronized (arrayList) {
            return this.roles.contains(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRole(Role role) {
        ArrayList arrayList = this.roles;
        synchronized (arrayList) {
            this.roles.remove(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoles() {
        ArrayList arrayList = this.roles;
        synchronized (arrayList) {
            this.roles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer("<group groupname=\"");
        sb.append(this.groupname);
        sb.append("\"");
        if (this.description != null) {
            sb.append(" description=\"");
            sb.append(this.description);
            sb.append("\"");
        }
        ArrayList arrayList = this.roles;
        synchronized (arrayList) {
            if (this.roles.size() > 0) {
                sb.append(" roles=\"");
                int n = 0;
                Iterator values = this.roles.iterator();
                while (values.hasNext()) {
                    if (n > 0) {
                        sb.append(',');
                    }
                    ++n;
                    sb.append(((Role)values.next()).getRolename());
                }
                sb.append("\"");
            }
        }
        sb.append("/>");
        return sb.toString();
    }
}

