/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.maven.plugin.mergeproperties.core;

import java.util.List;
import java.util.regex.Pattern;
import org.ow2.util.maven.plugin.mergeproperties.core.FilteringStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusiveStrategy
implements FilteringStrategy {
    private String key;
    private Pattern pattern;
    private static final String EOL = "\n";

    @Override
    public String execute(String key, List<String> values, String separator) {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            if (i == 0) {
                line.append(key).append(separator).append(values.get(i));
                if (i >= values.size() - 1) continue;
                line.append(EOL);
                continue;
            }
            if (i < values.size() - 1) {
                line.append("#").append(key).append(separator).append(values.get(i)).append(EOL);
                continue;
            }
            line.append("#").append(key).append(separator).append(values.get(i));
        }
        return line.toString();
    }

    @Override
    public void initPattern() {
        this.pattern = Pattern.compile(this.key);
    }

    @Override
    public boolean matchPattern(String s) {
        return this.pattern.matcher(s).matches();
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }
}

