/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.maven.plugin.mergeproperties.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.maven.plugin.mergeproperties.core.AggregateStrategy;
import org.ow2.util.maven.plugin.mergeproperties.core.ExclusiveStrategy;
import org.ow2.util.maven.plugin.mergeproperties.core.Marker;
import org.ow2.util.maven.plugin.mergeproperties.core.Preferences;
import org.ow2.util.maven.plugin.mergeproperties.core.Resource;
import org.ow2.util.maven.plugin.mergeproperties.core.ResourceOrderPreference;
import org.ow2.util.maven.plugin.mergeproperties.core.ResourceOrderPreferenceComparator;
import org.ow2.util.maven.plugin.mergeproperties.core.Strategies;
import org.ow2.util.maven.plugin.mergeproperties.core.SubsequenceKeyOccurrence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeProperties {
    private Resource masterResource;
    private List<Resource> templateResources;
    private List<Resource> propertiesResources;
    private String outputFile;
    private Strategies strategies;
    private Preferences preferences;
    private List<Marker> markers;
    private List<ResourceOrderPreference> resourceOrderPreferences;
    private static final String EOL = "\n";
    private Log logger = LogFactory.getLog(this.getClass());

    public Marker getMarker(List<Marker> markers, String key) {
        int i;
        for (i = 0; i < markers.size() && !markers.get(i).getKey().equals(key); ++i) {
        }
        if (i < markers.size() && markers.get(i).getKey().equals(key)) {
            return markers.get(i);
        }
        return null;
    }

    public boolean isMarkersContainKey(String key) {
        int i;
        for (i = 0; i < this.markers.size() && !this.markers.get(i).getKey().equals(key); ++i) {
        }
        return i < this.markers.size();
    }

    private void sortFileOrderPreferences() {
        Collections.sort(this.resourceOrderPreferences, new ResourceOrderPreferenceComparator());
    }

    public StringTokenizer getStringTokenizer(String line) {
        if (line.contains("=")) {
            return new StringTokenizer(line, "=");
        }
        return new StringTokenizer(line, " ");
    }

    public void check() throws Exception {
        if (this.masterResource == null) {
            throw new Exception("Master resource is not set");
        }
        if (this.templateResources == null) {
            throw new Exception("Template resources are not set");
        }
        if (this.outputFile == null) {
            throw new Exception("Output file is not set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws Exception {
        BufferedReader br = null;
        this.check();
        ArrayList<Resource> templates = new ArrayList<Resource>();
        templates.add(this.masterResource);
        templates.addAll(this.templateResources);
        this.markers = new ArrayList<Marker>();
        ArrayList<Marker> properties = new ArrayList<Marker>();
        ExclusiveStrategy defaultStrategy = new ExclusiveStrategy();
        ArrayList<SubsequenceKeyOccurrence> subsequenceKeyOccurences = new ArrayList<SubsequenceKeyOccurrence>();
        this.resourceOrderPreferences = new ArrayList<ResourceOrderPreference>();
        subsequenceKeyOccurences.add(new SubsequenceKeyOccurrence(0));
        if (this.preferences != null) {
            List<String> patterns = this.preferences.getFileOrderPreferences();
            int i = 1;
            if (patterns != null) {
                for (String pattern : patterns) {
                    subsequenceKeyOccurences.add(new SubsequenceKeyOccurrence(i, pattern));
                    ++i;
                }
            }
        }
        try {
            Object values;
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.addAll(templates);
            if (this.propertiesResources != null) {
                resources.addAll(this.propertiesResources);
            }
            for (Resource resource : resources) {
                int i;
                SubsequenceKeyOccurrence subsequenceKeyOccurrence2;
                br = resource.getBufferedReader();
                String key = null;
                String value = null;
                for (SubsequenceKeyOccurrence subsequenceKeyOccurrence2 : subsequenceKeyOccurences) {
                    subsequenceKeyOccurrence2.initHashMap();
                }
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        StringTokenizer stringTokenizer = this.getStringTokenizer(line);
                        if (stringTokenizer.hasMoreElements()) {
                            key = stringTokenizer.nextElement().toString();
                            if (key.charAt(0) == '%') {
                                if (!key.endsWith("%")) {
                                    throw new Exception("Resource " + resource.getName() + "- Marker " + key + " is not valid");
                                }
                                key = key.substring(1, key.length() - 1);
                                this.markers.add(new Marker(key));
                            } else if (stringTokenizer.hasMoreElements()) {
                                Marker marker;
                                value = stringTokenizer.nextElement().toString();
                                if (key.charAt(0) != '#') {
                                    Marker property = this.getMarker(properties, key);
                                    if (property != null) {
                                        property.addValue(value);
                                    } else {
                                        property = new Marker(key);
                                        property.addValue(value);
                                        if (line.contains("=")) {
                                            property.setSeparator("=");
                                        } else {
                                            property.setSeparator("    ");
                                        }
                                        properties.add(property);
                                    }
                                }
                                if ((marker = this.getMarker(this.markers, key)) != null) {
                                    if (marker.getSeparator() == null) {
                                        if (line.contains("=")) {
                                            marker.setSeparator("=");
                                        } else {
                                            marker.setSeparator("    ");
                                        }
                                    }
                                    marker.addValue(value);
                                }
                            }
                            if (key.charAt(0) != '#') {
                                for (SubsequenceKeyOccurrence subsequenceKeyOccurrence3 : subsequenceKeyOccurences) {
                                    subsequenceKeyOccurrence3.addSubKeys(key);
                                }
                            }
                        }
                        if (!line.contains("\\")) continue;
                        while ((line = br.readLine()) != null && line.contains("\\")) {
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)"Cannot read line.", new Object[]{e});
                }
                for (i = subsequenceKeyOccurences.size() - 1; i >= 0 && ((SubsequenceKeyOccurrence)subsequenceKeyOccurences.get(i)).getHashMapSubKeyOcc().isEmpty(); --i) {
                }
                if (i < 0) continue;
                subsequenceKeyOccurrence2 = (SubsequenceKeyOccurrence)subsequenceKeyOccurences.get(i);
                subsequenceKeyOccurrence2.sortHashMap(SubsequenceKeyOccurrence.OrderType.DESC);
                Iterator<String> it = subsequenceKeyOccurrence2.getHashMapSubKeyOcc().keySet().iterator();
                int subKeyOccPriority = subsequenceKeyOccurrence2.getPriority();
                int fileOrderPriority = subKeyOccPriority == 0 ? subKeyOccPriority : subsequenceKeyOccurences.size() - subKeyOccPriority;
                String mostCommonSubKey = it.next();
                this.resourceOrderPreferences.add(new ResourceOrderPreference(fileOrderPriority, resource, mostCommonSubKey));
                this.logger.debug((Object)("Resource: " + resource.getName() + " | priority: " + fileOrderPriority + " | mostCommonSubKey:" + mostCommonSubKey + EOL), new Object[0]);
            }
            this.sortFileOrderPreferences();
            if (this.preferences != null) {
                this.preferences.initPatterns();
            }
            if (this.strategies != null) {
                this.strategies.initPatterns();
                this.logger.debug((Object)"AggregateStrategies:", new Object[0]);
                List<AggregateStrategy> aggregateStrategies = this.strategies.getAggregateStrategies();
                if (aggregateStrategies != null && !aggregateStrategies.isEmpty()) {
                    for (AggregateStrategy aggregateStrategy : aggregateStrategies) {
                        this.logger.debug((Object)(aggregateStrategy.getKey() + " " + aggregateStrategy.getPattern()), new Object[0]);
                    }
                } else if (aggregateStrategies == null) {
                    this.logger.debug((Object)"aggregateStrategies is null", new Object[0]);
                } else {
                    this.logger.debug((Object)"aggregateStrategies is empty", new Object[0]);
                }
            } else {
                this.logger.debug((Object)"strategies is null", new Object[0]);
            }
            this.logger.debug((Object)(EOL + EOL + EOL + "(FILES,PRIORITY,MOST_COMMON_SUB_SEQUENCE)"), new Object[0]);
            for (ResourceOrderPreference resourceOrderPreference : this.resourceOrderPreferences) {
                this.logger.debug((Object)("(" + resourceOrderPreference.getResource().getName() + "," + resourceOrderPreference.getPriority() + "," + resourceOrderPreference.getMostCommonSubKey() + ")"), new Object[0]);
            }
            for (Marker property : properties) {
                if (property.getValues().size() <= 1 || this.getMarker(this.markers, property.getKey()) != null) continue;
                values = property.getValues();
                ArrayList valuesToRemove = new ArrayList();
                for (int i = 0; i < values.size() - 1; ++i) {
                    for (int y = i + 1; y < values.size(); ++y) {
                        if (i == y || !((String)values.get(i)).equals(values.get(y))) continue;
                        valuesToRemove.add(values.get(i));
                    }
                }
                for (String valueToRemove : valuesToRemove) {
                    values.remove(valueToRemove);
                }
                this.markers.add(property);
            }
            this.logger.debug((Object)("Markers: " + this.markers.size()), new Object[0]);
            for (Marker marker : this.markers) {
                values = "";
                Iterator it = marker.getValues().iterator();
                if (!it.hasNext()) continue;
                while (it.hasNext()) {
                    values = (String)values + "," + it.next();
                }
                this.logger.debug((Object)(marker.getKey() + marker.getSeparator() + ((String)values).subSequence(1, ((String)values).length())), new Object[0]);
            }
            BufferedWriter bw = null;
            try {
                File outputFile = new File(this.outputFile);
                File parent = outputFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                bw = new BufferedWriter(new FileWriter(outputFile));
                for (ResourceOrderPreference resourceOrderPreference : this.resourceOrderPreferences) {
                    String line = null;
                    String key = null;
                    boolean eol = false;
                    this.logger.debug((Object)("Resource name == " + resourceOrderPreference.getResource().getName()), new Object[0]);
                    Resource resource = resourceOrderPreference.getResource();
                    try {
                        br = resource.getBufferedReader();
                        while ((line = br.readLine()) != null) {
                            StringTokenizer stringTockenizer = this.getStringTokenizer(line);
                            if (stringTockenizer.hasMoreElements()) {
                                Marker marker;
                                key = stringTockenizer.nextElement().toString();
                                if (key.charAt(0) == '%') {
                                    key = key.substring(1, key.length() - 1);
                                }
                                if ((marker = this.getMarker(this.markers, key)) != null) {
                                    if (!marker.isWrite()) {
                                        List<String> values2 = this.preferences == null ? marker.getValues() : this.preferences.applyPreferences(marker);
                                        line = this.strategies != null ? this.strategies.execute(key, values2, marker.getSeparator(), defaultStrategy) : defaultStrategy.execute(key, values2, marker.getSeparator());
                                        marker.setWrite(true);
                                    } else {
                                        line = null;
                                    }
                                }
                            }
                            if (line == null) continue;
                            bw.write(line + EOL);
                            if (eol) continue;
                            eol = true;
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new Exception("Cannot find the resource '" + resourceOrderPreference.getResource().getName() + "'.", e);
                    }
                    catch (IOException e) {
                        throw new Exception("Cannot read line.", e);
                    }
                    try {
                        if (!eol) continue;
                        bw.write(EOL);
                    }
                    catch (IOException e) {
                        throw new Exception("Cannot write line into the buffered writer.", e);
                        return;
                    }
                }
            }
            catch (IOException e) {
                throw new Exception("Cannot create the file '" + this.outputFile + "'.", e);
            }
            finally {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    throw new Exception("Cannot close buffered writer.", e);
                }
            }
        }
        finally {
            this.masterResource.close();
            for (Resource resource : this.templateResources) {
                resource.close();
            }
            if (this.propertiesResources != null) {
                for (Resource resource : this.propertiesResources) {
                    resource.close();
                }
            }
        }
    }

    public void setMasterResource(Resource masterResource) {
        this.masterResource = masterResource;
    }

    public void setTemplateResources(List<Resource> templateResources) {
        this.templateResources = templateResources;
    }

    public void setPropertiesResources(List<Resource> propertiesResources) {
        this.propertiesResources = propertiesResources;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setStrategies(Strategies strategies) {
        this.strategies = strategies;
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }
}

