/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.maven.plugin.mergeproperties.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ow2.util.maven.plugin.mergeproperties.core.AggregateStrategy;
import org.ow2.util.maven.plugin.mergeproperties.core.ExclusiveStrategy;
import org.ow2.util.maven.plugin.mergeproperties.core.FilteringStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Strategies {
    private ExclusiveStrategy[] exclusiveStrategies;
    private List<ExclusiveStrategy> exclusiveStrategiesList;
    private AggregateStrategy[] aggregateStrategies;
    private List<AggregateStrategy> aggregateStrategiesList;

    public String execute(String key, List<String> values, String separator, FilteringStrategy defaultStrategy) throws Exception {
        int i;
        String property = null;
        if (this.aggregateStrategiesList != null) {
            for (i = 0; i < this.aggregateStrategiesList.size() && !this.aggregateStrategiesList.get(i).matchPattern(key); ++i) {
            }
            if (i < this.aggregateStrategiesList.size() && this.aggregateStrategiesList.get(i).matchPattern(key)) {
                property = this.aggregateStrategiesList.get(i).execute(key, values, separator);
            }
        }
        if (property == null && this.exclusiveStrategiesList != null) {
            for (i = 0; i < this.exclusiveStrategiesList.size() && !this.exclusiveStrategiesList.get(i).matchPattern(key); ++i) {
            }
            if (i < this.exclusiveStrategiesList.size() && this.exclusiveStrategiesList.get(i).matchPattern(key)) {
                property = this.exclusiveStrategiesList.get(i).execute(key, values, separator);
            }
        }
        if (property == null) {
            return defaultStrategy.execute(key, values, separator);
        }
        return property;
    }

    public List<AggregateStrategy> getAggregateStrategies() {
        return this.aggregateStrategiesList;
    }

    public List<ExclusiveStrategy> getExclusiveStrategies() {
        return this.exclusiveStrategiesList;
    }

    public void setExclusiveStrategies(ExclusiveStrategy[] exclusiveStrategies) {
        this.exclusiveStrategies = exclusiveStrategies;
    }

    public void setAggregateStrategies(AggregateStrategy[] aggregateStrategies) {
        this.aggregateStrategies = aggregateStrategies;
    }

    public void initPatterns() {
        if (this.exclusiveStrategies != null) {
            this.exclusiveStrategiesList = new ArrayList<ExclusiveStrategy>(Arrays.asList(this.exclusiveStrategies));
            for (ExclusiveStrategy exclusiveStrategy : this.exclusiveStrategiesList) {
                exclusiveStrategy.initPattern();
            }
        }
        if (this.aggregateStrategies != null) {
            this.aggregateStrategiesList = new ArrayList<AggregateStrategy>(Arrays.asList(this.aggregateStrategies));
            for (AggregateStrategy aggregateStrategy : this.aggregateStrategiesList) {
                aggregateStrategy.initPattern();
            }
        }
    }
}

