/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cluster.daemon;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Validate;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.jndi.ns.NameServiceException;
import org.ow2.carol.jndi.ns.NameServiceManager;
import org.ow2.jonas.cluster.daemon.ClusterDaemonMBean;
import org.ow2.jonas.cluster.daemon.ClusterDaemonTools;
import org.ow2.jonas.cluster.daemon.CmdReaderThread;
import org.ow2.jonas.cluster.daemon.MonitorThread;
import org.ow2.jonas.cluster.daemon.ShutdownHookThread;
import org.ow2.jonas.cluster.daemon.api.ClusterDaemonException;
import org.ow2.jonas.cluster.daemon.mbean.JMXRemoteException;
import org.ow2.jonas.cluster.daemon.mbean.JMXRemoteHelper;
import org.ow2.jonas.cluster.daemon.mbean.MBeanServerException;
import org.ow2.jonas.cluster.daemon.mbean.MBeanServerHelper;
import org.ow2.jonas.deployment.clusterd.xml.Server;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.discovery.jgroups.JgroupsDiscoveryServiceImpl;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.util.Env;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.windows.WinSysEnv;
import org.ow2.jonas.security.auth.spi.RoleBasedAuthorizationModule;

@Component(immediate=true)
@Provides
public class ClusterDaemon
implements ClusterDaemonMBean {
    public static final int SLEEP_TIME = 2000;
    private static final String TIGHLY_COUPLED = "tighly-coupled";
    private static final String LOOSELY_COUPLED = "loosely-coupled";
    private static final int PING_SHORT_TIMEOUT = 5;
    private static final int PING_LONG_TIMEOUT = 120;
    private static final int PING_SAFETY_TIMEOUT = 2000;
    public static final int SLEEP_DELAY = 2000;
    public static final String LONG_TYPE_DYN_INFO = "long";
    public static final String JONAS_CMD_NAME_WIN_DEF = "jonas.bat";
    public static final String JONAS_CMD_NAME_UNIX_DEF = "jonas";
    public static final String CS_TRACE_FILE_PROPERTY_NAME = "cs.trace.properties.file";
    public static final String CAROL_FILE_PROPERTY_NAME = "carol.properties.file";
    public static final String CONF_FILE_PROPERTY_NAME = "clusterd.conf.file";
    public static final String USE_MONITOR_PROPERTY_NAME = "use.monitor";
    @Property(name="cs.trace.properties.file")
    private String csTraceFile = null;
    @Property(name="carol.properties.file")
    private String carolFile = null;
    @Property(name="clusterd.conf.file")
    private String confFile = null;
    @Property(name="use.monitor")
    private boolean useMonitor = false;
    private static String domainName = null;
    private Logger logger = null;
    private String objectName = null;
    private String name = null;
    private Map processMap = new HashMap();
    private boolean isStarted = false;
    private ArrayList controlledServersNames;
    private String jmxUrl = null;
    private static RuntimeMXBean runtimeMxbean = null;
    private static ClassLoadingMXBean classLoadingMxBean = null;
    private static OperatingSystemMXBean operatingSystemMxBean = null;
    private static ThreadMXBean threadMxBean = null;
    private static CompilationMXBean compilationMxBean = null;
    private static List<GarbageCollectorMXBean> garbageCollectorMXBean = null;
    private static List<MemoryManagerMXBean> memoryManagerMXBean = null;
    private static MemoryMXBean memoryMXBean = null;
    private static List<MemoryPoolMXBean> memoryPoolMXBean = null;
    private static MBeanServer platFormMbeanServer = null;
    private String runTimeSpecVendor = null;
    private String runTimeSpecVersion = null;
    private String runTimeVmName = null;
    private String runTimeVmVendor = null;
    private String runTimeVmVersion = null;
    private String operatingSystemAvailableProcessors = null;
    private String operatingSystemName = null;
    private String operatingSystemVersion = null;
    private String operatingSystemArch = null;
    private Hashtable<String, String> dynamicHostAttributes = null;
    private JgroupsDiscoveryServiceImpl discovery = null;

    public Map getProcessMap() {
        return this.processMap;
    }

    private Process execJOnASCmd(Server server, String cmd, String keyCmd) throws Exception {
        String jettyHome;
        if (server == null) {
            throw new ClusterDaemonException("server=null");
        }
        Process previousP = (Process)this.processMap.get(keyCmd);
        if (previousP != null) {
            try {
                this.logger.log(BasicLevel.INFO, (Object)("Cmd =" + cmd + " Process=" + previousP.exitValue()));
            }
            catch (IllegalThreadStateException exc) {
                this.logger.log(BasicLevel.INFO, (Object)("Cmd =" + cmd + " already running (pid=" + previousP.toString() + ")."));
                throw new IllegalStateException("Cmd =" + cmd + " already running (pid=" + previousP.toString() + ").");
            }
        }
        Vector<String> envv = new Vector<String>();
        envv.addElement("JAVA_HOME=" + server.getJavaHome());
        envv.addElement("JONAS_ROOT=" + server.getJonasRoot());
        envv.addElement("JONAS_BASE=" + server.getJonasBase());
        String catalinaHome = System.getProperty("catalina.home");
        if (catalinaHome != null) {
            envv.addElement("CATALINA_HOME=" + catalinaHome);
            envv.addElement("CATALINA_BASE=" + server.getJonasBase());
        }
        if ((jettyHome = System.getProperty("jetty.home")) != null) {
            envv.addElement("JETTY_HOME=" + jettyHome);
        }
        if (Env.isOsWindows()) {
            envv.addElement("SystemRoot=" + WinSysEnv.get((String)"SystemRoot"));
        }
        Object[] enva = new String[envv.size()];
        envv.copyInto(enva);
        String binDir = null;
        if (this.isDefinedUserJonasCmd(server)) {
            this.logger.log(BasicLevel.INFO, (Object)"User cmd - don't add the jonas-root prefix dir");
            binDir = "";
        } else {
            this.logger.log(BasicLevel.INFO, (Object)"Default cmd - add the jonas-root prefix dir");
            binDir = server.getJonasRoot();
            if (File.separatorChar == '/') {
                binDir = binDir + "/bin/";
            } else if (File.separatorChar == '\\') {
                binDir = binDir + "\\bin\\";
            }
        }
        String[] cmda = null;
        if (cmd != null) {
            cmda = (binDir + cmd).split("\\s+");
        }
        File workingDirectory = new File(".");
        this.logger.log(BasicLevel.INFO, (Object)("Execute the command <" + binDir + cmd + "> with the env " + envv));
        Process p = Runtime.getRuntime().exec(cmda, (String[])enva, workingDirectory);
        this.processMap.put(keyCmd, p);
        Thread.sleep(2000L);
        InputStream cmdError = p.getErrorStream();
        InputStream cmdOut = p.getInputStream();
        Thread err = new Thread(new CmdReaderThread(this.logger, keyCmd, cmdError, true));
        Thread out = new Thread(new CmdReaderThread(this.logger, keyCmd, cmdOut, false));
        out.start();
        err.start();
        int action = 0;
        if (keyCmd.startsWith("start") && this.isTighlyCoupled()) {
            action = 1;
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHookThread(server.getName(), keyCmd, action, this, this.logger));
        this.logger.log(BasicLevel.INFO, (Object)("Command " + cmd + " with the env " + envv + " launched"));
        return p;
    }

    private boolean isDefinedUserJonasCmd(Server server) {
        if (server.getJonasCmd() == null) {
            return false;
        }
        return !server.getJonasCmd().trim().equals("");
    }

    private String getJOnASCmdName(Server server) {
        if (this.isDefinedUserJonasCmd(server)) {
            return server.getJonasCmd().trim();
        }
        if (Env.isOsWindows()) {
            return JONAS_CMD_NAME_WIN_DEF;
        }
        return JONAS_CMD_NAME_UNIX_DEF;
    }

    private void doStartJOnAS(String name, String prm, boolean sync) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server == null) {
            throw new ClusterDaemonException("JOnAS server " + name + " is not known by the cluster daemon " + this.getName());
        }
        String xprm = null;
        xprm = prm == null ? "" : prm;
        if (server.getXprm() != null) {
            xprm = xprm + server.getXprm();
        }
        String d = this.getDomain4Server(name);
        String cmd = this.getJOnASCmdName(server) + " start -n " + name + " -Ddomain.name=" + d + " " + xprm;
        if (this.isTighlyCoupled()) {
            cmd = cmd + " -fg";
        }
        this.logger.log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " is starting ..."));
        String keyCmd = "start/" + name;
        Process p = null;
        try {
            p = this.execJOnASCmd(server, cmd, keyCmd);
        }
        catch (Throwable t) {
            this.logger.log(BasicLevel.ERROR, (Object)("Unable to start the JOnAS instance <" + name + ">, cmd=<" + cmd + ">"), t);
            throw new ClusterDaemonException("Unable to start the JOnAS instance <" + name + ">, cmd=<" + cmd + ">", t);
        }
        this.logger.log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " launched"));
        if (sync) {
            if (this.isLooselyCoupled()) {
                int exitCode = this.waitEndProcess(p);
            } else if (this.doPingJOnAS(name, 120) == 1) {
                throw new ClusterDaemonException("Unable to start the JOnAS instance " + name + " - unreachable server");
            }
            this.logger.log(BasicLevel.INFO, (Object)("JOnAS instance " + name + "  started"));
        }
    }

    public void doStopJOnAS(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server == null) {
            throw new ClusterDaemonException("JOnAS instance " + name + " doesn't exist");
        }
        String cmd = this.getJOnASCmdName(server) + " stop -n " + server.getName();
        this.logger.log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " is stopping ..."));
        String keyCmd = "stop/" + server.getName();
        Process p = null;
        try {
            p = this.execJOnASCmd(server, cmd, keyCmd);
        }
        catch (Throwable t) {
            this.logger.log(BasicLevel.ERROR, (Object)("Unable to stop the JOnAS instance <" + name + ">, cmd=<" + cmd + ">"), t);
            throw new ClusterDaemonException("Unable to stop the JOnAS instance <" + name + ">, cmd=<" + cmd + ">", t);
        }
        int exitCode = this.waitEndProcess(p);
        this.logger.log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " stopped"));
    }

    private void doHaltJOnAS(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server == null) {
            throw new ClusterDaemonException("JOnAS instance " + name + " doesn't exist");
        }
        String cmd = this.getJOnASCmdName(server) + " halt -n " + server.getName();
        this.logger.log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " is halting ..."));
        String keyCmd = "halt/" + server.getName();
        Process p = null;
        try {
            p = this.execJOnASCmd(server, cmd, keyCmd);
        }
        catch (Throwable t) {
            this.logger.log(BasicLevel.ERROR, (Object)("Unable to halt the JOnAS instance <" + name + ">, cmd=<" + cmd + ">"), t);
            throw new ClusterDaemonException("Unable to halt the JOnAS instance <" + name + ">, cmd=<" + cmd + ">", t);
        }
        int exitCode = this.waitEndProcess(p);
        this.logger.log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " halted"));
    }

    private void doKillJOnAS(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server == null) {
            throw new ClusterDaemonException("JOnAS instance " + name + " doesn't exist");
        }
        if (this.isLooselyCoupled()) {
            throw new ClusterDaemonException("Command not compatible with the loosely-coupled mode");
        }
        String keyCmd = "start/" + server.getName();
        Process p = (Process)this.processMap.get(keyCmd);
        boolean alive = false;
        try {
            this.logger.log(BasicLevel.DEBUG, (Object)("Process=" + p.exitValue()));
            this.logger.log(BasicLevel.DEBUG, (Object)("JOnAS instance " + name + " is already dead"));
        }
        catch (IllegalThreadStateException exc) {
            this.logger.log(BasicLevel.DEBUG, (Object)("JOnAS instance " + server.getName() + " is going to be killed"));
            alive = true;
        }
        if (alive) {
            p.destroy();
            this.logger.log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " killed"));
        } else {
            this.logger.log(BasicLevel.INFO, (Object)("JOnAS instance " + name + " already killed"));
        }
    }

    private int waitEndProcess(Process p) {
        if (p == null) {
            return -1;
        }
        boolean isRunning = true;
        int exitCode = -1;
        while (isRunning) {
            this.logger.log(BasicLevel.DEBUG, (Object)("check if the process " + p + " is running"));
            try {
                exitCode = p.exitValue();
                this.logger.log(BasicLevel.DEBUG, (Object)("cmd " + p + " is finished"));
                isRunning = false;
            }
            catch (IllegalThreadStateException exc) {
                this.logger.log(BasicLevel.DEBUG, (Object)("cmd " + p + " is still running"));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.log(BasicLevel.DEBUG, (Object)e);
                }
            }
        }
        return exitCode;
    }

    private int doPingJOnAS(String name, int timeout) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server == null) {
            throw new ClusterDaemonException("JOnAS instance " + name + " doesn't exist");
        }
        String jonasBase = this.getJonasBase4Server(name);
        String cmd = this.getJOnASCmdName(server) + " admin -n " + server.getName() + " -ping -timeout " + timeout;
        this.logger.log(BasicLevel.INFO, (Object)("Ping JOnAS instance " + name + " ..."));
        String keyCmd = "ping/" + server.getName();
        try {
            this.execJOnASCmd(server, cmd, keyCmd);
        }
        catch (Throwable t) {
            this.logger.log(BasicLevel.ERROR, (Object)("Unable to ping the JOnAS instance <" + name + ">, cmd=<" + cmd + ">"), t);
            throw new ClusterDaemonException("Unable to ping the JOnAS instance <" + name + ">, cmd=<" + cmd + ">", t);
        }
        Process p = (Process)this.processMap.get(keyCmd);
        int exitCode = this.waitEndProcess(p);
        this.logger.log(BasicLevel.INFO, (Object)("Ping JOnAS instance " + name + " return " + exitCode));
        return exitCode;
    }

    private boolean doCheckState(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server == null) {
            throw new ClusterDaemonException("JOnAS instance " + name + " doesn't exist");
        }
        if (this.isLooselyCoupled()) {
            throw new ClusterDaemonException("Command not compatible with the loosely-coupled mode");
        }
        String keyCmd = "start/" + server.getName();
        Process p = (Process)this.processMap.get(keyCmd);
        boolean alive = false;
        try {
            this.logger.log(BasicLevel.DEBUG, (Object)("Process=" + p.exitValue()));
            this.logger.log(BasicLevel.DEBUG, (Object)("JOnAS instance " + name + " is STOPPED"));
        }
        catch (IllegalThreadStateException exc) {
            this.logger.log(BasicLevel.DEBUG, (Object)("JOnAS instance " + server.getName() + " is RUNNING"));
            alive = true;
        }
        return alive;
    }

    public boolean checkServerState(String srvName) throws ClusterDaemonException {
        boolean running = false;
        try {
            running = this.doCheckState(this.name);
        }
        catch (ClusterDaemonException e) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Unabale to get Server State" + (Object)((Object)e)));
            throw e;
        }
        return running;
    }

    private void initLogger() throws ClusterDaemonException {
        if (this.csTraceFile != null) {
            File tClient = new File(this.csTraceFile);
            if (!tClient.exists()) {
                throw new ClusterDaemonException("The file '" + this.csTraceFile + "' was not found.");
            }
            if (!tClient.isFile()) {
                throw new ClusterDaemonException("The file '" + this.csTraceFile + "' is not a valid file. Maybe a directory ?");
            }
            System.setProperty("jonas.client.trace.file", this.csTraceFile);
            Log.reset();
        } else {
            this.csTraceFile = "trace";
        }
        try {
            System.setProperty("jonas.client.trace.file", this.csTraceFile);
            Log.configure((String)this.csTraceFile);
        }
        catch (NoClassDefFoundError ncdfe) {
            ncdfe.printStackTrace();
        }
        this.logger = Log.getLogger((String)"org.ow2.jonas.cluster.daemon");
    }

    private void startNameService() throws ClusterDaemonException {
        NameServiceManager nameServiceManager = NameServiceManager.getNameServiceManager();
        if (!nameServiceManager.isStarted()) {
            this.logger.log(BasicLevel.INFO, (Object)"Name service was not started, starting now.");
            try {
                nameServiceManager.startNS();
            }
            catch (NameServiceException e) {
                throw new ClusterDaemonException("Cannot start registry", (Throwable)e);
            }
        } else {
            this.logger.log(BasicLevel.INFO, (Object)"Name service was already started, skipping.");
        }
    }

    private void initMBeans() throws ClusterDaemonException {
        block22: {
            try {
                MBeanServerHelper.startMBeanServer(domainName);
            }
            catch (MBeanServerException e) {
                throw new ClusterDaemonException("Cannot start MBean server", (Throwable)e);
            }
            try {
                HashMap<String, String> props = null;
                this.name = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getName();
                String url = ClusterDaemonTools.getJmxUrl(this.name);
                String objName = ClusterDaemonTools.getObjectName();
                boolean jmxSecured = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().isJmxSecured();
                MBeanServerForwarder forwarder = null;
                if (jmxSecured) {
                    props = new HashMap<String, String>();
                    String fileSeparator = System.getProperty("file.separator");
                    String loginModule = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getJmxAuthenticationMethod();
                    String loginParam = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getJmxAuthenticationParameter();
                    if (loginModule != null && loginParam != null) {
                        if ("jmx.remote.x.password.file".equals(loginModule)) {
                            props.put(loginModule, JProp.getJonasBase() + fileSeparator + loginParam);
                        } else {
                            props.put(loginModule, loginParam);
                        }
                    }
                    String authModule = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getJmxAuthorizationMethod();
                    String authParam = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getJmxAuthorizationParameter();
                    if (authModule != null && authParam != null) {
                        if (authModule.startsWith("jmx.remote.x.access.rolebased")) {
                            forwarder = RoleBasedAuthorizationModule.newProxyInstance((String)authModule.substring("jmx.remote.x.access.rolebased".length() + 1), (String)authParam);
                        } else if ("jmx.remote.x.access.file".equals(authModule)) {
                            props.put(authModule, JProp.getJonasBase() + fileSeparator + authParam);
                        } else {
                            props.put(authModule, authParam);
                        }
                    }
                }
                JMXConnectorServer connectorServer = JMXRemoteHelper.startConnector(url, objName, props);
                if (forwarder != null) {
                    connectorServer.setMBeanServerForwarder(forwarder);
                }
                this.logger.log(BasicLevel.INFO, (Object)("JMX remote connector (" + url + ", " + objName + " started "));
                this.setJmxUrl(url);
                if (jmxSecured) {
                    try {
                        JMXConnectorFactory.connect(new JMXServiceURL(url)).close();
                        this.logger.log(BasicLevel.WARN, (Object)"JMX security is enabled but anonymous logins are still accepted! Please check your JMX security configuration.");
                        break block22;
                    }
                    catch (SecurityException e) {
                        this.logger.log(BasicLevel.INFO, (Object)"JMX security is enabled and active");
                        break block22;
                    }
                    catch (Exception e) {
                        throw new ClusterDaemonException("Cannot test JMX security", (Throwable)e);
                    }
                }
                this.logger.log(BasicLevel.WARN, (Object)"JMX security is DISABLED");
            }
            catch (JMXRemoteException e) {
                throw new ClusterDaemonException("Cannot start JMX Remote connector", (Throwable)e);
            }
        }
        StringBuffer sb = new StringBuffer(domainName);
        sb.append(":type=ClusterDaemon");
        ObjectName on = null;
        try {
            on = new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new ClusterDaemonException("Cannot build ObjectName", (Throwable)e);
        }
        try {
            MBeanServerHelper.getMBeanServer().registerMBean(this, on);
            this.logger.log(BasicLevel.DEBUG, (Object)("MBean (" + on + ") registered"));
        }
        catch (Exception e) {
            throw new ClusterDaemonException("Cannot register MBean '" + on + "' in MBeanServer", (Throwable)e);
        }
        this.setObjectName(on.toString());
        this.logger.log(BasicLevel.INFO, (Object)"MBeans initialized");
    }

    public void buildRuntimeInfo() {
        this.logger.log(BasicLevel.INFO, (Object)"getting Runtime Mbean");
        RuntimeMXBean mxbean = ManagementFactory.getRuntimeMXBean();
        String vendor = mxbean.getVmVendor();
    }

    private boolean isLooselyCoupled() {
        String mode = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getJonasInteractionMode();
        return LOOSELY_COUPLED.equals(mode);
    }

    private boolean isTighlyCoupled() {
        String mode = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getJonasInteractionMode();
        return TIGHLY_COUPLED.equals(mode);
    }

    private Server getServer(String name) throws ClusterDaemonException {
        try {
            JLinkedList servers = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList();
            if (servers != null) {
                for (int i = 0; i < servers.size(); ++i) {
                    Server serverElement = (Server)servers.get(i);
                    if (!serverElement.getName().equals(name)) continue;
                    return serverElement;
                }
            }
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
        return null;
    }

    private String doStartAllJOnAS(String domainName, String prm, boolean force, boolean sync) throws ClusterDaemonException {
        try {
            if (!force) {
                if (this.isLooselyCoupled()) {
                    String result = "JOnAS interaction mode is set to loosely-coupled => don't start the JOnAS instances";
                    this.logger.log(BasicLevel.INFO, (Object)result);
                    return result;
                }
                this.logger.log(BasicLevel.INFO, (Object)"JOnAS interaction mode is set to tighly-coupled => start the JOnAS instances");
            }
            int nbInst = 0;
            int nbInstStarted = 0;
            String instStarted = "";
            int nbInstStartingError = 0;
            String instStartingError = "";
            JLinkedList servers = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList();
            if (servers != null) {
                for (int i = 0; i < servers.size(); ++i) {
                    ++nbInst;
                    Server serverElement = (Server)servers.get(i);
                    if (!serverElement.isAutoBoot() && !force) continue;
                    try {
                        this.doStartJOnAS(serverElement.getName(), prm, sync);
                        ++nbInstStarted;
                        instStarted = instStarted + serverElement.getName() + " ";
                        continue;
                    }
                    catch (ClusterDaemonException e) {
                        this.logger.log(BasicLevel.ERROR, (Object)("Error during the launching of JOnAS instance " + serverElement.getName()), (Throwable)e);
                        ++nbInstStartingError;
                        instStartingError = instStartingError + serverElement.getName() + " ex=" + (Object)((Object)e) + " ";
                    }
                }
            }
            String result = "Instances started (" + nbInstStarted + "/" + nbInst + ", " + instStarted + ")";
            result = result + " Instances starting failed (" + nbInstStartingError + "/" + nbInst + ", " + instStartingError + ")";
            this.logger.log(BasicLevel.INFO, (Object)result);
            return result;
        }
        catch (Exception e) {
            if (e instanceof ClusterDaemonException) {
                throw (ClusterDaemonException)((Object)e);
            }
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    private String doStopAllJOnAS() {
        int nbInst = 0;
        int nbInstStopped = 0;
        String instStopped = "";
        int nbInstStoppingError = 0;
        String instStoppingError = "";
        JLinkedList servers = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList();
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Server serverElement = (Server)servers.get(i);
                try {
                    this.doStopJOnAS(serverElement.getName());
                    ++nbInstStopped;
                    instStopped = instStopped + serverElement.getName() + " ";
                    continue;
                }
                catch (ClusterDaemonException e) {
                    this.logger.log(BasicLevel.ERROR, (Object)("Error during the stopping of JOnAS instance " + serverElement.getName()), (Throwable)e);
                    ++nbInstStoppingError;
                    instStoppingError = instStoppingError + serverElement.getName() + " ex=" + (Object)((Object)e) + " ";
                }
            }
        }
        String result = "Instances stopped (" + nbInstStopped + "/" + nbInst + ", " + instStopped + ")";
        result = result + " Instances stopping failed (" + nbInstStoppingError + "/" + nbInst + ", " + instStoppingError + ")";
        this.logger.log(BasicLevel.INFO, (Object)result);
        return result;
    }

    private String doKillAllJOnAS() {
        int nbInst = 0;
        int nbInstKilled = 0;
        String instKilled = "";
        int nbInstKillingError = 0;
        String instKillingError = "";
        JLinkedList servers = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList();
        if (servers != null) {
            for (int i = 0; i < servers.size(); ++i) {
                Server serverElement = (Server)servers.get(i);
                try {
                    this.doKillJOnAS(serverElement.getName());
                    ++nbInstKilled;
                    instKilled = instKilled + serverElement.getName() + " ";
                    continue;
                }
                catch (ClusterDaemonException e) {
                    this.logger.log(BasicLevel.ERROR, (Object)("Error during the killing of JOnAS instance " + serverElement.getName()), (Throwable)e);
                    ++nbInstKillingError;
                    instKillingError = instKillingError + serverElement.getName() + " ex=" + (Object)((Object)e) + " ";
                }
            }
        }
        String result = "Instances killed (" + nbInstKilled + "/" + nbInst + ", " + instKilled + ")";
        result = result + " Instances killing failed (" + nbInstKillingError + "/" + nbInst + ", " + instKillingError + ")";
        this.logger.log(BasicLevel.INFO, (Object)result);
        return result;
    }

    @Validate
    public void start() throws ClusterDaemonException {
        this.initLogger();
        this.logger.log(BasicLevel.INFO, (Object)"Starting Cluster Daemon...");
        ClusterDaemonTools.loadClusterDaemonConfiguration(this.confFile);
        this.buildControlledServersNames();
        this.initHostInfos();
        domainName = System.getProperty("domain.name", JONAS_CMD_NAME_UNIX_DEF);
        String confDomainName = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getDomainName();
        if (domainName.equals(JONAS_CMD_NAME_UNIX_DEF)) {
            if (confDomainName == null) {
                this.logger.log(BasicLevel.INFO, (Object)("Domain set with default value : " + domainName));
            } else {
                domainName = confDomainName;
                this.logger.log(BasicLevel.INFO, (Object)("Domain set with the value defined in the clusterd.xml : " + domainName));
            }
        } else if (domainName.equals(confDomainName)) {
            this.logger.log(BasicLevel.INFO, (Object)("Domain set with the value defined in the clusterd.xml : " + domainName));
        } else {
            throw new ClusterDaemonException("Incorrect domain name set in clusterd.xml file and in the property " + confDomainName + "/" + domainName);
        }
        ClusterDaemonTools.initCarol();
        this.startNameService();
        this.logger.log(BasicLevel.INFO, (Object)"Carol initialized!");
        this.initMBeans();
        this.logger.log(BasicLevel.INFO, (Object)"JOnAS Cluster Daemon Started!");
        if (this.useMonitor) {
            new MonitorThread(this.logger).start();
        }
        this.doStartAllJOnAS(domainName, null, false, false);
        this.getDynamicHostAttributes();
        if (ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getDiscovery().getStartDiscovery()) {
            this.startDiscovery();
        }
        this.isStarted = true;
        this.logger.log(BasicLevel.INFO, (Object)"ClusterDaemon started.");
    }

    private void startDiscovery() {
        this.discovery = new JgroupsDiscoveryServiceImpl();
        HashMap<String, Object> discoveryEnv = new HashMap<String, Object>();
        discoveryEnv.put("group.name", ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getDiscovery().getDiscoveryGroupName());
        discoveryEnv.put("jgroups.conf", ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getDiscovery().getDiscoveryStackFile());
        discoveryEnv.put("host.name", ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getName());
        discoveryEnv.put("domain.name", domainName);
        try {
            String[] urls = new String[]{ClusterDaemonTools.getJmxUrl(this.name)};
            discoveryEnv.put("connector.urls", urls);
            this.discovery.start(discoveryEnv, MBeanServerHelper.getMBeanServer(), "CLUSTERD");
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.DEBUG, (Object)"Cluster daemon was unable to start JGroups discovery \n", (Throwable)e);
        }
        this.logger.log(BasicLevel.INFO, (Object)"JGroups discovery started \n");
    }

    private static void usage() {
        System.out.println("Usage : jclusterd [-DdomainName=<name>] [-useMonitor] [-confFile my_clusterd.xml] [-carolFile=<my_carol.properties>]");
    }

    public void displayDynamicAttributes() {
        Hashtable<String, String> myhash = this.dynamicHostAttributes;
        for (String str : myhash.keySet()) {
            String val = myhash.get(str);
            this.logger.log(BasicLevel.DEBUG, (Object)("Key : " + str + " Value " + val));
        }
    }

    public static void main(String[] args) {
        ClusterDaemon cs = new ClusterDaemon();
        try {
            for (int argn = 0; argn < args.length; ++argn) {
                String arg = args[argn];
                try {
                    if (arg.equals("-useMonitor")) {
                        cs.useMonitor = true;
                        continue;
                    }
                    if (arg.equals("-traceFile")) {
                        cs.csTraceFile = args[++argn];
                        continue;
                    }
                    if (arg.equals("-carolFile")) {
                        cs.carolFile = args[++argn];
                        continue;
                    }
                    if (arg.equals("-confFile")) {
                        cs.confFile = args[++argn];
                        continue;
                    }
                    if (!arg.equals("--help") && !arg.equals("-help") && !arg.equals("-h") && !arg.equals("-?")) continue;
                    ClusterDaemon.usage();
                    System.exit(1);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    throw new ClusterDaemonException("A required parameter was missing after the argument" + arg);
                }
            }
            cs.start();
        }
        catch (Exception e) {
            System.err.println("There was the following exception : " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String name) {
        this.objectName = name;
    }

    public boolean iseventProvider() {
        return false;
    }

    public boolean isstateManageable() {
        return false;
    }

    public boolean isstatisticsProvider() {
        return false;
    }

    public String getJavaHome4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getJavaHome();
        }
        return null;
    }

    public String getJonasBase4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getJonasBase();
        }
        return null;
    }

    public String getJonasRoot4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getJonasRoot();
        }
        return null;
    }

    public String getJonasCmd4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getJonasCmd();
        }
        return null;
    }

    public String getXprm4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getXprm();
        }
        return null;
    }

    public String getAutoBoot4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getAutoBoot();
        }
        return null;
    }

    public String getJmxPort4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getJmxPort();
        }
        return null;
    }

    public String getDomain4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            return server.getDomain();
        }
        return null;
    }

    public String getJmxUrl4Server(String name) throws ClusterDaemonException {
        Server server = this.getServer(name);
        if (server != null) {
            String port = server.getJmxPort();
            return "service:jmx:rmi://localhost/jndi/rmi://localhost:" + port + "/jrmpconnector_" + name;
        }
        return null;
    }

    private void buildControlledServersNames() throws ClusterDaemonException {
        try {
            JLinkedList servers = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList();
            if (this.controlledServersNames == null) {
                this.controlledServersNames = new ArrayList();
            }
            if (servers != null) {
                for (int i = 0; i < servers.size(); ++i) {
                    Server serverElement = (Server)servers.get(i);
                    this.controlledServersNames.add(serverElement.getName());
                }
            }
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    private void flushConfiguration() throws ClusterDaemonException {
        String buf = ClusterDaemonTools.getCurrentConfiguration().toXML();
        if (this.confFile == null) {
            this.confFile = ClusterDaemonTools.getCurrentConfigurationFileName();
        }
        try {
            FileWriter fw = new FileWriter(this.confFile);
            fw.write(buf);
            fw.close();
        }
        catch (IOException e) {
            throw new ClusterDaemonException((Throwable)e);
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("Configuration flushed in the file " + this.confFile + "\n" + buf));
    }

    public void removeServer(String serverName) throws ClusterDaemonException {
        if (this.pingJOnAS(serverName) == 0) {
            throw new ClusterDaemonException("Could not delete a running server");
        }
        Server server = this.getServer(serverName);
        if (server == null) {
            this.logger.log(BasicLevel.INFO, (Object)("Server named " + serverName + " can't be removed from cluster daemon " + this.name + "  control as unknown"));
            return;
        }
        String jonasBase = this.getJonasBase4Server(serverName);
        ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList().remove((Object)server);
        this.controlledServersNames.remove(serverName);
        if (jonasBase == null) {
            return;
        }
        File jonasBaseFolder = new File(jonasBase);
        if (jonasBaseFolder.exists()) {
            try {
                this.delete(jonasBaseFolder);
            }
            catch (IOException e) {
                throw new ClusterDaemonException("JOnAS Base could not be deleted for server '" + serverName + "'", (Throwable)e);
            }
        }
    }

    void delete(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                this.delete(c);
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    public void modifyServer(String name, String domain, String description, String javaHome, String jonasRoot, String jonasBase, String xprm, String autoBoot, String jmxPort, String jonasCmd) throws ClusterDaemonException {
        Server myServer = this.getServer(name);
        if (myServer == null) {
            throw new ClusterDaemonException("JOnAS instance " + name + " doesn't exist");
        }
        myServer.setDomain(domain);
        myServer.setDescription(description);
        myServer.setJavaHome(javaHome);
        myServer.setJonasBase(jonasBase);
        myServer.setJonasRoot(jonasRoot);
        myServer.setXprm(xprm);
        myServer.setAutoBoot(autoBoot);
        myServer.setJmxPort(jmxPort);
        myServer.setJonasCmd(jonasCmd);
        this.flushConfiguration();
        this.logger.log(BasicLevel.DEBUG, (Object)("Server " + name + " updated"));
    }

    public void reloadConfiguration() throws ClusterDaemonException {
        ClusterDaemonTools.loadClusterDaemonConfiguration(this.confFile);
    }

    public void startJOnAS(String name, String prm) {
        try {
            this.doStartJOnAS(name, prm, true);
        }
        catch (ClusterDaemonException e) {
            this.logger.log(BasicLevel.ERROR, (Object)("Error during the launching of JOnAS instance " + name), (Throwable)e);
        }
    }

    public void stopJOnAS(String name) throws ClusterDaemonException {
        this.doStopJOnAS(name);
    }

    public void haltJOnAS(String name) throws ClusterDaemonException {
        this.doHaltJOnAS(name);
    }

    public int pingJOnAS(String name) throws ClusterDaemonException {
        return this.doPingJOnAS(name, 2000);
    }

    public String startAllJOnAS(String domainName, String prm) throws ClusterDaemonException {
        return this.doStartAllJOnAS(domainName, prm, true, true);
    }

    public String stopAllJOnAS() {
        return this.doStopAllJOnAS();
    }

    @Invalidate
    public void stopClusterDaemon() {
        if (this.isStarted) {
            this.logger.log(BasicLevel.DEBUG, (Object)"Server not started");
        }
        if (this.discovery != null) {
            this.discovery.stop();
        }
        this.isStarted = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    throw new IllegalStateException("Cannot wait: " + ie.getMessage());
                }
                System.exit(0);
            }
        }).start();
        this.logger.log(BasicLevel.INFO, (Object)"Server stopped");
    }

    public String getName() {
        return this.name;
    }

    public ArrayList getControlledServersNames() throws ClusterDaemonException {
        if (this.controlledServersNames == null) {
            this.buildControlledServersNames();
        }
        return this.controlledServersNames;
    }

    public ArrayList serversNames() throws ClusterDaemonException {
        return this.getControlledServersNames();
    }

    public String getJmxUrl() {
        return this.jmxUrl;
    }

    public void setJmxUrl(String url) {
        this.jmxUrl = url;
    }

    public String getOperatingSystemAvailableProcessors() {
        return this.operatingSystemAvailableProcessors;
    }

    public void setOperatingSystemAvailableProcessors(String operatingSystemAvailableProcessors) {
        this.operatingSystemAvailableProcessors = operatingSystemAvailableProcessors;
    }

    public String getOperatingSystemName() {
        return this.operatingSystemName;
    }

    public void setOperatingSystemName(String operatingSystemName) {
        this.operatingSystemName = operatingSystemName;
    }

    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public void setOperatingSystemVersion(String operatingSystemVersion) {
        this.operatingSystemVersion = operatingSystemVersion;
    }

    public String getRunTimeSpecVendor() {
        return this.runTimeSpecVendor;
    }

    public void setRunTimeSpecVendor(String runTimeSpecVendor) {
        this.runTimeSpecVendor = runTimeSpecVendor;
    }

    public String getRunTimeSpecVersion() {
        return this.runTimeSpecVersion;
    }

    public void setRunTimeSpecVersion(String runTimeSpecVersion) {
        this.runTimeSpecVersion = runTimeSpecVersion;
    }

    public String getRunTimeVmName() {
        return this.runTimeVmName;
    }

    public void setRunTimeVmName(String runTimeVmName) {
        this.runTimeVmName = runTimeVmName;
    }

    public String getRunTimeVmVendor() {
        return this.runTimeVmVendor;
    }

    public void setRunTimeVmVendor(String runTimeVmVendor) {
        this.runTimeVmVendor = runTimeVmVendor;
    }

    public String getRunTimeVmVersion() {
        return this.runTimeVmVersion;
    }

    public void setRunTimeVmVersion(String runTimeVmVersion) {
        this.runTimeVmVersion = runTimeVmVersion;
    }

    public Hashtable<String, String> getDynamicHostAttributes() throws ClusterDaemonException {
        if (this.dynamicHostAttributes == null) {
            this.dynamicHostAttributes = new Hashtable();
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"retrieving cluster daemon's host dynamic information");
        try {
            this.dynamicHostAttributes.put("loadedClassCount", new Integer(classLoadingMxBean.getLoadedClassCount()).toString());
            this.dynamicHostAttributes.put("unloadedClassCount", new Long(classLoadingMxBean.getUnloadedClassCount()).toString());
            this.dynamicHostAttributes.put("threadCount", new Integer(threadMxBean.getThreadCount()).toString());
            this.dynamicHostAttributes.put("totalStartedThreadCount", new Long(threadMxBean.getTotalStartedThreadCount()).toString());
            this.dynamicHostAttributes.put("initHeapMemoryVm", new Long(memoryMXBean.getHeapMemoryUsage().getInit()).toString());
            this.dynamicHostAttributes.put("usedHeapMemoryVm", new Long(memoryMXBean.getHeapMemoryUsage().getUsed()).toString());
            this.dynamicHostAttributes.put("maxHeapMemoryVm", new Long(memoryMXBean.getHeapMemoryUsage().getMax()).toString());
            this.dynamicHostAttributes.put("heapCommittedMemoryVm", new Long(memoryMXBean.getHeapMemoryUsage().getCommitted()).toString());
            this.dynamicHostAttributes.put("initNonHeapMemoryVm", new Long(memoryMXBean.getNonHeapMemoryUsage().getInit()).toString());
            this.dynamicHostAttributes.put("usedNonHeapMemoryVm", new Long(memoryMXBean.getNonHeapMemoryUsage().getUsed()).toString());
            this.dynamicHostAttributes.put("maxNonHeapMemoryVm", new Long(memoryMXBean.getNonHeapMemoryUsage().getMax()).toString());
            this.dynamicHostAttributes.put("CommittedNonHeapMemoryVm", new Long(memoryMXBean.getNonHeapMemoryUsage().getCommitted()).toString());
            this.buildOperatingSystemdynInfo();
            this.displayDynamicAttributes();
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Cannot retrieve cluster daemon's host dynamic information: " + e));
            throw new ClusterDaemonException((Throwable)e);
        }
        finally {
            return this.dynamicHostAttributes;
        }
    }

    private void buildOperatingSystemdynInfo() throws ClusterDaemonException {
        try {
            ObjectName osOn = new ObjectName("java.lang:type=OperatingSystem");
            if (platFormMbeanServer != null && platFormMbeanServer.isRegistered(osOn)) {
                MBeanInfo mbeaInfo = platFormMbeanServer.getMBeanInfo(osOn);
                MBeanAttributeInfo[] atts = mbeaInfo.getAttributes();
                String attrName = null;
                String attrType = null;
                for (int i = 0; i < atts.length; ++i) {
                    attrName = atts[i].getName();
                    attrType = atts[i].getType();
                    if (!attrType.equals(LONG_TYPE_DYN_INFO)) continue;
                    this.logger.log(BasicLevel.DEBUG, (Object)"**** Attribute Info ****");
                    this.logger.log(BasicLevel.DEBUG, (Object)("Name " + atts[i].getName()));
                    this.logger.log(BasicLevel.DEBUG, (Object)("Type " + atts[i].getType()));
                    this.logger.log(BasicLevel.DEBUG, (Object)("isIs " + atts[i].isIs()));
                    this.logger.log(BasicLevel.DEBUG, (Object)("isReadable " + atts[i].isReadable()));
                    this.logger.log(BasicLevel.DEBUG, (Object)("isWritable " + atts[i].isWritable()));
                    Long attrValue = (Long)platFormMbeanServer.getAttribute(osOn, atts[i].getName());
                    this.logger.log(BasicLevel.DEBUG, (Object)("value " + attrValue));
                    this.dynamicHostAttributes.put(attrName, attrValue.toString());
                }
            }
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Unable to get dynamic dynamic infos for the Operating System " + e));
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public void initHostInfos() throws ClusterDaemonException {
        this.logger.log(BasicLevel.INFO, (Object)"Initializing Host monitoring informations");
        try {
            runtimeMxbean = ManagementFactory.getRuntimeMXBean();
            classLoadingMxBean = ManagementFactory.getClassLoadingMXBean();
            threadMxBean = ManagementFactory.getThreadMXBean();
            compilationMxBean = ManagementFactory.getCompilationMXBean();
            garbageCollectorMXBean = ManagementFactory.getGarbageCollectorMXBeans();
            memoryManagerMXBean = ManagementFactory.getMemoryManagerMXBeans();
            memoryMXBean = ManagementFactory.getMemoryMXBean();
            memoryPoolMXBean = ManagementFactory.getMemoryPoolMXBeans();
            platFormMbeanServer = ManagementFactory.getPlatformMBeanServer();
            this.runTimeVmVendor = runtimeMxbean.getVmVendor();
            this.runTimeSpecVendor = runtimeMxbean.getSpecVendor();
            this.runTimeSpecVersion = runtimeMxbean.getSpecName();
            this.runTimeVmName = runtimeMxbean.getVmName();
            this.runTimeVmVersion = runtimeMxbean.getVmVersion();
            operatingSystemMxBean = ManagementFactory.getOperatingSystemMXBean();
            this.operatingSystemAvailableProcessors = new Integer(operatingSystemMxBean.getAvailableProcessors()).toString();
            this.operatingSystemName = operatingSystemMxBean.getName();
            this.operatingSystemVersion = operatingSystemMxBean.getVersion();
            this.operatingSystemArch = operatingSystemMxBean.getArch();
            this.dynamicHostAttributes = new Hashtable();
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.DEBUG, (Object)("cannot get host monitoring informations : " + e));
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public String getOperatingSystemArch() {
        return this.operatingSystemArch;
    }

    public void setOperatingSystemArch(String operatingSystemArch) {
        this.operatingSystemArch = operatingSystemArch;
    }

    public String getVmCurrentUsedNonHeapMemory() throws ClusterDaemonException {
        try {
            long nonheap = memoryMXBean.getNonHeapMemoryUsage().getUsed();
            return new Long(nonheap).toString();
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public String getOsCurrentUsedSpace() throws ClusterDaemonException {
        try {
            long totalPhys = this.getOsAtributeValue("TotalPhysical");
            long totalFree = this.getOsAtributeValue("FreePhysical");
            return new Long(totalPhys - totalFree).toString();
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public String getOsTotalSpace() throws ClusterDaemonException {
        try {
            return this.getOsAtributeValue("TotalPhysical").toString();
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public String getVmCurrentUsedHeapMemory() throws ClusterDaemonException {
        try {
            long memusage = memoryMXBean.getHeapMemoryUsage().getUsed();
            return new Long(memusage).toString();
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public String getVmCurrentUsedMemory() throws ClusterDaemonException {
        try {
            long heapmem = memoryMXBean.getHeapMemoryUsage().getUsed();
            long nonHeapmem = memoryMXBean.getNonHeapMemoryUsage().getUsed();
            return new Long(heapmem + nonHeapmem).toString();
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public String getVmTotalMemory() throws ClusterDaemonException {
        try {
            long committed = memoryMXBean.getHeapMemoryUsage().getCommitted();
            long usage = memoryMXBean.getNonHeapMemoryUsage().getCommitted();
            return new Long(committed + usage).toString();
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    private Long getOsAtributeValue(String key) throws ClusterDaemonException {
        try {
            ObjectName osOn = new ObjectName("java.lang:type=OperatingSystem");
            if (platFormMbeanServer != null && platFormMbeanServer.isRegistered(osOn)) {
                int i;
                MBeanInfo mbeaInfo = platFormMbeanServer.getMBeanInfo(osOn);
                MBeanAttributeInfo[] atts = mbeaInfo.getAttributes();
                Object attrName = null;
                for (i = 0; !atts[i].getName().contains(key) && i < atts.length; ++i) {
                }
                if (i < atts.length) {
                    return (Long)platFormMbeanServer.getAttribute(osOn, atts[i].getName());
                }
                throw new ClusterDaemonException("Key {0} in Operating System mbean" + key);
            }
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Unable to get dynamic dynamic infos for the Operating System " + e));
            throw new ClusterDaemonException((Throwable)e);
        }
        return null;
    }

    public void addServer(String name, String domain, String description, String jonasRoot, String jonasBase, String javaHome, String xprem, String autoBoot, String jmxPort, String jonasCmd, String saveIt) throws ClusterDaemonException {
        try {
            JLinkedList servers = ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList();
            Server srv = new Server();
            srv.setName(name);
            srv.setDomain(domain);
            srv.setJonasRoot(jonasRoot);
            srv.setJonasBase(jonasBase);
            srv.setJavaHome(javaHome);
            srv.setXprm(xprem);
            srv.setAutoBoot(autoBoot);
            srv.setJmxPort(jmxPort);
            srv.setJonasCmd(jonasCmd);
            servers.add((Object)srv);
            if (saveIt.equals("true")) {
                try {
                    this.flushConfiguration();
                }
                catch (Exception e) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Cannot flush configuration for cluster daemon named" + this.name));
                    return;
                }
            }
            this.controlledServersNames.add(srv.getName());
            this.logger.log(BasicLevel.DEBUG, (Object)("Server named " + name + " successfully added to cluster daemon " + this.name + "control"));
        }
        catch (Exception e) {
            throw new ClusterDaemonException((Throwable)e);
        }
    }

    public void removeServer(String serverName, String saveIt) throws ClusterDaemonException {
        if (this.pingJOnAS(serverName) == 0) {
            throw new ClusterDaemonException("Could not delete a running server");
        }
        Server server = this.getServer(serverName);
        if (server != null) {
            try {
                ClusterDaemonTools.getCurrentConfiguration().getClusterDaemon().getServerList().remove((Object)server);
                if (saveIt.equals("true")) {
                    this.flushConfiguration();
                }
            }
            catch (ClusterDaemonException e) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Cannot flush configuration for cluster daemon named" + this.name));
                return;
            }
            String jonasBase = server.getJonasBase();
            this.controlledServersNames.remove(serverName);
            if (jonasBase == null) {
                return;
            }
            File jonasBaseFolder = new File(jonasBase);
            if (jonasBaseFolder.exists()) {
                try {
                    this.delete(jonasBaseFolder);
                }
                catch (IOException e) {
                    throw new ClusterDaemonException("JOnAS Base could not be deleted for server '" + serverName + "'", (Throwable)e);
                }
            }
            this.logger.log(BasicLevel.INFO, (Object)("Server named " + serverName + " successfully removed from cluster daemon " + this.name + "  control"));
        } else {
            this.logger.log(BasicLevel.INFO, (Object)("Server named " + serverName + " can't be removed from cluster daemon " + this.name + "  control as not known"));
        }
    }

    public void saveConfiguration() throws ClusterDaemonException {
        this.flushConfiguration();
    }
}

